/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import net.imagej.patcher.CodeHacker;
import net.imagej.patcher.LegacyClassLoader;
import net.imagej.patcher.LegacyExtensions;
import net.imagej.patcher.LegacyHooks;
import net.imagej.patcher.LegacyInjector;

public class LegacyEnvironment {
    private final boolean headless;
    private final LegacyInjector injector;
    private Throwable initializationStackTrace;
    private ClassLoader loader;
    private Method setOptions;
    private Method run;
    private Method runMacro;
    private Method runPlugIn;
    private Method main;
    private Field _hooks;

    public LegacyEnvironment(ClassLoader loader, boolean headless) throws ClassNotFoundException {
        this(loader, headless, new LegacyInjector());
    }

    LegacyEnvironment(ClassLoader loader, boolean headless, LegacyInjector injector) throws ClassNotFoundException {
        this.headless = headless;
        this.loader = loader;
        this.injector = injector;
    }

    private boolean isInitialized() {
        return this._hooks != null;
    }

    private synchronized void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.initializationStackTrace = new Throwable("Initialized here:");
        try {
            this.loader = this.loader != null ? this.loader : new LegacyClassLoader();
            this.injector.injectHooks(this.loader, this.headless);
            Class<?> ij = this.loader.loadClass("ij.IJ");
            Class<?> imagej = this.loader.loadClass("ij.ImageJ");
            Class<?> macro = this.loader.loadClass("ij.Macro");
            this._hooks = ij.getField("_hooks");
            this.setOptions = macro.getMethod("setOptions", String.class);
            this.run = ij.getMethod("run", String.class, String.class);
            this.runMacro = ij.getMethod("runMacro", String.class, String.class);
            this.runPlugIn = ij.getMethod("runPlugIn", String.class, String.class);
            this.main = imagej.getMethod("main", String[].class);
        }
        catch (Exception e) {
            throw new RuntimeException("Found incompatible ij.IJ class", e);
        }
    }

    private void ensureUninitialized() {
        if (this.isInitialized()) {
            StringWriter string = new StringWriter();
            PrintWriter writer = new PrintWriter(string);
            this.initializationStackTrace.printStackTrace(writer);
            writer.close();
            throw new RuntimeException("LegacyEnvironment was already initialized:\n\n" + string.toString().replaceAll("(?m)^", "\t"));
        }
    }

    public void disableIJ1PluginDirs() {
        this.ensureUninitialized();
        this.injector.after.add(new LegacyInjector.Callback(){

            @Override
            public void call(CodeHacker hacker) {
                hacker.insertAtBottomOfMethod("net.imagej.patcher.EssentialLegacyHooks", "public <init>()", "enableIJ1PluginDirs(false);");
            }
        });
    }

    public void disableInitializer() {
        this.ensureUninitialized();
        this.injector.after.add(new LegacyInjector.Callback(){

            @Override
            public void call(CodeHacker hacker) {
                hacker.replaceCallInMethod("net.imagej.patcher.EssentialLegacyHooks", "public void initialized()", "net.imagej.patcher.EssentialLegacyHooks", "runInitializer", "");
            }
        });
    }

    public void noPluginClassLoader() {
        this.ensureUninitialized();
        this.injector.after.add(new LegacyInjector.Callback(){

            @Override
            public void call(CodeHacker hacker) {
                LegacyExtensions.noPluginClassLoader(hacker);
            }
        });
    }

    public void suppressIJ1ScriptDiscovery() {
        this.ensureUninitialized();
        this.injector.after.add(new LegacyInjector.Callback(){

            @Override
            public void call(CodeHacker hacker) {
                LegacyExtensions.suppressIJ1ScriptDiscovery(hacker);
            }
        });
    }

    public void addPluginClasspath(ClassLoader fromClassLoader) {
        if (fromClassLoader == null) {
            return;
        }
        this.ensureUninitialized();
        StringBuilder errors = new StringBuilder();
        Collection<File> files = LegacyHooks.getClasspathElements(fromClassLoader, errors, this.loader, this.loader == null ? null : this.loader.getParent(), this.getClass().getClassLoader().getParent());
        if (errors.length() > 0) {
            throw new IllegalArgumentException(errors.toString());
        }
        for (File file : files) {
            this.addPluginClasspath(file);
        }
    }

    public void addPluginClasspath(File ... classpathEntries) {
        if (classpathEntries.length == 0) {
            return;
        }
        this.ensureUninitialized();
        final StringBuilder builder = new StringBuilder();
        for (File file : classpathEntries) {
            String quoted = file.getPath().replaceAll("[\\\"\\\\]", "\\\\$0");
            quoted = quoted.replaceAll("\n", "\\n");
            builder.append("addPluginClasspath(new java.io.File(\"").append(quoted).append("\"));");
        }
        this.injector.after.add(new LegacyInjector.Callback(){

            @Override
            public void call(CodeHacker hacker) {
                hacker.insertAtBottomOfMethod("net.imagej.patcher.EssentialLegacyHooks", "public <init>()", builder.toString());
            }
        });
    }

    public void setMacroOptions(String options) {
        this.initialize();
        try {
            this.setOptions.invoke(null, options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void run(String command, String options) {
        this.initialize();
        Thread thread = Thread.currentThread();
        ClassLoader savedLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            this.run.invoke(null, command, options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            thread.setContextClassLoader(savedLoader);
        }
    }

    public void runMacro(String macro, String arg) {
        this.initialize();
        Thread thread = Thread.currentThread();
        String savedName = thread.getName();
        thread.setName("Run$_" + savedName);
        ClassLoader savedLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            this.runMacro.invoke(null, macro, arg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            thread.setName(savedName);
            thread.setContextClassLoader(savedLoader);
        }
    }

    public Object runPlugIn(String className, String arg) {
        this.initialize();
        Thread thread = Thread.currentThread();
        String savedName = thread.getName();
        thread.setName("Run$_" + savedName);
        ClassLoader savedLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            Object object = this.runPlugIn.invoke(null, className, arg);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            thread.setName(savedName);
            thread.setContextClassLoader(savedLoader);
        }
    }

    public void main(String ... args) {
        this.initialize();
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            this.main.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object newImageJ1(boolean hidden) {
        this.initialize();
        try {
            if (this.headless) {
                if (!hidden) {
                    throw new IllegalArgumentException("In headless mode, ImageJ 1.x must be hidden");
                }
                this.runPlugIn("ij.IJ.init", null);
                return null;
            }
            Class<?> clazz = this.getClassLoader().loadClass("ij.ImageJ");
            int mode = hidden ? 2 : 0;
            return clazz.getConstructor(Integer.TYPE).newInstance(mode);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    public synchronized void applyPatches() {
        if (this.isInitialized()) {
            throw new RuntimeException("Already initialized:", this.initializationStackTrace);
        }
        this.initialize();
    }

    public ClassLoader getClassLoader() {
        this.initialize();
        return this.loader;
    }

    public Map<String, String> getMenuStructure() {
        this.initialize();
        try {
            LegacyHooks hooks = (LegacyHooks)this._hooks.get(null);
            return hooks.getMenuStructure();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LegacyEnvironment getPatchedImageJ1() throws ClassNotFoundException {
        boolean headless = GraphicsEnvironment.isHeadless();
        return new LegacyEnvironment(new LegacyClassLoader(headless), headless);
    }

    public static boolean isImageJ1Initialized(ClassLoader loader) {
        if (!LegacyInjector.alreadyPatched(loader)) {
            return false;
        }
        try {
            return loader.loadClass("ij.IJ").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]) != null;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Problem accessing ImageJ 1.x in class loader " + loader, t);
        }
    }
}

