/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.jupyter;

import com.twosigma.beaker.jupyter.handler.CommCloseHandler;
import com.twosigma.beaker.jupyter.handler.CommInfoHandler;
import com.twosigma.beaker.jupyter.handler.CommMsgHandler;
import com.twosigma.beaker.jupyter.handler.CommOpenHandler;
import com.twosigma.beaker.jupyter.handler.ExecuteRequestHandler;
import com.twosigma.beaker.jupyter.msg.JupyterMessages;
import com.twosigma.beaker.jupyter.msg.MessageCreator;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.handler.CompleteHandler;
import com.twosigma.jupyter.handler.Handler;
import com.twosigma.jupyter.handler.HistoryHandler;
import com.twosigma.jupyter.handler.IsCompleteRequestHandler;
import com.twosigma.jupyter.handler.KernelHandler;
import com.twosigma.jupyter.message.Message;
import java.util.HashMap;
import java.util.Map;

public class KernelHandlers {
    private Map<JupyterMessages, KernelHandler<Message>> handlers;
    private KernelFunctionality kernel;

    public KernelHandlers(KernelFunctionality kernel, CommOpenHandler commOpenHandler, KernelHandler<Message> kernelInfoHandler) {
        this.kernel = kernel;
        this.handlers = this.createHandlers(commOpenHandler, kernelInfoHandler);
    }

    private Map<JupyterMessages, KernelHandler<Message>> createHandlers(CommOpenHandler commOpenHandler, KernelHandler<Message> kernelInfoHandler) {
        HashMap<JupyterMessages, KernelHandler<Message>> handlers = new HashMap<JupyterMessages, KernelHandler<Message>>();
        if (kernelInfoHandler != null) {
            handlers.put(JupyterMessages.KERNEL_INFO_REQUEST, kernelInfoHandler);
        }
        if (commOpenHandler != null) {
            handlers.put(JupyterMessages.COMM_OPEN, commOpenHandler);
        }
        handlers.put(JupyterMessages.EXECUTE_REQUEST, new ExecuteRequestHandler(this.kernel));
        handlers.put(JupyterMessages.COMPLETE_REQUEST, new CompleteHandler(this.kernel));
        handlers.put(JupyterMessages.HISTORY_REQUEST, new HistoryHandler(this.kernel));
        handlers.put(JupyterMessages.COMM_INFO_REQUEST, new CommInfoHandler(this.kernel));
        handlers.put(JupyterMessages.COMM_CLOSE, new CommCloseHandler(this.kernel));
        handlers.put(JupyterMessages.COMM_MSG, new CommMsgHandler(this.kernel, new MessageCreator(this.kernel)));
        handlers.put(JupyterMessages.IS_COMPLETE_REQUEST, new IsCompleteRequestHandler(this.kernel));
        return handlers;
    }

    public Handler<Message> get(JupyterMessages type) {
        return this.handlers.get((Object)type);
    }

    public void exit() {
        for (KernelHandler<Message> handler : this.handlers.values()) {
            handler.exit();
        }
    }
}

