/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter.comm;

import com.twosigma.beaker.jupyter.comm.BaseHandler;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.KernelParameters;
import com.twosigma.jupyter.handler.KernelHandlerWrapper;
import com.twosigma.jupyter.message.Message;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelControlSetShellHandler
extends BaseHandler<List<String>> {
    public static final String IMPORTS = "imports";
    public static final String CLASSPATH = "classpath";
    public static final String KERNEL_CONTROL_RESPONSE = "kernel_control_response";
    public static final String RESPONSE_OK = "OK";
    public static final String RESPONSE_ERROR = "ERROR";
    private static final Logger logger = LoggerFactory.getLogger(KernelControlSetShellHandler.class);

    public KernelControlSetShellHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle(this.kernel, message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        boolean ok;
        logger.debug("Handing comm message content");
        Map<String, List<String>> shell = this.getData(message);
        if (shell != null && (ok = this.handleData(shell))) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(KERNEL_CONTROL_RESPONSE, ok ? RESPONSE_OK : RESPONSE_ERROR);
            this.publish(this.createReplyMessage(message, data));
        }
    }

    public boolean handleData(Map<String, List<String>> data) {
        boolean ret = false;
        if (data.containsKey("beakerx_kernel_parameters")) {
            Map beakerxKernelParameters = (Map)((Object)data.get("beakerx_kernel_parameters"));
            this.kernel.setShellOptions(new KernelParameters(beakerxKernelParameters));
            ret = true;
        }
        return ret;
    }

    @Override
    public String getHandlerCommand() {
        return null;
    }
}

