/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.easyform;

import com.twosigma.beaker.easyform.DisplayEasyForm;
import com.twosigma.beaker.easyform.EasyFormComponent;
import com.twosigma.beaker.easyform.ObservableMap;
import com.twosigma.beaker.easyform.formitem.ButtonComponent;
import com.twosigma.beaker.easyform.formitem.ListComponent;
import com.twosigma.beaker.easyform.formitem.LoadValuesButton;
import com.twosigma.beaker.easyform.formitem.SaveValuesButton;
import com.twosigma.beaker.easyform.formitem.TextArea;
import com.twosigma.beaker.easyform.formitem.widgets.ButtonComponentWidget;
import com.twosigma.beaker.easyform.formitem.widgets.CheckBoxGroupWidget;
import com.twosigma.beaker.easyform.formitem.widgets.CheckBoxWidget;
import com.twosigma.beaker.easyform.formitem.widgets.ComboBoxWidget;
import com.twosigma.beaker.easyform.formitem.widgets.DatePickerComponentWidget;
import com.twosigma.beaker.easyform.formitem.widgets.RadioButtonComponentWidget;
import com.twosigma.beaker.easyform.formitem.widgets.SelectMultipleSingleWidget;
import com.twosigma.beaker.easyform.formitem.widgets.SelectMultipleWidget;
import com.twosigma.beaker.easyform.formitem.widgets.TextAreaWidget;
import com.twosigma.beaker.easyform.formitem.widgets.TextFieldWidget;
import com.twosigma.beaker.widgets.CommFunctionality;
import com.twosigma.beaker.widgets.DOMWidget;
import com.twosigma.beaker.widgets.DisplayableWidget;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EasyForm
extends ObservableMap<String, Object>
implements DisplayableWidget {
    public static final Integer HORIZONTAL = 1;
    public static final Integer VERTICAL = 2;
    private static final Integer AUTO_WIDTH = -1;
    private final String caption;
    private String id;
    private Boolean ready = Boolean.FALSE;
    private Map<String, EasyFormComponent> componentMap = new LinkedHashMap<String, EasyFormComponent>();
    private SaveValuesButton saveValuesButton;
    private LoadValuesButton loadValuesButton;

    public EasyForm(String caption) {
        this.caption = caption;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addSaveValuesButton(String path) {
        SaveValuesButton button = new SaveValuesButton();
        button.setPath(path);
        this.saveValuesButton = button;
    }

    public void addLoadValuesButton(String path) {
        LoadValuesButton button = new LoadValuesButton();
        button.setPath(path);
        this.loadValuesButton = button;
    }

    public EasyFormComponent addTextField(String label) throws Exception {
        return this.addTextField(label, -1);
    }

    public EasyFormComponent addTextField(String label, Integer width) throws Exception {
        TextFieldWidget textField = new TextFieldWidget();
        textField.registerUpdateValueCallback(textField::fireChanged);
        textField.setLabel(label);
        textField.setWidth(width);
        return this.addComponentOrThrow(label, textField);
    }

    public EasyFormComponent addTextArea(String label) throws Exception {
        return this.addTextArea(label, null, TextArea.AUTO_WIDTH, TextArea.AUTO_HEIGHT);
    }

    public EasyFormComponent addTextArea(String label, Integer width, Integer height) throws Exception {
        return this.addTextArea(label, null, width, height);
    }

    public EasyFormComponent addTextArea(String label, String initialValue) throws Exception {
        return this.addTextArea(label, initialValue, TextArea.AUTO_WIDTH, TextArea.AUTO_HEIGHT);
    }

    public EasyFormComponent addTextArea(String label, String initialValue, Integer width, Integer height) throws Exception {
        TextAreaWidget textArea = new TextAreaWidget();
        textArea.registerUpdateValueCallback(textArea::fireChanged);
        textArea.setLabel(label);
        textArea.setWidth(width);
        textArea.setHeight(height);
        textArea.setValue(initialValue);
        return this.addComponentOrThrow(label, textArea);
    }

    public EasyFormComponent addCheckBox(String label) throws Exception {
        return this.addCheckBox(label, Boolean.FALSE);
    }

    public EasyFormComponent addCheckBox(String label, Boolean value) throws Exception {
        CheckBoxWidget checkBox = new CheckBoxWidget();
        checkBox.registerUpdateValueCallback(checkBox::fireChanged);
        checkBox.setLabel(label);
        checkBox.setValue(String.valueOf(value));
        return this.addComponentOrThrow(label, checkBox);
    }

    public EasyFormComponent addComboBox(String label, Collection<String> values) throws Exception {
        return this.addComboBox(label, values, Boolean.FALSE);
    }

    public EasyFormComponent addComboBox(String label, Collection<String> values, Boolean editable) throws Exception {
        return this.addComboBox(label, values, editable, AUTO_WIDTH);
    }

    public EasyFormComponent addComboBox(String label, Collection<String> values, Boolean editable, Integer width) throws Exception {
        ComboBoxWidget comboBox = new ComboBoxWidget();
        comboBox.registerUpdateValueCallback(comboBox::fireChanged);
        comboBox.setLabel(label);
        comboBox.setEditable(editable);
        comboBox.setValues(values);
        comboBox.setWidth(width);
        if (values != null && values.size() > 0) {
            comboBox.setValue(values.iterator().next());
        }
        return this.addComponentOrThrow(label, comboBox);
    }

    public EasyFormComponent addList(String label, Collection<String> values) throws Exception {
        return this.addList(label, values, Boolean.TRUE, values.size());
    }

    public EasyFormComponent addList(String label, Collection<String> values, Boolean multipleSelection) throws Exception {
        return this.addList(label, values, multipleSelection, values.size());
    }

    public EasyFormComponent addList(String label, Collection<String> values, Integer size) throws Exception {
        return this.addList(label, values, Boolean.TRUE, size);
    }

    public EasyFormComponent addList(String label, Collection<String> values, Boolean multipleSelection, Integer size) throws Exception {
        ListComponent list = multipleSelection != false ? this.createSelectMultipleWidget() : this.createSelectMultipleSingleWidget();
        list.setLabel(label);
        list.setSize(size);
        list.setMultipleSelection(multipleSelection);
        list.setValues(values);
        if (values != null && values.size() > 0) {
            list.setValue(values.iterator().next());
        }
        return this.addComponentOrThrow(label, list);
    }

    private ListComponent createSelectMultipleSingleWidget() {
        SelectMultipleSingleWidget list = new SelectMultipleSingleWidget();
        list.registerUpdateValueCallback(list::fireChanged);
        return list;
    }

    private ListComponent createSelectMultipleWidget() {
        SelectMultipleWidget list = new SelectMultipleWidget();
        list.registerUpdateValueCallback(list::fireChanged);
        return list;
    }

    public EasyFormComponent addRadioButtons(String label, Collection<String> values) throws Exception {
        return this.addRadioButtons(label, values, VERTICAL);
    }

    public EasyFormComponent addRadioButtons(String label, Collection<String> values, Integer orientation) throws Exception {
        RadioButtonComponentWidget radioButtonComponent = new RadioButtonComponentWidget();
        radioButtonComponent.registerUpdateValueCallback(radioButtonComponent::fireChanged);
        radioButtonComponent.setLabel(label);
        radioButtonComponent.setHorizontal(orientation != null && HORIZONTAL.equals(orientation));
        radioButtonComponent.setValues(values);
        return this.addComponentOrThrow(label, radioButtonComponent);
    }

    public EasyFormComponent addCheckBoxes(String label, Collection<String> values) throws Exception {
        return this.addCheckBoxes(label, values, VERTICAL);
    }

    public EasyFormComponent addCheckBoxes(String label, Collection<String> values, Integer orientation) throws Exception {
        CheckBoxGroupWidget checkBoxGroup = new CheckBoxGroupWidget();
        checkBoxGroup.setLabel(label);
        checkBoxGroup.setHorizontal(orientation != null && HORIZONTAL.equals(orientation));
        checkBoxGroup.setValues(values);
        checkBoxGroup.createWidget();
        checkBoxGroup.registerUpdateValueCallback(checkBoxGroup::fireChanged);
        return this.addComponentOrThrow(label, checkBoxGroup);
    }

    public EasyFormComponent addDatePicker(String label) throws Exception {
        return this.addDatePicker(label, Boolean.FALSE);
    }

    public EasyFormComponent addDateTimePicker(String label) throws Exception {
        return this.addDatePicker(label, Boolean.TRUE);
    }

    public EasyFormComponent addDatePicker(String label, Boolean showTime) throws Exception {
        DatePickerComponentWidget datePickerComponent = new DatePickerComponentWidget();
        datePickerComponent.registerUpdateValueCallback(datePickerComponent::fireChanged);
        datePickerComponent.setLabel(label);
        datePickerComponent.setShowTime(showTime);
        return this.addComponentOrThrow(label, datePickerComponent);
    }

    public ButtonComponent addButton(String label) throws Exception {
        return this.addButton(label, null);
    }

    public ButtonComponent addButton(String label, String actionCellTag) throws Exception {
        ButtonComponentWidget buttonComponent = new ButtonComponentWidget();
        buttonComponent.registerUpdateValueCallback(buttonComponent::fireChanged);
        buttonComponent.setLabel(label);
        buttonComponent.setTag(actionCellTag);
        this.addComponentOrThrow(label, buttonComponent);
        return buttonComponent;
    }

    private EasyFormComponent addComponentOrThrow(String label, EasyFormComponent component) throws Exception {
        if (this.getComponentMap().containsKey(label)) {
            throw new Exception(String.format("EasyForm already contains component with such label: %s.", label));
        }
        this.getComponentMap().put(label, component);
        return component;
    }

    public Map<String, EasyFormComponent> getComponentMap() {
        return this.componentMap;
    }

    public DOMWidget get(String key) {
        return this.getComponentMap().get(key).getWidget();
    }

    public List<CommFunctionality> getCommFunctionalities() {
        return this.componentMap.values().stream().filter(x -> x instanceof CommFunctionality).map(x -> (CommFunctionality)((Object)x)).collect(Collectors.toList());
    }

    public boolean hasComponents() {
        return this.getComponentMap().size() > 0;
    }

    public boolean hasSaveValuesButton() {
        return this.saveValuesButton != null;
    }

    public boolean hasLoadValuesButton() {
        return this.loadValuesButton != null;
    }

    public SaveValuesButton getSaveValuesButton() {
        return this.saveValuesButton;
    }

    public LoadValuesButton getLoadValuesButton() {
        return this.loadValuesButton;
    }

    public String getCaption() {
        return this.caption;
    }

    private HashMap<String, Object> getValuesMap() {
        return this.mapInstance;
    }

    @Override
    public String get(Object key) {
        this.checkComponentExists((String)key);
        return this.getComponentMap().get(key).getValue();
    }

    @Override
    public String put(String key, Object value) {
        this.checkComponentExists(key);
        EasyFormComponent component = this.getComponentMap().get(key);
        if (!component.checkValue(value)) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid option for %s \"%s\".", value, component.getClass().getSimpleName(), key));
        }
        String currentValue = component.formatValue(value);
        String previousValue = component.getValue();
        component.setValue(currentValue);
        this.getValuesMap().put(key, currentValue);
        this.setChanged();
        this.notifyObservers();
        component.fireChanged();
        return previousValue;
    }

    private void checkComponentExists(String key) {
        if (!this.componentExists(key)) {
            throw new IllegalArgumentException(String.format("The requested component \"%s\" does not exist.", key));
        }
    }

    private boolean componentExists(String key) {
        return this.getComponentMap().containsKey(key);
    }

    public void setEnabled(String label, Boolean enabled) {
        if (StringUtils.isNotEmpty((CharSequence)label) && this.componentMap.containsKey(label)) {
            this.componentMap.get(label).setEnabled(enabled);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Boolean isReady() {
        return this.ready;
    }

    public void setReady() {
        this.ready = Boolean.TRUE;
        for (EasyFormComponent component : this.getComponentMap().values()) {
            if (!component.isButton()) {
                this.getValuesMap().put(component.getLabel(), component.getValue());
            }
            component.fireInit();
        }
    }

    public void setNotReady() {
        this.ready = Boolean.FALSE;
    }

    @Override
    public void display() {
        DisplayEasyForm.display(this);
    }
}

