/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.chart.treemap.util;

import com.twosigma.beaker.chart.Color;
import com.twosigma.beaker.chart.treemap.util.ColorProvider;
import java.lang.reflect.Field;
import java.util.List;
import java.util.TreeMap;
import net.sf.jtreemap.swing.TreeMapNode;

public class RandomColorProvider
extends ColorProvider {
    private static final Color[] COLOURS = new Color[]{new Color(33, 87, 141), new Color(140, 29, 23), new Color(150, 130, 54), new Color(20, 30, 120), new Color(54, 100, 54), new Color(0, 30, 50), new Color(102, 102, 51), new Color(255, 51, 153), new Color(255, 153, 51), new Color(204, 204, 51), new Color(205, 102, 204), new Color(51, 153, 255), new Color(153, 102, 0)};
    private int cursor = 0;
    private final Color[] colours;
    private boolean groupByParent = false;
    private final TreeMap<Object, Color> mapping = new TreeMap();

    public RandomColorProvider() {
        this.colours = COLOURS;
    }

    public RandomColorProvider(Color[] colours) {
        this.colours = colours;
    }

    public RandomColorProvider(List<Object> colors) {
        this.colours = new Color[colors.size()];
        for (int i = 0; i < colors.size(); ++i) {
            this.colours[i] = this.createChartColor(colors.get(i));
        }
    }

    @Override
    public Color getColor(TreeMapNode node) {
        Object value = this.groupByParent && node.getParent() instanceof TreeMapNode ? ((TreeMapNode)node.getParent()).getLabel() : Double.valueOf(this.getValue(node));
        if (!this.mapping.containsKey(value)) {
            this.mapping.put(value, this.colours[this.cursor]);
            ++this.cursor;
            if (this.cursor == this.colours.length) {
                this.cursor = 0;
            }
        }
        return this.mapping.get(value);
    }

    private Color createChartColor(Object color) {
        if (color instanceof List) {
            try {
                return new Color((Integer)((List)color).get(0), (Integer)((List)color).get(1), (Integer)((List)color).get(2));
            }
            catch (IndexOutOfBoundsException x) {
                throw new RuntimeException("Color list too short");
            }
        }
        String colorAsStr = (String)color;
        if (colorAsStr.indexOf("#") == 0) {
            return Color.decode(colorAsStr);
        }
        return this.colorFromName(colorAsStr);
    }

    private Color colorFromName(String color) {
        try {
            Field field = Class.forName("com.twosigma.beaker.chart.Color").getField(color);
            return (Color)field.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException x) {
            throw new RuntimeException(String.format("Can not parse color '%s'", color), x);
        }
    }

    public boolean isGroupByParent() {
        return this.groupByParent;
    }

    public void setGroupByParent(boolean groupByParent) {
        this.groupByParent = groupByParent;
    }
}

