/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beaker.chart.Color;
import com.twosigma.beaker.chart.serializer.ChartSerializer;
import com.twosigma.beaker.chart.treemap.TreeMap;
import com.twosigma.beaker.chart.treemap.util.IToolTipBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jtreemap.swing.TreeMapNode;

public class TreeMapSerializer
extends ChartSerializer<TreeMap> {
    protected String toHex(Color col) {
        return "#" + Integer.toHexString(col.getRGB()).substring(2);
    }

    public void serialize(final TreeMap treeMap, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        TreeMapNode root = treeMap.getRoot();
        this.process(root, new Visitor<TreeMapNode>(){

            @Override
            public void visit(TreeMapNode node) {
                Color color;
                HashMap<String, Object> values;
                Object userObject = node.getUserObject();
                if (userObject instanceof Map) {
                    values = (HashMap<String, Object>)userObject;
                    if (node.isLeaf()) {
                        color = treeMap.getColorProvider().getColor(node);
                        values.put("color", TreeMapSerializer.this.toHex(color));
                        IToolTipBuilder toolTipBuilder = treeMap.getToolTipBuilder();
                        if (toolTipBuilder != null) {
                            values.put("tooltip", toolTipBuilder.getToolTip(node));
                        } else {
                            values.put("tooltip", values.get("label"));
                        }
                    }
                    node.setUserObject(values);
                } else {
                    values = new HashMap<String, Object>();
                    values.put("label", userObject);
                    IToolTipBuilder toolTipBuilder = treeMap.getToolTipBuilder();
                    if (toolTipBuilder != null) {
                        values.put("tooltip", toolTipBuilder.getToolTip(node));
                    } else {
                        values.put("tooltip", userObject);
                    }
                }
                if (node.isLeaf()) {
                    color = treeMap.getColorProvider().getColor(node);
                    values.put("color", TreeMapSerializer.this.toHex(color));
                }
                node.setUserObject(values);
            }
        });
        jgen.writeStartObject();
        this.serialize(treeMap, jgen);
        if (root != null) {
            jgen.writeObjectField("graphics_list", (Object)root);
        }
        if (treeMap.getMode() != null) {
            jgen.writeObjectField("mode", (Object)treeMap.getMode().getJsName());
        }
        if (treeMap.getSticky() != null) {
            jgen.writeObjectField("sticky", (Object)treeMap.getSticky());
        }
        if (treeMap.getRatio() != null) {
            jgen.writeObjectField("ratio", (Object)treeMap.getRatio());
        }
        if (treeMap.getRound() != null) {
            jgen.writeObjectField("round", (Object)treeMap.getRound());
        }
        jgen.writeObjectField("valueAccessor", (Object)treeMap.getValueAccessor());
        jgen.writeEndObject();
    }

    private void process(TreeMapNode node, Visitor<TreeMapNode> visitor) {
        visitor.visit(node);
        List<TreeMapNode> children = node.getChildren();
        if (children != null) {
            for (TreeMapNode child : children) {
                this.process(child, visitor);
            }
        }
    }

    static interface Visitor<T> {
        public void visit(T var1);
    }
}

