/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.twosigma.beaker.chart.Chart;
import com.twosigma.beaker.chart.serializer.ObservableChartSerializer;
import java.io.IOException;

public abstract class ChartSerializer<T extends Chart>
extends ObservableChartSerializer<T> {
    public static final String CHART_TITLE = "chart_title";
    public static final String LEGEND_POSITION = "legend_position";
    public static final String SHOW_LEGEND = "show_legend";
    public static final String USE_TOOL_TIP = "use_tool_tip";
    public static final String INIT_WIDTH = "init_width";
    public static final String INIT_HEIGHT = "init_height";

    @Override
    protected void serialize(T chart, JsonGenerator jgen) throws IOException {
        super.serialize(chart, jgen);
        String type = chart.getClass().getSimpleName();
        if ("SimpleTimePlot".equals(type)) {
            jgen.writeObjectField("type", (Object)"TimePlot");
        } else {
            jgen.writeObjectField("type", (Object)type);
        }
        jgen.writeObjectField(INIT_WIDTH, (Object)((Chart)chart).getInitWidth());
        jgen.writeObjectField(INIT_HEIGHT, (Object)((Chart)chart).getInitHeight());
        jgen.writeObjectField(CHART_TITLE, (Object)((Chart)chart).getTitle());
        jgen.writeObjectField(SHOW_LEGEND, (Object)((Chart)chart).getShowLegend());
        jgen.writeObjectField(USE_TOOL_TIP, (Object)((Chart)chart).getUseToolTip());
        jgen.writeObjectField(LEGEND_POSITION, (Object)((Chart)chart).getLegendPosition());
        jgen.writeObjectField("legend_layout", (Object)((Chart)chart).getLegendLayout());
        jgen.writeObjectField("custom_styles", ((Chart)chart).getCustomStyles());
        jgen.writeObjectField("element_styles", ((Chart)chart).getElementStyles());
    }
}

