/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.FileWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingFileWidget
extends SwingInputWidget<File>
implements FileWidget<JPanel>,
ActionListener,
DocumentListener {
    @Parameter
    private UIService uiService;
    private JTextField path;
    private JButton browse;

    public File getValue() {
        String text = this.path.getText();
        return text.isEmpty() ? null : new File(text);
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        this.path = new JTextField(16);
        this.setToolTip(this.path);
        this.getComponent().add(this.path);
        this.path.getDocument().addDocumentListener(this);
        this.getComponent().add(Box.createHorizontalStrut(3));
        this.browse = new JButton("Browse");
        this.setToolTip(this.browse);
        this.getComponent().add(this.browse);
        this.browse.addActionListener(this);
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isType(File.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WidgetModel model;
        String style;
        File file = new File(this.path.getText());
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if ((file = this.uiService.chooseFile(file, style = (model = this.get()).isStyle("directory") ? "directory" : (model.isStyle("save") ? "save" : "open"))) == null) {
            return;
        }
        this.path.setText(file.getAbsolutePath());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateModel();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateModel();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateModel();
    }

    public void doRefresh() {
        String text = this.get().getText();
        if (text.equals(this.path.getText())) {
            return;
        }
        this.path.setText(text);
    }
}

