/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.commands;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.scijava.event.EventDetails;
import org.scijava.event.EventHistory;
import org.scijava.event.SciJavaEvent;
import org.scijava.log.LogService;
import org.scijava.swing.checkboxtree.CheckBoxNodeData;
import org.scijava.swing.checkboxtree.CheckBoxNodeEditor;
import org.scijava.swing.checkboxtree.CheckBoxNodeRenderer;
import org.scijava.util.ClassUtils;
import org.scijava.util.IteratorPlus;

public class WatchEventsFrame
extends JFrame
implements ActionListener,
TreeModelListener,
TreeSelectionListener {
    private final EventHistory eventHistory;
    private final LogService log;
    private final HashSet<Class<? extends SciJavaEvent>> filtered = new HashSet();
    private final HashSet<Class<? extends SciJavaEvent>> selected = new HashSet();
    private final DefaultTreeModel treeModel;
    private final DefaultMutableTreeNode root;
    private final JTree tree;
    private final JTextPane textPane;
    private final HTMLEditorKit kit;
    private final HTMLDocument doc;

    public WatchEventsFrame(EventHistory eventHistory, LogService log) {
        super("Event Watcher");
        this.eventHistory = eventHistory;
        this.log = log;
        this.root = this.create(SciJavaEvent.class);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer((TreeCellRenderer)new CheckBoxNodeRenderer());
        this.tree.setCellEditor((TreeCellEditor)new CheckBoxNodeEditor(this.tree));
        this.tree.setEditable(true);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(this);
        this.treeModel.addTreeModelListener(this);
        this.textPane = new JTextPane();
        this.kit = new HTMLEditorKit();
        this.doc = new HTMLDocument();
        this.textPane.setEditorKit(this.kit);
        this.textPane.setDocument(this.doc);
        this.textPane.setEditable(false);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setResizeWeight(0.35);
        splitPane.add(new JScrollPane(this.tree));
        splitPane.add(new JScrollPane(this.textPane));
        JButton clearHistory = new JButton("Clear History");
        clearHistory.setActionCommand("clearHistory");
        clearHistory.addActionListener(this);
        JPanel buttonBar = new JPanel();
        buttonBar.setLayout(new BoxLayout(buttonBar, 0));
        buttonBar.add(Box.createHorizontalGlue());
        buttonBar.add(clearHistory);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.setContentPane(contentPane);
        contentPane.add((Component)splitPane, "Center");
        contentPane.add((Component)buttonBar, "South");
        this.setDefaultCloseOperation(2);
        this.setSize(1000, 700);
    }

    public void append(EventDetails details) {
        Class eventType = details.getEventType();
        DefaultMutableTreeNode node = this.findOrCreate(eventType);
        if (!this.isChecked(node)) {
            return;
        }
        this.append(details.toHTML(this.selected.contains(eventType)));
    }

    public void refreshTree() {
        this.treeModel.reload();
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    public void refreshLog() {
        String html = this.eventHistory.toHTML(this.filtered, this.selected);
        this.setText(html);
    }

    public void append(String text) {
        try {
            this.kit.insertHTML(this.doc, this.doc.getLength(), text, 0, 0, null);
        }
        catch (BadLocationException e) {
            this.log.error((Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
        this.scrollToBottom();
    }

    public void setText(String text) {
        this.textPane.setText(text);
        this.scrollToBottom();
    }

    public void clear() {
        this.textPane.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("clearHistory".equals(cmd)) {
            this.eventHistory.clear();
            this.clear();
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        Object[] children = e.getChildren();
        if (children == null) {
            children = new Object[]{this.root};
        }
        boolean anyChanged = false;
        for (Object child : children) {
            boolean changed;
            DefaultMutableTreeNode node;
            CheckBoxNodeData data;
            if (!(child instanceof DefaultMutableTreeNode) || (data = this.getData(node = (DefaultMutableTreeNode)child)) == null || !(changed = this.toggle(node, data.isChecked()))) continue;
            anyChanged = true;
        }
        if (anyChanged) {
            this.refreshTree();
        }
        this.syncFiltered();
        this.refreshLog();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.syncSelected();
        this.refreshLog();
    }

    private void syncFiltered() {
        this.filtered.clear();
        this.syncFiltered(this.root);
    }

    private void syncFiltered(DefaultMutableTreeNode node) {
        if (!this.isChecked(node)) {
            this.filtered.add(this.getEventType(node));
        }
        for (DefaultMutableTreeNode child : this.children(node)) {
            this.syncFiltered(child);
        }
    }

    private void syncSelected() {
        this.selected.clear();
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.select(node);
        }
    }

    private DefaultMutableTreeNode findOrCreate(Class<? extends SciJavaEvent> eventType) {
        if (eventType == null) {
            return null;
        }
        if (eventType == SciJavaEvent.class) {
            return this.root;
        }
        Class<? extends SciJavaEvent> superclass = eventType.getSuperclass();
        DefaultMutableTreeNode parentNode = this.findOrCreate(superclass);
        for (DefaultMutableTreeNode child : this.children(parentNode)) {
            if (this.getEventType(child) != eventType) continue;
            return child;
        }
        DefaultMutableTreeNode node = this.create(eventType);
        parentNode.add(node);
        this.refreshTree();
        this.tree.scrollPathToVisible(new TreePath(node.getPath()));
        return node;
    }

    private DefaultMutableTreeNode create(Class<? extends SciJavaEvent> eventType) {
        String label = eventType.getName();
        CheckBoxNodeData data = new CheckBoxNodeData(label, true);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(data);
        return node;
    }

    private void scrollToBottom() {
        this.textPane.setCaretPosition(this.textPane.getDocument().getLength());
    }

    private void select(DefaultMutableTreeNode node) {
        this.selected.add(this.getEventType(node));
        for (DefaultMutableTreeNode child : this.children(node)) {
            this.select(child);
        }
    }

    private Class<? extends SciJavaEvent> getEventType(DefaultMutableTreeNode node) {
        CheckBoxNodeData data = this.getData(node);
        if (data == null) {
            return null;
        }
        String className = data.getText();
        Class eventType = ClassUtils.loadClass((String)className);
        if (eventType == null) {
            throw new IllegalStateException("Invalid class: " + className);
        }
        return eventType;
    }

    private boolean isChecked(DefaultMutableTreeNode node) {
        CheckBoxNodeData data = this.getData(node);
        if (data == null) {
            return false;
        }
        return data.isChecked();
    }

    private CheckBoxNodeData getData(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (!(userObject instanceof CheckBoxNodeData)) {
            return null;
        }
        return (CheckBoxNodeData)userObject;
    }

    private boolean toggle(DefaultMutableTreeNode node, boolean checked) {
        CheckBoxNodeData data = this.getData(node);
        boolean anyChanged = false;
        if (data != null && data.isChecked() != checked) {
            data.setChecked(checked);
            anyChanged = true;
        }
        for (DefaultMutableTreeNode child : this.children(node)) {
            boolean changed = this.toggle(child, checked);
            if (!changed) continue;
            anyChanged = true;
        }
        return anyChanged;
    }

    private Iterable<DefaultMutableTreeNode> children(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> en = node.children();
        return new IteratorPlus(en);
    }
}

