/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io;

import io.scif.SCIFIO;
import io.scif.io.IRandomAccess;
import io.scif.io.IStreamAccess;
import io.scif.io.RandomAccessInputStream;
import io.scif.io.StreamHandle;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.scijava.Context;
import org.scijava.plugin.Plugin;

@Plugin(type=IStreamAccess.class)
public class ZipHandle
extends StreamHandle {
    private boolean resetStream;
    private RandomAccessInputStream in;
    private ZipInputStream zip;
    private String entryName;
    private int entryCount;

    public ZipHandle() {
    }

    public ZipHandle(Context context) {
        super(context);
    }

    public ZipHandle(Context context, String file) throws IOException {
        super(context);
        this.setFile(file);
    }

    public ZipHandle(Context context, String file, ZipEntry entry) throws IOException {
        super(context);
        this.setFile(file, entry);
    }

    @Override
    public boolean isConstructable(String file) throws IOException {
        if (!file.toLowerCase().endsWith(".zip")) {
            return false;
        }
        IRandomAccess handle = this.getHandle(file);
        byte[] b = new byte[2];
        if (handle.length() >= 2L) {
            handle.read(b);
        }
        handle.close();
        return new String(b, "UTF-8").equals("PK");
    }

    public String getEntryName() {
        return this.entryName;
    }

    public DataInputStream getInputStream() {
        return this.getStream();
    }

    @Deprecated
    public int getEntryCount() {
        return this.entryCount;
    }

    public void setFile(String file, ZipEntry entry) throws IOException {
        super.setFile(file);
        this.setLength(-1L);
        this.in = this.openStream(file);
        this.zip = new ZipInputStream(this.in);
        this.entryName = entry == null ? null : entry.getName();
        int n = this.entryCount = this.entryName == null ? 0 : 1;
        if (this.entryName == null) {
            ZipEntry ze;
            String innerFile = file.substring(0, file.length() - 4);
            int slash = innerFile.lastIndexOf(File.separator);
            if (slash < 0) {
                slash = innerFile.lastIndexOf("/");
            }
            if (slash >= 0) {
                innerFile = innerFile.substring(slash + 1);
            }
            boolean matchFound = false;
            while ((ze = this.zip.getNextEntry()) != null) {
                if (this.entryName == null) {
                    this.entryName = ze.getName();
                }
                if (!matchFound && ze.getName().startsWith(innerFile)) {
                    this.entryName = ze.getName();
                    matchFound = true;
                }
                ++this.entryCount;
            }
        }
        this.resetStream();
    }

    @Override
    public void setFile(String file) throws IOException {
        this.setFile(file, null);
    }

    @Override
    public void resetStream() throws IOException {
        if (this.getStream() != null) {
            this.getStream().close();
        }
        if (this.in != null) {
            this.in.close();
            this.in = this.openStream(this.getFile());
        }
        if (this.zip != null) {
            this.zip.close();
        }
        this.zip = new ZipInputStream(this.in);
        this.setStream(new DataInputStream(new BufferedInputStream(this.zip, 0x100000)));
        this.getStream().mark(0x100000);
        this.seekToEntry();
        if (this.resetStream) {
            this.resetStream();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.zip = null;
        this.entryName = null;
        this.setLength(-1L);
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
        this.entryCount = 0;
    }

    private void seekToEntry() throws IOException {
        block1: {
            ZipEntry entry;
            this.resetStream = false;
            do {
                entry = this.zip.getNextEntry();
            } while (this.entryName != null && !this.entryName.equals(entry.getName()));
            if (this.getLength() >= 0L) break block1;
            this.populateLength(entry.getSize());
        }
    }

    private void populateLength(long size) throws IOException {
        long skipped;
        if (size >= 0L) {
            this.setLength(size);
            return;
        }
        long length = 0L;
        DataInputStream stream = this.getStream();
        while ((skipped = stream.skip(Long.MAX_VALUE)) != 0L) {
            length += skipped;
        }
        this.setLength(length);
        this.resetStream = true;
    }

    private IRandomAccess getHandle(String file) throws IOException {
        SCIFIO scifio = new SCIFIO(this.getContext());
        return scifio.location().getHandle(file, false, false);
    }

    private RandomAccessInputStream openStream(String file) throws IOException {
        return new RandomAccessInputStream(this.getContext(), this.getHandle(file), file);
    }
}

