/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell;

import io.scif.Reader;
import io.scif.filters.ReaderFilter;
import io.scif.img.ImageRegion;
import io.scif.img.cell.SCIFIOCell;
import io.scif.img.cell.SCIFIOCellCache;
import io.scif.img.cell.SCIFIOCellImg;
import io.scif.img.cell.loaders.ByteArrayLoader;
import io.scif.img.cell.loaders.CharArrayLoader;
import io.scif.img.cell.loaders.DoubleArrayLoader;
import io.scif.img.cell.loaders.FloatArrayLoader;
import io.scif.img.cell.loaders.IntArrayLoader;
import io.scif.img.cell.loaders.LongArrayLoader;
import io.scif.img.cell.loaders.SCIFIOArrayLoader;
import io.scif.img.cell.loaders.ShortArrayLoader;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.cell.LazyCellImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;

public final class SCIFIOCellImgFactory<T extends NativeType<T>>
extends NativeImgFactory<T> {
    private int index;
    private Reader reader;
    private ImageRegion subregion;
    private int[] defaultCellDimensions;

    public SCIFIOCellImgFactory() {
        this(10);
    }

    public SCIFIOCellImgFactory(int ... cellDimensions) {
        this.defaultCellDimensions = (int[])cellDimensions.clone();
        CellImgFactory.verifyDimensions((int[])this.defaultCellDimensions);
    }

    public SCIFIOCellImg<T, ByteArray> createByteInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new ByteArrayLoader(this.reader(), this.subregion), dimensions, entitiesPerPixel);
    }

    public SCIFIOCellImg<T, CharArray> createCharInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new CharArrayLoader(this.reader(), this.subregion), dimensions, entitiesPerPixel);
    }

    public SCIFIOCellImg<T, ShortArray> createShortInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new ShortArrayLoader(this.reader(), this.subregion), dimensions, entitiesPerPixel);
    }

    public SCIFIOCellImg<T, IntArray> createIntInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new IntArrayLoader(this.reader(), this.subregion), dimensions, entitiesPerPixel);
    }

    public SCIFIOCellImg<T, LongArray> createLongInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new LongArrayLoader(this.reader(), this.subregion), dimensions, entitiesPerPixel);
    }

    public SCIFIOCellImg<T, FloatArray> createFloatInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new FloatArrayLoader(this.reader(), this.subregion), dimensions, entitiesPerPixel);
    }

    public SCIFIOCellImg<T, DoubleArray> createDoubleInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new DoubleArrayLoader(this.reader(), this.subregion), dimensions, entitiesPerPixel);
    }

    public SCIFIOCellImg<T, ?> create(long[] dim, T type) {
        if (this.reader == null) {
            throw new IllegalStateException("Tried to create a new SCIFIOCellImg without a Reader to use for opening planes.\nCall setReader(Reader) before invoking create()");
        }
        return (SCIFIOCellImg)type.createSuitableNativeImg((NativeImgFactory)this, dim);
    }

    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new SCIFIOCellImgFactory<T>(this.defaultCellDimensions);
        }
        throw new IncompatibleTypeException((Object)this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }

    public Reader reader() {
        return this.reader;
    }

    public void setReader(Reader r, int imageIndex) {
        this.reader = r;
        this.index = imageIndex;
        if (r instanceof ReaderFilter) {
            r = ((ReaderFilter)r).getTail();
        }
        this.defaultCellDimensions = new int[]{(int)this.reader.getOptimalTileWidth(imageIndex), (int)this.reader.getOptimalTileHeight(imageIndex), 1, 1, 1};
    }

    public void setSubRegion(ImageRegion region) {
        this.subregion = region;
    }

    private <A extends ArrayDataAccess<A>, L extends SCIFIOArrayLoader<A>> SCIFIOCellImg<T, A> createInstance(L loader, long[] dimensions, Fraction entitiesPerPixel) {
        CellImgFactory.verifyDimensions((long[])dimensions);
        int n = dimensions.length;
        int[] cellDimensions = CellImgFactory.getCellDimensions((int[])this.defaultCellDimensions, (int)n, (Fraction)entitiesPerPixel);
        final CellGrid grid = new CellGrid(dimensions, cellDimensions);
        loader.setIndex(this.index);
        final SCIFIOCellCache cache = new SCIFIOCellCache(this.reader.getContext(), loader);
        LazyCellImg.Get getter = new LazyCellImg.Get<SCIFIOCell<A>>(){

            public SCIFIOCell<A> get(long index) {
                SCIFIOCell cell = cache.get((int)index);
                if (cell != null) {
                    return cell;
                }
                long[] cellMin = new long[grid.numDimensions()];
                int[] cellDims = new int[grid.numDimensions()];
                grid.getCellDimensions(index, cellMin, cellDims);
                return cache.load((int)index, cellDims, cellMin);
            }
        };
        SCIFIOCellImg cellImg = new SCIFIOCellImg(this, grid, new LazyCellImg.LazyCells(grid.getGridDimensions(), getter), entitiesPerPixel);
        cellImg.setLoader(loader);
        return cellImg;
    }
}

