/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img;

import io.scif.Metadata;
import io.scif.config.SCIFIOConfig;
import io.scif.img.ImgFactoryHeuristic;
import io.scif.img.cell.SCIFIOCellImgFactory;
import io.scif.util.FormatTools;
import io.scif.util.MemoryTools;
import net.imagej.axis.Axes;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.type.NativeType;
import org.scijava.util.ArrayUtils;

public class DefaultImgFactoryHeuristic
implements ImgFactoryHeuristic {
    private static final double MEMORY_THRESHOLD = 0.75;

    @Override
    public <T extends NativeType<T>> ImgFactory<T> createFactory(Metadata m, SCIFIOConfig.ImgMode[] imgModes, T type) throws IncompatibleTypeException {
        Object tmpFactory = null;
        long maxSize = ArrayUtils.safeMultiply64((long[])new long[]{2L, 1024L, 1024L, 1024L});
        long availableMem = (long)((double)MemoryTools.totalAvailableMemory() * 0.75);
        long datasetSize = m.getDatasetSize();
        if (datasetSize <= 0L) {
            datasetSize = Long.MAX_VALUE;
        }
        long planeSize = m.get(0).getAxisLength(Axes.X) * m.get(0).getAxisLength(Axes.Y) * (long)FormatTools.getBytesPerPixel(m.get(0).getPixelType());
        boolean fitsInMemory = availableMem > datasetSize;
        boolean decided = false;
        int modeIndex = 0;
        while (!decided) {
            SCIFIOConfig.ImgMode mode;
            SCIFIOConfig.ImgMode imgMode = mode = modeIndex >= imgModes.length ? SCIFIOConfig.ImgMode.AUTO : imgModes[modeIndex++];
            if (mode.equals((Object)SCIFIOConfig.ImgMode.AUTO)) {
                tmpFactory = !fitsInMemory ? new SCIFIOCellImgFactory() : (datasetSize < maxSize ? new ArrayImgFactory() : new PlanarImgFactory());
                decided = true;
                continue;
            }
            if (mode.equals((Object)SCIFIOConfig.ImgMode.ARRAY) && datasetSize < maxSize && fitsInMemory) {
                tmpFactory = new ArrayImgFactory();
                decided = true;
                continue;
            }
            if (mode.equals((Object)SCIFIOConfig.ImgMode.PLANAR) && planeSize < maxSize && fitsInMemory) {
                tmpFactory = new PlanarImgFactory();
                decided = true;
                continue;
            }
            if (!mode.equals((Object)SCIFIOConfig.ImgMode.CELL)) continue;
            tmpFactory = new SCIFIOCellImgFactory();
            decided = true;
        }
        return tmpFactory.imgFactory(type);
    }
}

