/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.BufferedImagePlane;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.MissingLibraryException;
import io.scif.common.ReflectException;
import io.scif.common.ReflectedUniverse;
import io.scif.config.SCIFIOConfig;
import io.scif.formats.TIFFFormat;
import io.scif.gui.AWTImageTools;
import io.scif.gui.BufferedImageReader;
import io.scif.io.FileHandle;
import io.scif.io.IRandomAccess;
import io.scif.io.RandomAccessInputStream;
import io.scif.services.FormatService;
import io.scif.services.LocationService;
import io.scif.util.FormatTools;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.imagej.axis.Axes;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Tagged Image File Format", priority=-10001.0)
public class TIFFJAIFormat
extends AbstractFormat {
    @Parameter
    private FormatService formatService;

    @Override
    protected String[] makeSuffixArray() {
        return this.formatService.getFormatFromClass(TIFFFormat.class).getSuffixes();
    }

    protected static BufferedImage openBufferedImage(Metadata meta, long planeIndex) throws FormatException {
        RenderedImage img;
        meta.universe().setVar("planeIndex", planeIndex);
        try {
            meta.universe().exec("img = dec.decodeAsRenderedImage(planeIndex)");
            img = (RenderedImage)meta.universe().exec("new NullOpImage(img, null, OpImage.OP_IO_BOUND, null)");
        }
        catch (ReflectException exc) {
            throw new FormatException(exc);
        }
        return AWTImageTools.convertRenderedImage(img);
    }

    public static class Reader
    extends BufferedImageReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public BufferedImagePlane openPlane(int imageIndex, long planeIndex, BufferedImagePlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            FormatTools.checkPlaneForReading(this.getMetadata(), imageIndex, planeIndex, -1, planeMin, planeMax);
            BufferedImage img = TIFFJAIFormat.openBufferedImage((Metadata)this.getMetadata(), planeIndex);
            plane.setData(AWTImageTools.getSubimage(img, ((Metadata)this.getMetadata()).get(imageIndex).isLittleEndian(), planeMin, planeMax));
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        private static final String NO_JAI_MSG = "Java Advanced Imaging (JAI) is required to read some TIFF files. Please install JAI from https://jai.dev.java.net/";
        @Parameter
        private LocationService locationService;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            int numPages;
            this.log().info((Object)"Checking for JAI");
            ReflectedUniverse r = null;
            try {
                r = new ReflectedUniverse(this.log());
                r.exec("import javax.media.jai.NullOpImage");
                r.exec("import javax.media.jai.OpImage");
                r.exec("import com.sun.media.jai.codec.FileSeekableStream");
                r.exec("import com.sun.media.jai.codec.ImageDecoder");
                r.exec("import com.sun.media.jai.codec.ImageCodec");
            }
            catch (ReflectException exc) {
                throw new MissingLibraryException(NO_JAI_MSG, exc);
            }
            meta.setUniverse(r);
            String id = stream.getFileName();
            this.log().info((Object)"Reading movie dimensions");
            IRandomAccess ira = this.locationService.getMappedFile(id);
            if (ira != null) {
                if (!(ira instanceof FileHandle)) throw new FormatException("Unsupported handle type" + ira.getClass().getName());
                FileHandle fh = (FileHandle)ira;
                r.setVar("file", fh.getRandomAccessFile());
            } else {
                String mapId = this.locationService.getMappedId(id);
                File file = new File(mapId);
                if (!file.exists()) throw new FileNotFoundException(id);
                r.setVar("file", file);
            }
            r.setVar("tiff", "tiff");
            r.setVar("param", null);
            try {
                r.exec("s = new FileSeekableStream(file)");
                r.exec("dec = ImageCodec.createImageDecoder(tiff, s, param)");
                numPages = (Integer)r.exec("dec.getNumPages()");
            }
            catch (ReflectException exc) {
                throw new FormatException(exc);
            }
            if (numPages >= 0) return;
            throw new FormatException("Invalid page count: " + numPages);
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private ReflectedUniverse r;
        private int numPages;

        public ReflectedUniverse universe() {
            return this.r;
        }

        public void setUniverse(ReflectedUniverse r) {
            this.r = r;
        }

        public int getNumPages() {
            return this.numPages;
        }

        public void setNumPages(int numPages) {
            this.numPages = numPages;
        }

        @Override
        public void populateImageMetadata() {
            this.createImageMetadata(1);
            ImageMetadata m = this.get(0);
            BufferedImage img = null;
            try {
                img = TIFFJAIFormat.openBufferedImage(this, 0L);
            }
            catch (FormatException e) {
                this.log().error((Object)"Invalid image stream", (Throwable)e);
                return;
            }
            m.setAxisLength(Axes.CHANNEL, (long)img.getSampleModel().getNumBands());
            m.setAxisLength(Axes.X, (long)img.getWidth());
            m.setAxisLength(Axes.Y, (long)img.getHeight());
            m.setAxisLength(Axes.TIME, (long)this.numPages);
            m.setPlanarAxisCount(3);
            m.setPixelType(AWTImageTools.getPixelType(img));
            m.setLittleEndian(false);
            m.setMetadataComplete(true);
            m.setIndexed(false);
            m.setFalseColor(false);
        }
    }
}

