/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractFormat;
import io.scif.AbstractWriter;
import io.scif.DefaultMetadata;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.config.SCIFIOConfig;
import io.scif.io.RandomAccessOutputStream;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import org.scijava.plugin.Plugin;
import org.scijava.util.ArrayUtils;
import org.scijava.util.Bytes;

@Plugin(type=Format.class, name="Java source code")
public class JavaFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"java"};
    }

    private static class DoubleArrayPlus
    extends DoubleArray
    implements ArrayPlus {
        public DoubleArrayPlus(double[] data) {
            super(data);
        }

        @Override
        public String label() {
            return "double";
        }

        @Override
        public String value(int index) {
            return String.valueOf(this.getValue(index));
        }
    }

    private static class FloatArrayPlus
    extends FloatArray
    implements ArrayPlus {
        public FloatArrayPlus(float[] data) {
            super(data);
        }

        @Override
        public String label() {
            return "float";
        }

        @Override
        public String value(int index) {
            return String.valueOf(this.getValue(index));
        }
    }

    private static class LongArrayPlus
    extends LongArray
    implements ArrayPlus {
        public LongArrayPlus(long[] data) {
            super(data);
        }

        @Override
        public String label() {
            return "long";
        }

        @Override
        public String value(int index) {
            return String.valueOf(this.getValue(index));
        }
    }

    private static class ShortArrayPlus
    extends ShortArray
    implements ArrayPlus {
        public ShortArrayPlus(short[] data) {
            super(data);
        }

        @Override
        public String label() {
            return "short";
        }

        @Override
        public String value(int index) {
            return String.valueOf(this.getValue(index));
        }
    }

    private static class IntArrayPlus
    extends IntArray
    implements ArrayPlus {
        public IntArrayPlus(int[] data) {
            super(data);
        }

        @Override
        public String label() {
            return "int";
        }

        @Override
        public String value(int index) {
            return String.valueOf(this.getValue(index));
        }
    }

    private static class ByteArrayPlus
    extends ByteArray
    implements ArrayPlus {
        public ByteArrayPlus(byte[] data) {
            super(data);
        }

        @Override
        public String label() {
            return "byte";
        }

        @Override
        public String value(int index) {
            return String.valueOf(this.getValue(index));
        }
    }

    private static interface ArrayPlus {
        public String label();

        public String value(int var1);
    }

    public static class Writer
    extends AbstractWriter<DefaultMetadata> {
        @Override
        protected String[] makeCompressionTypes() {
            return new String[0];
        }

        @Override
        public void setDest(RandomAccessOutputStream stream, int imageIndex, SCIFIOConfig config) throws FormatException, IOException {
            super.setDest(stream, imageIndex, config);
            if (this.getStream().length() == 0L) {
                this.writeHeader();
            }
        }

        @Override
        public void writePlane(int imageIndex, long planeIndex, Plane plane, long[] planeMin, long[] planeMax) throws FormatException, IOException {
            byte[] buf = plane.getBytes();
            Metadata meta = this.getMetadata();
            this.checkParams(imageIndex, planeIndex, buf, planeMin, planeMax);
            if (!SCIFIOMetadataTools.wholePlane(imageIndex, meta, planeMin, planeMax)) {
                throw new FormatException("JavaWriter does not yet support saving image tiles.");
            }
            ImageMetadata imageMeta = meta.get(imageIndex);
            int type = imageMeta.getPixelType();
            if (!ArrayUtils.contains((int[])this.getPixelTypes(this.getCompression()), (int)type)) {
                String typeString = FormatTools.getPixelTypeString(type);
                throw new FormatException("Unsupported image type '" + typeString + "'.");
            }
            int bpp = FormatTools.getBytesPerPixel(type);
            boolean fp = FormatTools.isFloatingPoint(type);
            boolean little = imageMeta.isLittleEndian();
            String varName = "image" + imageIndex + "Plane" + planeIndex;
            Object array = Bytes.makeArray((byte[])buf, (int)bpp, (boolean)fp, (boolean)little);
            this.getStream().seek(this.getStream().length());
            this.writePlane(varName, this.getType(array), (int)planeMax[0], (int)planeMax[1]);
        }

        @Override
        public boolean canDoStacks() {
            return true;
        }

        @Override
        public int[] getPixelTypes(String codec) {
            return new int[]{0, 1, 3, 5, 4, 6, 7};
        }

        @Override
        public void close() throws IOException {
            if (this.getStream() != null) {
                this.writeFooter();
            }
            super.close();
        }

        protected void writeHeader() throws IOException {
            String className = ((DefaultMetadata)this.getMetadata()).getDatasetName().substring(0, ((DefaultMetadata)this.getMetadata()).getDatasetName().length() - 5);
            className = className.substring(className.lastIndexOf(File.separator) + 1);
            RandomAccessOutputStream stream = this.getStream();
            stream.writeLine("//");
            stream.writeLine("// " + className + ".java");
            stream.writeLine("//");
            stream.writeLine("");
            stream.writeLine("// Generated by SCIFIO v" + this.getVersion());
            stream.writeLine("// Generated on " + new Date());
            stream.writeLine("");
            stream.writeLine("public class " + className + " {");
            stream.writeLine("");
        }

        protected void writePlane(String varName, ArrayPlus type, int w, int h) throws IOException {
            int i = 0;
            RandomAccessOutputStream stream = this.getStream();
            stream.writeLine("  public " + type.label() + "[][] " + varName + " = {");
            for (int y = 0; y < h; ++y) {
                stream.writeBytes("    {");
                for (int x = 0; x < w - 1; ++x) {
                    stream.writeBytes(type.value(i++));
                    stream.writeBytes(", ");
                }
                stream.writeBytes(type.value(i++));
                stream.writeBytes("}");
                String s = y < h - 1 ? "," : "";
                stream.writeLine(s);
            }
            stream.writeLine("  };");
            stream.writeLine("");
        }

        protected void writeFooter() throws IOException {
            this.getStream().writeLine("}");
        }

        private ArrayPlus getType(Object array) {
            ArrayPlus type = null;
            if (array instanceof byte[]) {
                type = new ByteArrayPlus((byte[])array);
            } else if (array instanceof short[]) {
                type = new ShortArrayPlus((short[])array);
            } else if (array instanceof int[]) {
                type = new IntArrayPlus((int[])array);
            } else if (array instanceof long[]) {
                type = new LongArrayPlus((long[])array);
            } else if (array instanceof float[]) {
                type = new FloatArrayPlus((float[])array);
            } else if (array instanceof double[]) {
                type = new DoubleArrayPlus((double[])array);
            }
            return type;
        }
    }
}

