/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractReader;
import io.scif.ByteArrayPlane;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.TypedMetadata;
import io.scif.util.FormatTools;
import java.io.IOException;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;

public abstract class ByteArrayReader<M extends TypedMetadata>
extends AbstractReader<M, ByteArrayPlane> {
    public ByteArrayReader() {
        super(ByteArrayPlane.class);
    }

    @Override
    public ByteArrayPlane openThumbPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        FormatTools.assertStream(this.getStream(), true, 1);
        Metadata meta = this.getMetadata();
        long[] planeBounds = meta.get(imageIndex).getAxesLengthsPlanar();
        long[] planeOffsets = new long[planeBounds.length];
        planeBounds[meta.get((int)imageIndex).getAxisIndex((AxisType)Axes.X)] = meta.get(imageIndex).getThumbSizeX();
        planeBounds[meta.get((int)imageIndex).getAxisIndex((AxisType)Axes.Y)] = meta.get(imageIndex).getThumbSizeX();
        ByteArrayPlane plane = this.createPlane(planeOffsets, planeBounds);
        plane.setData(FormatTools.openThumbBytes(this, imageIndex, planeIndex));
        return plane;
    }

    @Override
    public ByteArrayPlane createPlane(long[] planeOffsets, long[] planeBounds) {
        return this.createPlane(this.getMetadata().get(0), planeOffsets, planeBounds);
    }

    @Override
    public ByteArrayPlane createPlane(ImageMetadata meta, long[] planeOffsets, long[] planeBounds) {
        return new ByteArrayPlane(this.getContext(), meta, planeOffsets, planeBounds);
    }
}

