/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.scijava.ui.swing.script.TextEditor;

public class FindAndReplaceDialog
extends JDialog
implements ActionListener {
    TextEditor textEditor;
    JTextField searchField;
    JTextField replaceField;
    JLabel replaceLabel;
    JCheckBox matchCase;
    JCheckBox wholeWord;
    JCheckBox markAll;
    JCheckBox regex;
    JCheckBox forward;
    JButton findNext;
    JButton replace;
    JButton replaceAll;
    JButton cancel;

    public FindAndReplaceDialog(TextEditor editor) {
        super(editor);
        this.textEditor = editor;
        Container root = this.getContentPane();
        root.setLayout(new GridBagLayout());
        JPanel text = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.ipady = 1;
        c.ipadx = 1;
        c.fill = 2;
        c.anchor = 21;
        this.searchField = this.createField("Find Next", text, c, null);
        this.replaceField = this.createField("Replace with", text, c, this);
        c.gridwidth = 4;
        c.gridheight = c.gridy;
        c.gridy = 0;
        c.gridx = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 21;
        root.add((Component)text, c);
        c.gridy = c.gridheight;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.001;
        this.matchCase = this.createCheckBox("Match Case", root, c);
        this.regex = this.createCheckBox("Regex", root, c);
        this.forward = this.createCheckBox("Search forward", root, c);
        this.forward.setSelected(true);
        c.gridx = 0;
        ++c.gridy;
        this.markAll = this.createCheckBox("Mark All", root, c);
        this.wholeWord = this.createCheckBox("Whole Word", root, c);
        c.gridx = 4;
        c.gridy = 0;
        this.findNext = this.createButton("Find Next", root, c);
        this.replace = this.createButton("Replace", root, c);
        this.replaceAll = this.createButton("Replace All", root, c);
        this.cancel = this.createButton("Cancel", root, c);
        this.setResizable(true);
        this.pack();
        this.getRootPane().setDefaultButton(this.findNext);
        this.setDefaultCloseOperation(2);
        KeyAdapter listener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    FindAndReplaceDialog.this.dispose();
                }
            }
        };
        for (Component component : this.getContentPane().getComponents()) {
            component.addKeyListener(listener);
        }
        this.searchField.addKeyListener(listener);
        this.replaceField.addKeyListener(listener);
    }

    protected RSyntaxTextArea getTextArea() {
        return this.textEditor.getTextArea();
    }

    @Override
    public void show(boolean replace) {
        this.setTitle(replace ? "Replace" : "Find");
        this.replaceLabel.setEnabled(replace);
        this.replaceField.setEnabled(replace);
        this.replaceField.setBackground(replace ? this.searchField.getBackground() : this.getRootPane().getBackground());
        this.replace.setEnabled(replace);
        this.replaceAll.setEnabled(replace);
        this.searchField.selectAll();
        this.replaceField.selectAll();
        this.getRootPane().setDefaultButton(this.findNext);
        this.show();
    }

    private JTextField createField(String name, Container container, GridBagConstraints c, FindAndReplaceDialog replaceDialog) {
        c.weightx = 0.001;
        JLabel label = new JLabel(name);
        if (replaceDialog != null) {
            replaceDialog.replaceLabel = label;
        }
        container.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        JTextField field = new JTextField();
        container.add((Component)field, c);
        --c.gridx;
        ++c.gridy;
        return field;
    }

    private JCheckBox createCheckBox(String name, Container panel, GridBagConstraints c) {
        JCheckBox checkBox = new JCheckBox(name);
        checkBox.addActionListener(this);
        panel.add((Component)checkBox, c);
        ++c.gridx;
        return checkBox;
    }

    private JButton createButton(String name, Container panel, GridBagConstraints c) {
        JButton button = new JButton(name);
        button.addActionListener(this);
        panel.add((Component)button, c);
        ++c.gridy;
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancel) {
            this.dispose();
            return;
        }
        String text = this.searchField.getText();
        if (text.length() == 0) {
            return;
        }
        if (source == this.findNext) {
            this.searchOrReplace(false);
        } else if (source == this.replace) {
            this.searchOrReplace(true);
        } else if (source == this.replaceAll) {
            int replace = SearchEngine.replaceAll((RTextArea)this.getTextArea(), (SearchContext)this.getSearchContext(true)).getMarkedCount();
            JOptionPane.showMessageDialog(this, replace + " replacements made!");
        }
    }

    public boolean searchOrReplace(boolean replace) {
        return this.searchOrReplace(replace, this.forward.isSelected());
    }

    public boolean searchOrReplace(boolean replace, boolean forward) {
        if (this.searchOrReplaceFromHere(replace, forward)) {
            return true;
        }
        RSyntaxTextArea textArea = this.getTextArea();
        int caret = textArea.getCaretPosition();
        textArea.setCaretPosition(forward ? 0 : textArea.getDocument().getLength());
        if (this.searchOrReplaceFromHere(replace, forward)) {
            return true;
        }
        JOptionPane.showMessageDialog(this, "No match found!");
        textArea.setCaretPosition(caret);
        return false;
    }

    protected boolean searchOrReplaceFromHere(boolean replace) {
        return this.searchOrReplaceFromHere(this.forward.isSelected());
    }

    protected SearchContext getSearchContext(boolean forward) {
        SearchContext context = new SearchContext();
        context.setSearchFor(this.searchField.getText());
        context.setReplaceWith(this.replaceField.getText());
        context.setSearchForward(forward);
        context.setMatchCase(this.matchCase.isSelected());
        context.setWholeWord(this.wholeWord.isSelected());
        context.setRegularExpression(this.regex.isSelected());
        return context;
    }

    protected boolean searchOrReplaceFromHere(boolean replace, boolean forward) {
        RSyntaxTextArea textArea = this.getTextArea();
        SearchContext context = this.getSearchContext(forward);
        return (replace ? SearchEngine.replace((RTextArea)textArea, (SearchContext)context) : SearchEngine.find((JTextArea)textArea, (SearchContext)context)).wasFound();
    }

    public boolean isReplace() {
        return this.replace.isEnabled();
    }

    public void setSearchPattern(String pattern) {
        this.searchField.setText(pattern);
    }
}

