/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.jython;

import org.python.core.PyBoolean;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.scijava.Context;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.AdaptedScriptLanguage;
import org.scijava.script.ScriptLanguage;

@Plugin(type=ScriptLanguage.class, name="Python")
public class JythonScriptLanguage
extends AdaptedScriptLanguage {
    @Parameter
    private Context context;

    public JythonScriptLanguage() {
        super("jython");
    }

    public Object decode(Object object) {
        PyObject pyObj;
        Class javaType;
        if (object instanceof PyNone) {
            return null;
        }
        if (object instanceof PyBoolean) {
            return ((PyBoolean)object).getBooleanValue();
        }
        if (object instanceof PyInteger) {
            return ((PyInteger)object).getValue();
        }
        if (object instanceof PyFloat) {
            return ((PyFloat)object).getValue();
        }
        if (object instanceof PyString) {
            return ((PyString)object).getString();
        }
        if (object instanceof PyObject && (javaType = (pyObj = (PyObject)object).getType().getProxyType()) != null) {
            return pyObj.__tojava__(javaType);
        }
        return object;
    }
}

