/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.overlay;

import net.imagej.display.ImageDisplay;
import net.imagej.overlay.EllipseOverlay;
import net.imagej.overlay.RectangleOverlay;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Edit", weight=1.0, mnemonic=101), @Menu(label="Selection", mnemonic=115), @Menu(label="Specify...", mnemonic=115)}, headless=true, attrs={@Attr(name="no-legacy")})
public class SelectionSpecify
extends ContextCommand {
    @Parameter
    private Context context;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    @Parameter(label="X")
    private long px;
    @Parameter(label="Y")
    private long py;
    @Parameter(label="Width")
    private long w;
    @Parameter(label="Height")
    private long h;
    @Parameter(label="Centered")
    private boolean centered;
    @Parameter(label="Oval")
    private boolean oval;

    public void run() {
        long x = this.px;
        long y = this.py;
        if (!this.centered) {
            x += this.w / 2L;
            y += this.h / 2L;
        }
        if (this.oval) {
            EllipseOverlay overlay = new EllipseOverlay(this.context);
            overlay.setOrigin((double)x, 0);
            overlay.setOrigin((double)y, 1);
            overlay.setRadius((double)(this.w / 2L), 0);
            overlay.setRadius((double)(this.h / 2L), 1);
            this.display.display((Object)overlay);
        } else {
            RectangleOverlay overlay = new RectangleOverlay(this.context);
            overlay.setOrigin((double)(x - this.w / 2L), 0);
            overlay.setOrigin((double)(y - this.h / 2L), 1);
            overlay.setExtent((double)this.w, 0);
            overlay.setExtent((double)this.h, 1);
            this.display.display((Object)overlay);
        }
        this.display.update();
    }

    public long getPointX() {
        return this.px;
    }

    public void setPointX(long px) {
        this.px = px;
    }

    public long getPointY() {
        return this.py;
    }

    public void setPointY(long py) {
        this.py = py;
    }

    public long getWidth() {
        return this.w;
    }

    public void setWidth(long w) {
        this.w = w;
    }

    public long getHeight() {
        return this.h;
    }

    public void setHeight(long h) {
        this.h = h;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    public boolean isOval() {
        return this.oval;
    }

    public void setOval(boolean oval) {
        this.oval = oval;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }
}

