/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign;

import net.imagej.Dataset;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.options.OptionsCompatibility;
import net.imagej.overlay.Overlay;
import net.imagej.plugins.commands.assign.InplaceUnaryTransform;
import net.imglib2.Cursor;
import net.imglib2.ops.operation.complex.unary.ComplexUnaryOperation;
import net.imglib2.ops.operation.real.unary.RealInvert;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.options.OptionsService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Edit", weight=1.0, mnemonic=101), @Menu(label="Invert...", weight=30.0, accelerator="shift ^I")}, headless=true, attrs={@Attr(name="no-legacy")})
public class InvertDataValues<T extends RealType<T>>
extends ContextCommand {
    @Parameter
    private OverlayService overlayService;
    @Parameter
    private ImageDisplayService imgDispService;
    @Parameter
    private OptionsService optionsService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    @Parameter(label="Apply to all planes")
    private boolean allPlanes;
    private double min;
    private double max;

    public void run() {
        Dataset dataset = this.imgDispService.getActiveDataset(this.display);
        Overlay overlay = this.overlayService.getActiveOverlay(this.display);
        DatasetView view = this.imgDispService.getActiveDatasetView(this.display);
        OptionsCompatibility options = (OptionsCompatibility)this.optionsService.getOptions(OptionsCompatibility.class);
        if (options.isInvertModeLegacy() && dataset.isInteger() && !dataset.isSigned() && dataset.getType().getBitsPerPixel() == 8) {
            this.min = 0.0;
            this.max = 255.0;
        } else {
            this.calcValueRange(dataset);
        }
        RealInvert op = new RealInvert(this.min, this.max);
        InplaceUnaryTransform transform = this.allPlanes ? new InplaceUnaryTransform((ComplexUnaryOperation<DoubleType, DoubleType>)op, new DoubleType(), dataset, overlay) : new InplaceUnaryTransform((ComplexUnaryOperation<DoubleType, DoubleType>)op, new DoubleType(), dataset, overlay, view.getPlanePosition());
        transform.run();
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }

    public boolean isAllPlanes() {
        return this.allPlanes;
    }

    public void setAllPlanes(boolean value) {
        this.allPlanes = value;
    }

    private void calcValueRange(Dataset dataset) {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        Cursor cursor = dataset.getImgPlus().cursor();
        while (cursor.hasNext()) {
            double value = ((RealType)cursor.next()).getRealDouble();
            if (value < this.min) {
                this.min = value;
            }
            if (!(value > this.max)) continue;
            this.max = value;
        }
    }
}

