/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.View;

public class SubsampleView<T>
implements RandomAccessible<T>,
View {
    protected final RandomAccessible<T> source;
    protected final long[] steps;

    public SubsampleView(RandomAccessible<T> source, long step) {
        this.source = source;
        this.steps = new long[source.numDimensions()];
        for (int d = 0; d < this.steps.length; ++d) {
            this.steps[d] = step;
        }
    }

    public SubsampleView(RandomAccessible<T> source, long ... steps) {
        assert (steps.length >= source.numDimensions()) : "Dimensions do not match.";
        this.source = source;
        this.steps = (long[])steps.clone();
    }

    @Override
    public int numDimensions() {
        return this.source.numDimensions();
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return new SubsampleRandomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return new SubsampleRandomAccess(interval);
    }

    public RandomAccessible<T> getSource() {
        return this.source;
    }

    public long[] getSteps() {
        return (long[])this.steps.clone();
    }

    public class SubsampleRandomAccess
    implements RandomAccess<T> {
        protected final RandomAccess<T> sourceRandomAccess;
        protected final long[] tmp;

        protected SubsampleRandomAccess(RandomAccess<T> sourceRandomAccess) {
            this.tmp = new long[SubsampleView.this.source.numDimensions()];
            this.sourceRandomAccess = sourceRandomAccess;
        }

        public SubsampleRandomAccess() {
            this(this$0.source.randomAccess());
        }

        public SubsampleRandomAccess(Interval interval) {
            this(this$0.source.randomAccess(interval));
        }

        @Override
        public void localize(int[] position) {
            for (int d = 0; d < SubsampleView.this.steps.length; ++d) {
                position[d] = this.sourceRandomAccess.getIntPosition(d) / (int)SubsampleView.this.steps[d];
            }
        }

        @Override
        public void localize(long[] position) {
            for (int d = 0; d < SubsampleView.this.steps.length; ++d) {
                position[d] = this.sourceRandomAccess.getLongPosition(d) / SubsampleView.this.steps[d];
            }
        }

        @Override
        public int getIntPosition(int d) {
            return this.sourceRandomAccess.getIntPosition(d) / (int)SubsampleView.this.steps[d];
        }

        @Override
        public long getLongPosition(int d) {
            return this.sourceRandomAccess.getLongPosition(d) / SubsampleView.this.steps[d];
        }

        @Override
        public void localize(float[] position) {
            for (int d = 0; d < SubsampleView.this.steps.length; ++d) {
                position[d] = this.sourceRandomAccess.getFloatPosition(d) / (float)SubsampleView.this.steps[d];
            }
        }

        @Override
        public void localize(double[] position) {
            for (int d = 0; d < SubsampleView.this.steps.length; ++d) {
                position[d] = this.sourceRandomAccess.getDoublePosition(d) / (double)SubsampleView.this.steps[d];
            }
        }

        @Override
        public float getFloatPosition(int d) {
            return this.sourceRandomAccess.getFloatPosition(d) / (float)SubsampleView.this.steps[d];
        }

        @Override
        public double getDoublePosition(int d) {
            return this.sourceRandomAccess.getDoublePosition(d) / (double)SubsampleView.this.steps[d];
        }

        @Override
        public int numDimensions() {
            return SubsampleView.this.source.numDimensions();
        }

        @Override
        public void fwd(int d) {
            this.sourceRandomAccess.move(SubsampleView.this.steps[d], d);
        }

        @Override
        public void bck(int d) {
            this.sourceRandomAccess.move(-SubsampleView.this.steps[d], d);
        }

        @Override
        public void move(int distance, int d) {
            this.sourceRandomAccess.move((long)distance * SubsampleView.this.steps[d], d);
        }

        @Override
        public void move(long distance, int d) {
            this.sourceRandomAccess.move(distance * SubsampleView.this.steps[d], d);
        }

        @Override
        public void move(Localizable localizable) {
            for (int d = 0; d < SubsampleView.this.steps.length; ++d) {
                this.tmp[d] = localizable.getLongPosition(d) * SubsampleView.this.steps[d];
            }
            this.sourceRandomAccess.move(this.tmp);
        }

        @Override
        public void move(int[] distance) {
            for (int d = 0; d < SubsampleView.this.steps.length; ++d) {
                this.tmp[d] = (long)distance[d] * SubsampleView.this.steps[d];
            }
            this.sourceRandomAccess.move(this.tmp);
        }

        @Override
        public void move(long[] distance) {
            for (int d = 0; d < SubsampleView.this.steps.length; ++d) {
                this.tmp[d] = distance[d] * SubsampleView.this.steps[d];
            }
            this.sourceRandomAccess.move(this.tmp);
        }

        @Override
        public void setPosition(Localizable localizable) {
            for (int d = 0; d < SubsampleView.this.steps.length; ++d) {
                this.tmp[d] = localizable.getLongPosition(d) * SubsampleView.this.steps[d];
            }
            this.sourceRandomAccess.setPosition(this.tmp);
        }

        @Override
        public void setPosition(int[] position) {
            for (int d = 0; d < SubsampleView.this.steps.length; ++d) {
                this.tmp[d] = (long)position[d] * SubsampleView.this.steps[d];
            }
            this.sourceRandomAccess.setPosition(this.tmp);
        }

        @Override
        public void setPosition(long[] position) {
            for (int d = 0; d < SubsampleView.this.steps.length; ++d) {
                this.tmp[d] = position[d] * SubsampleView.this.steps[d];
            }
            this.sourceRandomAccess.setPosition(this.tmp);
        }

        @Override
        public void setPosition(int position, int d) {
            this.sourceRandomAccess.setPosition((long)position * SubsampleView.this.steps[d], d);
        }

        @Override
        public void setPosition(long position, int d) {
            this.sourceRandomAccess.setPosition(position * SubsampleView.this.steps[d], d);
        }

        @Override
        public T get() {
            return this.sourceRandomAccess.get();
        }

        public SubsampleRandomAccess copy() {
            return new SubsampleRandomAccess(this.sourceRandomAccess.copyRandomAccess());
        }

        public SubsampleRandomAccess copyRandomAccess() {
            return this.copy();
        }
    }
}

