/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import java.util.Arrays;
import net.imglib2.Interval;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.view.HyperSlice;

public class HyperSlicesView<T>
implements RandomAccessible<HyperSlice<T>> {
    protected final RandomAccessible<T> source;
    protected final int numDimensions;
    protected final int[] accessAxes;

    public HyperSlicesView(RandomAccessible<T> source, int ... axes) {
        this.source = source;
        int[] sortedAxes = (int[])axes.clone();
        Arrays.sort(sortedAxes);
        this.numDimensions = source.numDimensions() - sortedAxes.length;
        this.accessAxes = new int[this.numDimensions];
        int da = 0;
        int db = 0;
        for (int d = 0; d < source.numDimensions(); ++d) {
            if (da < sortedAxes.length && sortedAxes[da] == d) {
                ++da;
                continue;
            }
            this.accessAxes[db++] = d;
        }
    }

    @Override
    public int numDimensions() {
        return this.numDimensions;
    }

    public HyperSlicesViewRandomAccess randomAccess() {
        return new HyperSlicesViewRandomAccess();
    }

    public HyperSlicesViewRandomAccess randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public class HyperSlicesViewRandomAccess
    extends Point
    implements RandomAccess<HyperSlice<T>> {
        public HyperSlicesViewRandomAccess() {
            super(HyperSlicesView.this.numDimensions);
        }

        @Override
        public HyperSlice<T> get() {
            long[] position = new long[HyperSlicesView.this.source.numDimensions()];
            for (int d = 0; d < HyperSlicesView.this.numDimensions; ++d) {
                position[HyperSlicesView.this.accessAxes[d]] = this.getLongPosition(d);
            }
            return new HyperSlice(HyperSlicesView.this.source, HyperSlicesView.this.accessAxes, position);
        }

        public HyperSlicesViewRandomAccess copy() {
            HyperSlicesViewRandomAccess copy = new HyperSlicesViewRandomAccess();
            copy.setPosition(this);
            return copy;
        }

        public HyperSlicesViewRandomAccess copyRandomAccess() {
            return this.copy();
        }
    }
}

