/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.sparse;

import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.sparse.NtreeImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.Util;

public final class NtreeRandomAccess<T extends NativeType<T>>
implements NtreeImg.PositionProvider,
RandomAccess<T> {
    private final NtreeImg<T, ?> img;
    private final T type;
    private final int n;
    private final long[] position;

    public NtreeRandomAccess(NtreeImg<T, ?> img) {
        this.n = img.numDimensions();
        this.position = new long[img.numDimensions()];
        this.img = img;
        this.type = img.createLinkedType();
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = 0L;
        }
        this.type.updateContainer(this);
    }

    private NtreeRandomAccess(NtreeRandomAccess<T> randomAccess) {
        this.n = randomAccess.numDimensions();
        this.position = new long[randomAccess.numDimensions()];
        this.img = randomAccess.img;
        this.type = this.img.createLinkedType();
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = randomAccess.position[d];
        }
        this.type.updateContainer(this);
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1L;
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1L;
    }

    @Override
    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    @Override
    public void setPosition(int[] pos) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
        }
    }

    @Override
    public void setPosition(long[] pos) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
        }
    }

    @Override
    public void setPosition(long pos, int d) {
        this.position[d] = pos;
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public NtreeRandomAccess<T> copy() {
        return new NtreeRandomAccess<T>(this);
    }

    @Override
    public NtreeRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }

    @Override
    public long[] getPosition() {
        return this.position;
    }

    @Override
    public void move(int distance, int dim) {
        this.move((long)distance, dim);
    }

    @Override
    public void setPosition(int position, int dim) {
        this.setPosition((long)position, dim);
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            long dist = distance[d];
            if (dist == 0L) continue;
            this.move(dist, d);
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            long dist = distance[d];
            if (dist == 0L) continue;
            this.move(dist, d);
        }
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            long dist = localizable.getLongPosition(d);
            if (dist == 0L) continue;
            this.move(dist, d);
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.setPosition(localizable.getLongPosition(d), d);
        }
    }

    @Override
    public void localize(float[] pos) {
        for (int d = 0; d < this.n; ++d) {
            pos[d] = this.position[d];
        }
    }

    @Override
    public void localize(double[] pos) {
        for (int d = 0; d < this.n; ++d) {
            pos[d] = this.position[d];
        }
    }

    @Override
    public void localize(int[] pos) {
        for (int d = 0; d < this.n; ++d) {
            pos[d] = (int)this.position[d];
        }
    }

    @Override
    public void localize(long[] pos) {
        for (int d = 0; d < this.n; ++d) {
            pos[d] = this.position[d];
        }
    }

    @Override
    public float getFloatPosition(int dim) {
        return this.position[dim];
    }

    @Override
    public double getDoublePosition(int dim) {
        return this.position[dim];
    }

    @Override
    public int getIntPosition(int dim) {
        return (int)this.position[dim];
    }

    @Override
    public long getLongPosition(int dim) {
        return this.position[dim];
    }

    public String toString() {
        return Util.printCoordinates(this.position) + " = " + this.get();
    }

    @Override
    public int numDimensions() {
        return this.n;
    }
}

