/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodCursor;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodRandomAccess;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodSkipCenter;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodSkipCenterUnsafe;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodUnsafe;
import net.imglib2.algorithm.neighborhood.Shape;

public class RectangleShape
implements Shape {
    final int span;
    final boolean skipCenter;

    public RectangleShape(int span, boolean skipCenter) {
        this.span = span;
        this.skipCenter = skipCenter;
    }

    public <T> NeighborhoodsIterableInterval<T> neighborhoods(RandomAccessibleInterval<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenterUnsafe.factory() : RectangleNeighborhoodUnsafe.factory();
        Interval spanInterval = this.createSpan(source.numDimensions());
        return new NeighborhoodsIterableInterval<T>(source, spanInterval, f);
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessible(RandomAccessible<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenterUnsafe.factory() : RectangleNeighborhoodUnsafe.factory();
        Interval spanInterval = this.createSpan(source.numDimensions());
        return new NeighborhoodsAccessible<T>(source, spanInterval, f);
    }

    public <T> NeighborhoodsIterableInterval<T> neighborhoodsSafe(RandomAccessibleInterval<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenter.factory() : RectangleNeighborhood.factory();
        Interval spanInterval = this.createSpan(source.numDimensions());
        return new NeighborhoodsIterableInterval<T>(source, spanInterval, f);
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessibleSafe(RandomAccessible<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenter.factory() : RectangleNeighborhood.factory();
        Interval spanInterval = this.createSpan(source.numDimensions());
        return new NeighborhoodsAccessible<T>(source, spanInterval, f);
    }

    private Interval createSpan(int n) {
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = -this.span;
            max[d] = this.span;
        }
        return new FinalInterval(min, max);
    }

    public boolean isSkippingCenter() {
        return this.skipCenter;
    }

    public int getSpan() {
        return this.span;
    }

    public String toString() {
        return "RectangleShape, span = " + this.span;
    }

    public static final class NeighborhoodsAccessible<T>
    extends AbstractEuclideanSpace
    implements RandomAccessible<Neighborhood<T>> {
        final RandomAccessible<T> source;
        final Interval span;
        final RectangleNeighborhoodFactory<T> factory;

        public NeighborhoodsAccessible(RandomAccessible<T> source, Interval span, RectangleNeighborhoodFactory<T> factory) {
            super(source.numDimensions());
            this.source = source;
            this.span = span;
            this.factory = factory;
        }

        public RandomAccess<Neighborhood<T>> randomAccess() {
            return new RectangleNeighborhoodRandomAccess<T>(this.source, this.span, this.factory);
        }

        public RandomAccess<Neighborhood<T>> randomAccess(Interval interval) {
            return new RectangleNeighborhoodRandomAccess<T>(this.source, this.span, this.factory, interval);
        }
    }

    public static final class NeighborhoodsIterableInterval<T>
    extends AbstractInterval
    implements IterableInterval<Neighborhood<T>> {
        final RandomAccessibleInterval<T> source;
        final Interval span;
        final RectangleNeighborhoodFactory<T> factory;
        final long size;

        public NeighborhoodsIterableInterval(RandomAccessibleInterval<T> source, Interval span, RectangleNeighborhoodFactory<T> factory) {
            super(source);
            this.source = source;
            this.span = span;
            this.factory = factory;
            long s = source.dimension(0);
            for (int d = 1; d < this.n; ++d) {
                s *= source.dimension(d);
            }
            this.size = s;
        }

        public Cursor<Neighborhood<T>> cursor() {
            return new RectangleNeighborhoodCursor<T>(this.source, this.span, this.factory);
        }

        public long size() {
            return this.size;
        }

        public Neighborhood<T> firstElement() {
            return (Neighborhood)this.cursor().next();
        }

        public Object iterationOrder() {
            return new FlatIterationOrder((Interval)this);
        }

        public Iterator<Neighborhood<T>> iterator() {
            return this.cursor();
        }

        public Cursor<Neighborhood<T>> localizingCursor() {
            return this.cursor();
        }
    }
}

