/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.linalg.matrix;

import net.imglib2.type.numeric.RealType;
import net.imglib2.view.composite.Composite;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.store.PhysicalStore;

public class RealCompositeMatrix<T extends RealType<T>>
implements Access2D<Double>,
Access2D.Collectable<Double, PhysicalStore<Double>> {
    protected Composite<T> data;
    protected final int nRows;
    protected final int nCols;
    protected final int length;

    public RealCompositeMatrix(Composite<T> data, int nRows, int nCols) {
        this(data, nRows, nCols, nRows * nCols);
    }

    protected RealCompositeMatrix(Composite<T> data, int nRows, int nCols, int length) {
        this.data = data;
        this.nRows = nRows;
        this.nCols = nCols;
        this.length = length;
    }

    public void setData(Composite<T> data) {
        this.data = data;
    }

    public long rowAndColumnToLinear(long row, long col) {
        return row * (long)this.nCols + col;
    }

    public long countColumns() {
        return this.nCols;
    }

    public long countRows() {
        return this.nRows;
    }

    public void supplyTo(PhysicalStore<Double> receiver) {
        long tmpLimRows = Math.min(this.countRows(), receiver.countRows());
        long tmpLimCols = Math.min(this.countColumns(), receiver.countColumns());
        for (long j = 0L; j < tmpLimCols; ++j) {
            for (long i = 0L; i < tmpLimRows; ++i) {
                receiver.set(i, j, this.doubleValue(i, j));
            }
        }
    }

    public double doubleValue(long row, long col) {
        assert (row >= 0L && row < (long)this.nRows);
        assert (col >= 0L && col < (long)this.nCols);
        double val = ((RealType)this.data.get(this.rowAndColumnToLinear(row, col))).getRealDouble();
        return val;
    }

    public Double get(long row, long col) {
        return this.doubleValue(row, col);
    }
}

