/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class MatchNode
extends Node {
    private final Node regexpNode;

    public MatchNode(ISourcePosition position, Node regexpNode) {
        super(position);
        assert (regexpNode != null) : "regexpNode is not null";
        this.regexpNode = regexpNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MATCHNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitMatchNode(this);
    }

    public Node getRegexpNode() {
        return this.regexpNode;
    }

    @Override
    public List<Node> childNodes() {
        return MatchNode.createList(this.regexpNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        RubyRegexp pattern = (RubyRegexp)this.regexpNode.interpret(runtime, context, self2, aBlock);
        return runtime.is1_9() ? pattern.op_match2_19(context) : pattern.op_match2(context);
    }
}

