/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import org.scijava.display.Display;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.input.InputModifiers;
import org.scijava.input.InputService;
import org.scijava.ui.awt.AWTDragAndDropData;
import org.scijava.ui.dnd.DragAndDropData;
import org.scijava.ui.dnd.DragAndDropService;
import org.scijava.ui.dnd.event.DragEnterEvent;
import org.scijava.ui.dnd.event.DragExitEvent;
import org.scijava.ui.dnd.event.DragOverEvent;
import org.scijava.ui.dnd.event.DropEvent;

public class AWTDropTargetEventDispatcher
implements DropTargetListener {
    private final Display<?> display;
    private final EventService eventService;

    public AWTDropTargetEventDispatcher(Display<?> display, EventService eventService) {
        this.display = display;
        this.eventService = eventService;
    }

    public void register(Component c) {
        new DropTarget(c, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        InputModifiers mods = this.getModifiers();
        Point p = e.getLocation();
        DragAndDropData data = this.createData(e.getTransferable());
        DragEnterEvent dragEnter = new DragEnterEvent(this.display, mods, p.x, p.y, data);
        this.eventService.publish((SciJavaEvent)dragEnter);
        if (dragEnter.isAccepted()) {
            e.acceptDrag(1);
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        InputModifiers mods = this.getModifiers();
        Point p = e.getLocation();
        DragAndDropData data = this.createData(e.getTransferable());
        this.eventService.publish((SciJavaEvent)new DragOverEvent(this.display, mods, p.x, p.y, data));
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.eventService.publish((SciJavaEvent)new DragExitEvent(this.display));
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        InputModifiers mods = this.getModifiers();
        Point p = e.getLocation();
        DragAndDropData data = this.createData(e.getTransferable());
        DropEvent drop = new DropEvent(this.display, mods, p.x, p.y, data);
        DragAndDropService dragAndDropService = (DragAndDropService)this.eventService.getContext().getService(DragAndDropService.class);
        if (dragAndDropService != null && dragAndDropService.supports(data, this.display)) {
            e.acceptDrop(1);
        } else {
            e.rejectDrop();
        }
        this.eventService.publish((SciJavaEvent)drop);
        e.dropComplete(drop.isSuccessful());
    }

    private InputModifiers getModifiers() {
        InputService inputService = (InputService)this.eventService.getContext().getService(InputService.class);
        return inputService == null ? null : inputService.getModifiers();
    }

    private DragAndDropData createData(Transferable t) {
        return new AWTDragAndDropData(this.eventService.getContext(), t);
    }
}

