/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JTextPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.imagej.ui.swing.updater.UpdaterFrame;
import net.imagej.updater.FileObject;
import net.imagej.updater.util.UpdaterUserInterface;

public class FileDetails
extends JTextPane
implements UndoableEditListener {
    private static final AttributeSet bold;
    private static final AttributeSet italic;
    private static final AttributeSet normal;
    private static final AttributeSet title;
    private static final Cursor hand;
    private static final Cursor defaultCursor;
    private static final String LINK_ATTRIBUTE = "URL";
    SortedMap<Position, EditableRegion> editables;
    Position dummySpace;
    UpdaterFrame updaterFrame;
    final String[] months = new String[]{"Zero", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public FileDetails(final UpdaterFrame updaterFrame) {
        this.updaterFrame = updaterFrame;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String url = FileDetails.this.getLinkAt(e.getPoint());
                try {
                    if (url != null) {
                        UpdaterUserInterface.get().openURL(url);
                    }
                }
                catch (Exception exception) {
                    updaterFrame.log.error((Throwable)exception);
                    UpdaterUserInterface.get().error("Could not open " + url + ": " + exception.getMessage());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                FileDetails.this.setCursor(e.getPoint());
            }
        });
        this.reset();
        this.getDocument().addUndoableEditListener(this);
    }

    public void reset() {
        this.setEditable(false);
        this.setText("");
        Comparator<Position> comparator = new Comparator<Position>(){

            @Override
            public int compare(Position p1, Position p2) {
                return p1.getOffset() - p2.getOffset();
            }
        };
        this.editables = new TreeMap<Position, EditableRegion>(comparator);
        this.dummySpace = null;
    }

    public void setEditableForDevelopers() {
        this.removeDummySpace();
        this.setEditable(true);
    }

    private String getLinkAt(Point p) {
        StyledDocument document = this.getStyledDocument();
        Element e = document.getCharacterElement(this.viewToModel(p));
        return (String)e.getAttributes().getAttribute(LINK_ATTRIBUTE);
    }

    protected void setCursor(Point p) {
        this.setCursor(this.getLinkAt(p) == null ? defaultCursor : hand);
    }

    private AttributeSet getLinkAttribute(String url) {
        SimpleAttributeSet style = FileDetails.getStyle(Color.blue, false, false, "Verdana", 12);
        style.addAttribute(LINK_ATTRIBUTE, url);
        return style;
    }

    public static SimpleAttributeSet getStyle(Color color, boolean italic, boolean bold, String fontName, int fontSize) {
        SimpleAttributeSet style = new SimpleAttributeSet();
        StyleConstants.setForeground(style, color);
        StyleConstants.setItalic(style, italic);
        StyleConstants.setBold(style, bold);
        StyleConstants.setFontFamily(style, fontName);
        StyleConstants.setFontSize(style, fontSize);
        return style;
    }

    public void styled(String text, AttributeSet set) {
        Document document = this.getDocument();
        try {
            document.insertString(document.getLength(), text, set);
        }
        catch (BadLocationException e) {
            this.updaterFrame.log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void link(String url) {
        this.styled(url, this.getLinkAttribute(url));
    }

    public void italic(String text) {
        this.styled(text, italic);
    }

    public void bold(String text) {
        this.styled(text, bold);
    }

    public void normal(String text) {
        this.styled(text, normal);
    }

    public void title(String text) {
        this.styled(text, title);
    }

    public void description(String description, FileObject file) {
        if (!this.updaterFrame.files.hasUploadableSites() && (description == null || description.trim().equals(""))) {
            return;
        }
        this.blankLine();
        this.bold("Description " + (file.descriptionFromPOM ? " (from pom.xml) " : "") + ":\n");
        int offset = this.getCaretPosition();
        this.normal(description);
        if (!file.descriptionFromPOM) {
            this.addEditableRegion(offset, "Description", file);
        }
    }

    public void executable(FileObject file) {
        if (!this.updaterFrame.files.hasUploadableSites() && !file.executable) {
            return;
        }
        this.blankLine();
        this.bold("Executable:\n");
        int offset = this.getCaretPosition();
        this.normal(file.executable ? "true" : "false");
        this.addEditableRegion(offset, "Executable", file);
    }

    public void list(String label, boolean showLinks, Iterable<?> items, String delim, FileObject file) {
        ArrayList list = new ArrayList();
        for (Object object : items) {
            list.add(object);
        }
        if (!this.updaterFrame.files.hasUploadableSites() && list.size() == 0) {
            return;
        }
        this.blankLine();
        String tag = label;
        if (list.size() > 1 && label.endsWith("y")) {
            label = label.substring(0, label.length() - 1) + "ie";
        }
        this.bold(label + (list.size() > 1 ? "s" : "") + ":\n");
        int offset = this.getCaretPosition();
        String delimiter = "";
        for (Object object : list) {
            this.normal(delimiter);
            delimiter = delim;
            if (showLinks) {
                this.link(object.toString());
                continue;
            }
            this.normal(object.toString());
        }
        this.addEditableRegion(offset, tag, file);
    }

    public void blankLine() {
        int offset = this.getCaretPosition();
        try {
            if (offset > 1 && this.getText(offset - 2, 2).equals("\n ")) {
                this.normal("\n");
                return;
            }
        }
        catch (BadLocationException e) {
            this.updaterFrame.log.error((Throwable)e);
        }
        this.normal("\n\n");
    }

    String prettyPrintTimestamp(long timestamp) {
        String t = "" + timestamp + "00000000";
        return t.substring(6, 8) + " " + this.months[Integer.parseInt(t.substring(4, 6))] + " " + t.substring(0, 4);
    }

    public void showFileDetails(FileObject file) {
        this.setCaretPosition(this.getDocument().getLength());
        if (!this.getText().equals("")) {
            this.blankLine();
        }
        this.title(file.getLocalFilename(true));
        if (file.isUpdateable()) {
            this.italic("\n(Update available)");
        } else if (file.isLocalOnly()) {
            this.italic("(Local-only)");
        }
        if (file.isLocallyModified()) {
            this.blankLine();
            this.bold("Warning: ");
            this.italic("This file was locally modified.");
        }
        this.blankLine();
        if (file.current == null) {
            this.bold("This file is no longer needed");
        } else {
            this.bold("Release date:\n");
            this.normal(this.prettyPrintTimestamp(file.current.timestamp));
        }
        this.description(file.getDescription(), file);
        this.list("Author", false, file.getAuthors(), ", ", file);
        if (this.updaterFrame.files.hasUploadableSites()) {
            this.list("Platform", false, file.getPlatforms(), ", ", file);
        }
        this.list("Category", false, file.getCategories(), ", ", file);
        this.list("Link", true, file.getLinks(), "\n", file);
        this.list("Dependency", false, file.getDependencies(), ",\n", file);
        if (file.executable) {
            this.executable(file);
        }
        if (file.updateSite != null && !file.updateSite.equals("ImageJ")) {
            this.blankLine();
            this.bold("Update site:\n");
            this.normal(file.updateSite);
        }
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.setCaretPosition(0);
    }

    void addEditableRegion(int startOffset, String tag, FileObject file) {
        int endOffset = this.getCaretPosition();
        try {
            this.normal(" ");
            Position start = this.getDocument().createPosition(startOffset - 1);
            Position end = this.getDocument().createPosition(endOffset);
            this.editables.put(start, new EditableRegion(file, tag, start, end));
            this.removeDummySpace();
            this.dummySpace = end;
        }
        catch (BadLocationException e) {
            this.updaterFrame.log.error((Throwable)e);
        }
    }

    void removeDummySpace() {
        if (this.dummySpace != null) {
            try {
                this.getDocument().remove(this.dummySpace.getOffset(), 1);
                this.dummySpace = null;
            }
            catch (BadLocationException e) {
                this.updaterFrame.log.error((Throwable)e);
            }
        }
    }

    boolean handleEdit() {
        String text;
        EditableRegion editable;
        try {
            int offset = this.getCaretPosition();
            Position current = this.getDocument().createPosition(offset);
            Position last = this.editables.headMap(current).lastKey();
            editable = (EditableRegion)this.editables.get(last);
            if (offset > editable.start.getOffset() && offset > editable.end.getOffset()) {
                return false;
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
        if (!editable.file.isUploadable(this.updaterFrame.files, true)) {
            return false;
        }
        int start = editable.start.getOffset() + 1;
        int end = editable.end.getOffset();
        try {
            text = this.getDocument().getText(start, end + 1 - start);
        }
        catch (BadLocationException e) {
            return false;
        }
        editable.file.metadataChanged = true;
        if (editable.tag.equals("Description")) {
            editable.file.description = text.trim();
            return true;
        }
        if (editable.tag.equals("Executable")) {
            editable.file.executable = "true".equalsIgnoreCase(text.trim());
            return true;
        }
        String[] list = text.split(editable.tag.equals("Link") ? "\n" : ",");
        editable.file.replaceList(editable.tag, list);
        return true;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.isEditable()) {
            if (!this.handleEdit()) {
                e.getEdit().undo();
            } else {
                this.updaterFrame.markUploadable();
            }
        }
    }

    static {
        italic = FileDetails.getStyle(Color.black, true, false, "Verdana", 12);
        bold = FileDetails.getStyle(Color.black, false, true, "Verdana", 12);
        normal = FileDetails.getStyle(Color.black, false, false, "Verdana", 12);
        title = FileDetails.getStyle(Color.black, false, false, "Impact", 18);
        hand = new Cursor(12);
        defaultCursor = new Cursor(0);
    }

    class EditableRegion
    implements Comparable<EditableRegion> {
        FileObject file;
        String tag;
        Position start;
        Position end;

        public EditableRegion(FileObject file, String tag, Position start, Position end) {
            this.file = file;
            this.tag = tag;
            this.start = start;
            this.end = end;
        }

        @Override
        public int compareTo(EditableRegion other) {
            return this.start.getOffset() - other.start.getOffset();
        }

        public String toString() {
            return "EditableRegion(" + this.tag + ":" + this.start.getOffset() + "-" + (this.end == null ? "null" : Integer.valueOf(this.end.getOffset())) + ")";
        }
    }
}

