/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.imagej.ui.swing.updater.SwingTools;
import net.imagej.ui.swing.updater.UpdaterFrame;
import net.imagej.updater.Conflicts;

public abstract class ConflictDialog
extends JDialog
implements ActionListener {
    protected UpdaterFrame updaterFrame;
    protected JPanel rootPanel;
    public JTextPane panel;
    protected SimpleAttributeSet bold;
    protected SimpleAttributeSet indented;
    protected SimpleAttributeSet italic;
    protected SimpleAttributeSet normal;
    protected SimpleAttributeSet red;
    protected JButton ok;
    protected JButton cancel;
    protected List<Conflicts.Conflict> conflictList;
    protected boolean wasCanceled;

    public ConflictDialog(UpdaterFrame owner, String title) {
        super((Frame)owner, title);
        this.updaterFrame = owner;
        this.rootPanel = SwingTools.verticalPanel();
        this.setContentPane(this.rootPanel);
        this.panel = new JTextPane();
        this.panel.setEditable(false);
        this.bold = new SimpleAttributeSet();
        StyleConstants.setBold(this.bold, true);
        StyleConstants.setFontSize(this.bold, 16);
        this.indented = new SimpleAttributeSet();
        StyleConstants.setLeftIndent(this.indented, 40.0f);
        this.italic = new SimpleAttributeSet();
        StyleConstants.setItalic(this.italic, true);
        this.normal = new SimpleAttributeSet();
        this.red = new SimpleAttributeSet();
        StyleConstants.setForeground(this.red, Color.RED);
        SwingTools.scrollPane(this.panel, 650, 450, this.rootPanel);
        JPanel buttons = new JPanel();
        this.ok = SwingTools.button("OK", "OK", this, buttons);
        this.cancel = SwingTools.button("Cancel", "Cancel", this, buttons);
        this.rootPanel.add(buttons);
        this.pack();
        this.setModal(true);
        this.setLocationRelativeTo(owner);
        int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        SwingTools.addAccelerator(this.cancel, this.rootPanel, this, 27, 0);
        SwingTools.addAccelerator(this.cancel, this.rootPanel, this, 87, ctrl);
        SwingTools.addAccelerator(this.ok, this.rootPanel, this, 10, 0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConflictDialog.this.updateConflictList();
                if (ConflictDialog.this.conflictList.size() > 0) {
                    ConflictDialog.this.wasCanceled = true;
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancel) {
            this.wasCanceled = true;
            this.dispose();
        } else if (e.getSource() == this.ok) {
            if (!this.ok.isEnabled()) {
                return;
            }
            this.dispose();
        }
    }

    @Override
    public void setVisible(final boolean visible) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.setVisible(visible);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ConflictDialog.this.setVisible(visible);
                    }
                });
            }
            catch (InterruptedException e) {
                this.updaterFrame.log.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.updaterFrame.log.error((Throwable)e);
            }
        }
    }

    public boolean resolve() {
        this.listIssues();
        if (this.panel.getDocument().getLength() > 0) {
            this.setVisible(true);
        }
        return !this.wasCanceled;
    }

    protected abstract void updateConflictList();

    protected void listIssues() {
        this.updateConflictList();
        this.panel.setText("");
        for (Conflicts.Conflict conflict : this.conflictList) {
            this.maybeAddSeparator();
            this.newText(conflict.getSeverity().toString() + ": ", conflict.isError() ? this.red : this.normal);
            String filename = conflict.getFilename();
            if (filename != null) {
                this.addText(filename, this.bold);
            }
            this.addText("\n" + conflict.getConflict());
            this.addText("\n");
            for (final Conflicts.Resolution resolution : conflict.getResolutions()) {
                this.addText("\n    ");
                this.addButton(resolution.getDescription(), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        resolution.resolve();
                        ConflictDialog.this.listIssues();
                    }
                });
            }
        }
        this.ok.setEnabled(!Conflicts.needsFeedback(this.conflictList));
        if (this.ok.isEnabled()) {
            this.ok.requestFocus();
        }
        if (this.isShowing()) {
            if (this.panel.getStyledDocument().getLength() == 0) {
                this.addText("No more issues to be resolved!", this.italic);
            }
            this.panel.setCaretPosition(0);
            this.panel.repaint();
        }
    }

    protected void addButton(String label, ActionListener listener) {
        JButton button = SwingTools.button(label, null, listener, null);
        this.selectEnd();
        this.panel.insertComponent(button);
    }

    protected void selectEnd() {
        int end = this.panel.getStyledDocument().getLength();
        this.panel.select(end, end);
    }

    protected void newText(String message) {
        this.newText(message, this.normal);
    }

    protected void newText(String message, SimpleAttributeSet style) {
        if (this.panel.getStyledDocument().getLength() > 0) {
            this.addText("\n\n");
        }
        this.addText(message, style);
    }

    protected void addText(String message) {
        this.addText(message, this.normal);
    }

    protected void addText(String message, SimpleAttributeSet style) {
        int end = this.panel.getStyledDocument().getLength();
        try {
            this.panel.getStyledDocument().insertString(end, message, style);
        }
        catch (BadLocationException e) {
            this.updaterFrame.log.error((Throwable)e);
        }
    }

    protected void maybeAddSeparator() {
        if (this.panel.getText().equals("") && this.panel.getComponents().length == 0) {
            return;
        }
        this.addText("\n");
        this.selectEnd();
        this.panel.insertComponent(new JSeparator());
    }
}

