/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayView;
import net.imagej.overlay.EllipseOverlay;
import net.imagej.overlay.Overlay;
import net.imagej.ui.swing.overlay.AbstractJHotDrawAdapter;
import net.imagej.ui.swing.overlay.IJCreationTool;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import net.imagej.ui.swing.tools.SwingEllipseTool;
import org.jhotdraw.draw.EllipseFigure;
import org.jhotdraw.draw.Figure;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.tool.Tool;
import org.scijava.tool.ToolService;
import org.scijava.util.RealCoords;

@Plugin(type=JHotDrawAdapter.class, priority=99.0)
public class EllipseJHotDrawAdapter
extends AbstractJHotDrawAdapter<EllipseOverlay, EllipseFigure> {
    @Parameter
    private ToolService toolService;

    protected static EllipseOverlay downcastOverlay(Overlay roi) {
        assert (roi instanceof EllipseOverlay);
        return (EllipseOverlay)roi;
    }

    protected static EllipseFigure downcastFigure(Figure figure) {
        assert (figure instanceof EllipseFigure);
        return (EllipseFigure)figure;
    }

    @Override
    public boolean supports(Tool tool) {
        return tool instanceof SwingEllipseTool;
    }

    @Override
    public boolean supports(Overlay overlay, Figure figure) {
        if (!(overlay instanceof EllipseOverlay)) {
            return false;
        }
        return figure == null || figure instanceof EllipseFigure;
    }

    @Override
    public Overlay createNewOverlay() {
        return new EllipseOverlay(this.getContext());
    }

    @Override
    public Figure createDefaultFigure() {
        EllipseFigure figure = new EllipseFigure();
        this.initDefaultSettings(figure);
        return figure;
    }

    @Override
    public void updateFigure(OverlayView view, EllipseFigure figure) {
        super.updateFigure(view, figure);
        EllipseOverlay overlay = EllipseJHotDrawAdapter.downcastOverlay(view.getData());
        double centerX = overlay.getOrigin(0);
        double centerY = overlay.getOrigin(1);
        double radiusX = overlay.getRadius(0);
        double radiusY = overlay.getRadius(1);
        figure.setBounds(new Point2D.Double(centerX - radiusX, centerY - radiusY), new Point2D.Double(centerX + radiusX, centerY + radiusY));
    }

    @Override
    public void updateOverlay(EllipseFigure figure, OverlayView view) {
        super.updateOverlay(figure, view);
        EllipseOverlay overlay = EllipseJHotDrawAdapter.downcastOverlay(view.getData());
        Rectangle2D.Double bounds = figure.getBounds();
        double x = bounds.getMinX();
        double y = bounds.getMinY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        overlay.setOrigin(x + w / 2.0, 0);
        overlay.setOrigin(y + h / 2.0, 1);
        overlay.setRadius(w / 2.0, 0);
        overlay.setRadius(h / 2.0, 1);
        overlay.update();
        this.toolService.reportRectangle(x, y, w, h);
    }

    @Override
    public JHotDrawTool getCreationTool(ImageDisplay display) {
        return new IJCreationTool<EllipseFigure>(display, this);
    }

    @Override
    public void report(RealCoords p1, RealCoords p2) {
        this.toolService.reportRectangle(p1, p2);
    }

    @Override
    public Shape toShape(EllipseFigure figure) {
        Rectangle2D.Double bounds = figure.getBounds();
        return new Ellipse2D.Double(bounds.x, bounds.y, bounds.width, bounds.height);
    }
}

