/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractAttributedCompositeFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.TransformHandleKit;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.geom.Shapes;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.samples.svg.figures.SVGPathOutlineHandle;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGPathFigure
extends AbstractAttributedCompositeFigure
implements SVGFigure {
    @Nullable
    private transient Path2D.Double cachedPath;
    @Nullable
    private transient Shape cachedHitShape;
    private static final boolean DEBUG = false;

    public SVGPathFigure() {
        this.add(new SVGBezierFigure());
        SVGAttributeKeys.setDefaults(this);
    }

    public SVGPathFigure(boolean isEmpty) {
        if (!isEmpty) {
            this.add(new SVGBezierFigure());
        }
        SVGAttributeKeys.setDefaults(this);
        this.setConnectable(false);
    }

    @Override
    public void draw(Graphics2D g) {
        double opacity = this.get(SVGAttributeKeys.OPACITY);
        if ((opacity = Math.min(Math.max(0.0, opacity), 1.0)) != 0.0) {
            if (opacity != 1.0) {
                Rectangle2D.Double drawingArea = this.getDrawingArea();
                Rectangle clipBounds = g.getClipBounds();
                if (clipBounds != null) {
                    Rectangle2D.intersect(drawingArea, clipBounds, drawingArea);
                }
                if (!drawingArea.isEmpty()) {
                    BufferedImage buf = new BufferedImage(Math.max(1, (int)((2.0 + drawingArea.width) * g.getTransform().getScaleX())), Math.max(1, (int)((2.0 + drawingArea.height) * g.getTransform().getScaleY())), 2);
                    Graphics2D gr = buf.createGraphics();
                    gr.scale(g.getTransform().getScaleX(), g.getTransform().getScaleY());
                    gr.translate((int)(-drawingArea.x), (int)(-drawingArea.y));
                    gr.setRenderingHints(g.getRenderingHints());
                    this.drawFigure(gr);
                    gr.dispose();
                    Composite savedComposite = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, (float)opacity));
                    g.drawImage(buf, (int)drawingArea.x, (int)drawingArea.y, 2 + (int)drawingArea.width, 2 + (int)drawingArea.height, null);
                    g.setComposite(savedComposite);
                }
            } else {
                this.drawFigure(g);
            }
        }
    }

    @Override
    public void drawFigure(Graphics2D g) {
        Paint paint;
        AffineTransform savedTransform = null;
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            savedTransform = g.getTransform();
            g.transform((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM));
        }
        if ((paint = SVGAttributeKeys.getFillPaint(this)) != null) {
            g.setPaint(paint);
            this.drawFill(g);
        }
        if ((paint = SVGAttributeKeys.getStrokePaint(this)) != null) {
            g.setPaint(paint);
            g.setStroke(SVGAttributeKeys.getStroke(this));
            this.drawStroke(g);
        }
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            g.setTransform(savedTransform);
        }
    }

    @Override
    protected void drawChildren(Graphics2D g) {
    }

    @Override
    public void drawFill(Graphics2D g) {
        g.fill(this.getPath());
    }

    @Override
    public void drawStroke(Graphics2D g) {
        g.draw(this.getPath());
    }

    @Override
    protected void invalidate() {
        super.invalidate();
        this.cachedPath = null;
        this.cachedDrawingArea = null;
        this.cachedHitShape = null;
    }

    protected Path2D.Double getPath() {
        if (this.cachedPath == null) {
            this.cachedPath = new Path2D.Double();
            this.cachedPath.setWindingRule(this.get(SVGAttributeKeys.WINDING_RULE) == AttributeKeys.WindingRule.EVEN_ODD ? 0 : 1);
            for (Figure child : this.getChildren()) {
                SVGBezierFigure b = (SVGBezierFigure)child;
                this.cachedPath.append(b.getBezierPath(), false);
            }
        }
        return this.cachedPath;
    }

    protected Shape getHitShape() {
        if (this.cachedHitShape == null) {
            this.cachedHitShape = this.getPath();
            if (this.get(SVGAttributeKeys.FILL_COLOR) == null && this.get(SVGAttributeKeys.FILL_GRADIENT) == null) {
                this.cachedHitShape = SVGAttributeKeys.getHitStroke(this).createStrokedShape(this.cachedHitShape);
            }
        }
        return this.cachedHitShape;
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            Rectangle2D rx;
            double strokeTotalWidth = Math.max(1.0, AttributeKeys.getStrokeTotalWidth(this));
            double width = strokeTotalWidth / 2.0;
            if ((Integer)this.get(SVGAttributeKeys.STROKE_JOIN) == 0) {
                width *= ((Double)this.get(SVGAttributeKeys.STROKE_MITER_LIMIT)).doubleValue();
            } else if ((Integer)this.get(SVGAttributeKeys.STROKE_CAP) != 0) {
                width += strokeTotalWidth * 2.0;
            }
            Shape gp = this.getPath();
            Rectangle2D strokeRect = new Rectangle2D.Double(0.0, 0.0, width, width);
            AffineTransform tx = (AffineTransform)this.get(SVGAttributeKeys.TRANSFORM);
            if (tx != null) {
                gp = tx.createTransformedShape(gp.getBounds2D());
                strokeRect = tx.createTransformedShape(strokeRect).getBounds2D();
            }
            Rectangle2D.Double r = (rx = gp.getBounds2D()) instanceof Rectangle2D.Double ? (Rectangle2D.Double)rx : new Rectangle2D.Double(rx.getX(), rx.getY(), rx.getWidth(), rx.getHeight());
            Geom.grow(r, strokeRect.getWidth(), strokeRect.getHeight());
            this.cachedDrawingArea = r;
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public boolean contains(Point2D.Double p) {
        boolean isClosed;
        this.getPath();
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            try {
                p = (Point2D.Double)((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).inverseTransform(p, new Point2D.Double());
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        if ((isClosed = ((Boolean)this.getChild(0).get(SVGAttributeKeys.PATH_CLOSED)).booleanValue()) && this.get(SVGAttributeKeys.FILL_COLOR) == null && this.get(SVGAttributeKeys.FILL_GRADIENT) == null) {
            return this.getHitShape().contains(p);
        }
        double tolerance = Math.max(2.0, AttributeKeys.getStrokeTotalWidth(this) / 2.0);
        if (isClosed || this.get(SVGAttributeKeys.FILL_COLOR) != null || this.get(SVGAttributeKeys.FILL_GRADIENT) != null) {
            if (this.getPath().contains(p)) {
                return true;
            }
            double grow = AttributeKeys.getPerpendicularHitGrowth(this);
            GrowStroke gs = new GrowStroke(grow, AttributeKeys.getStrokeTotalWidth(this) * (Double)this.get(SVGAttributeKeys.STROKE_MITER_LIMIT));
            if (gs.createStrokedShape(this.getPath()).contains(p)) {
                return true;
            }
            if (isClosed) {
                return false;
            }
        }
        return !isClosed && Shapes.outlineContains(this.getPath(), p, tolerance);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (this.getChildCount() == 1 && this.getChild(0).getNodeCount() <= 2) {
            SVGBezierFigure b = this.getChild(0);
            b.setBounds(anchor, lead);
            this.invalidate();
        } else {
            super.setBounds(anchor, lead);
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        if (this.get(SVGAttributeKeys.TRANSFORM) != null || (tx.getType() & 1) != tx.getType()) {
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                SVGAttributeKeys.TRANSFORM.setClone(this, tx);
            } else {
                AffineTransform t = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                this.set(SVGAttributeKeys.TRANSFORM, t);
            }
        } else {
            Gradient g;
            for (Figure f : this.getChildren()) {
                f.transform(tx);
            }
            if (this.get(SVGAttributeKeys.FILL_GRADIENT) != null && !this.get(SVGAttributeKeys.FILL_GRADIENT).isRelativeToFigureBounds()) {
                g = SVGAttributeKeys.FILL_GRADIENT.getClone(this);
                g.transform(tx);
                this.set(SVGAttributeKeys.FILL_GRADIENT, g);
            }
            if (this.get(SVGAttributeKeys.STROKE_GRADIENT) != null && !this.get(SVGAttributeKeys.STROKE_GRADIENT).isRelativeToFigureBounds()) {
                g = SVGAttributeKeys.STROKE_GRADIENT.getClone(this);
                g.transform(tx);
                this.set(SVGAttributeKeys.STROKE_GRADIENT, g);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        this.invalidate();
        Object[] restoreData = (Object[])geometry;
        ArrayList paths = (ArrayList)restoreData[0];
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.getChild(i).restoreTransformTo(paths.get(i));
        }
        SVGAttributeKeys.TRANSFORM.setClone(this, (AffineTransform)restoreData[1]);
        SVGAttributeKeys.FILL_GRADIENT.setClone(this, (Gradient)restoreData[2]);
        SVGAttributeKeys.STROKE_GRADIENT.setClone(this, (Gradient)restoreData[3]);
    }

    @Override
    public Object getTransformRestoreData() {
        ArrayList<Object> paths = new ArrayList<Object>(this.getChildCount());
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            paths.add(this.getChild(i).getTransformRestoreData());
        }
        return new Object[]{paths, SVGAttributeKeys.TRANSFORM.getClone(this), SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public <T> void set(AttributeKey<T> key, T newValue) {
        super.set(key, newValue);
        this.invalidate();
    }

    @Override
    public boolean isEmpty() {
        for (Figure child : this.getChildren()) {
            SVGBezierFigure b = (SVGBezierFigure)child;
            if (b.getNodeCount() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case -1: {
                handles.add(new SVGPathOutlineHandle(this, true));
                break;
            }
            case 0: {
                handles.add(new SVGPathOutlineHandle(this));
                for (Figure child : this.getChildren()) {
                    handles.addAll(((SVGBezierFigure)child).createHandles(this, detailLevel));
                }
                handles.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        LinkedList<Action> actions = new LinkedList<Action>();
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            actions.add(new AbstractAction(labels.getString("edit.removeTransform.text")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SVGPathFigure.this.willChange();
                    SVGPathFigure.this.fireUndoableEditHappened(SVGAttributeKeys.TRANSFORM.setUndoable(SVGPathFigure.this, null));
                    SVGPathFigure.this.changed();
                }
            });
            actions.add(new AbstractAction(labels.getString("edit.flattenTransform.text")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    final Object restoreData = SVGPathFigure.this.getTransformRestoreData();
                    AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                        @Override
                        public String getPresentationName() {
                            return labels.getString("edit.flattenTransform.text");
                        }

                        @Override
                        public void undo() throws CannotUndoException {
                            super.undo();
                            SVGPathFigure.this.willChange();
                            SVGPathFigure.this.restoreTransformTo(restoreData);
                            SVGPathFigure.this.changed();
                        }

                        @Override
                        public void redo() throws CannotRedoException {
                            super.redo();
                            SVGPathFigure.this.willChange();
                            SVGPathFigure.this.restoreTransformTo(restoreData);
                            SVGPathFigure.this.flattenTransform();
                            SVGPathFigure.this.changed();
                        }
                    };
                    SVGPathFigure.this.willChange();
                    SVGPathFigure.this.flattenTransform();
                    SVGPathFigure.this.changed();
                    SVGPathFigure.this.fireUndoableEditHappened(edit);
                }
            });
        }
        if (((Boolean)this.getChild(this.getChildCount() - 1).get(SVGAttributeKeys.PATH_CLOSED)).booleanValue()) {
            actions.add(new AbstractAction(labels.getString("attribute.openPath.text")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SVGPathFigure.this.willChange();
                    for (Figure child : SVGPathFigure.this.getChildren()) {
                        SVGPathFigure.this.getDrawing().fireUndoableEditHappened(SVGAttributeKeys.PATH_CLOSED.setUndoable(child, false));
                    }
                    SVGPathFigure.this.changed();
                }
            });
        } else {
            actions.add(new AbstractAction(labels.getString("attribute.closePath.text")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SVGPathFigure.this.willChange();
                    for (Figure child : SVGPathFigure.this.getChildren()) {
                        SVGPathFigure.this.getDrawing().fireUndoableEditHappened(SVGAttributeKeys.PATH_CLOSED.setUndoable(child, true));
                    }
                    SVGPathFigure.this.changed();
                }
            });
        }
        if (this.get(SVGAttributeKeys.WINDING_RULE) != AttributeKeys.WindingRule.EVEN_ODD) {
            actions.add(new AbstractAction(labels.getString("attribute.windingRule.evenOdd.text")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SVGPathFigure.this.willChange();
                    SVGPathFigure.this.getDrawing().fireUndoableEditHappened(SVGAttributeKeys.WINDING_RULE.setUndoable(SVGPathFigure.this, AttributeKeys.WindingRule.EVEN_ODD));
                    SVGPathFigure.this.changed();
                }
            });
        } else {
            actions.add(new AbstractAction(labels.getString("attribute.windingRule.nonZero.text")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SVGPathFigure.this.willChange();
                    SVGPathFigure.this.set(SVGAttributeKeys.WINDING_RULE, AttributeKeys.WindingRule.NON_ZERO);
                    SVGPathFigure.this.changed();
                    SVGPathFigure.this.getDrawing().fireUndoableEditHappened(SVGAttributeKeys.WINDING_RULE.setUndoable(SVGPathFigure.this, AttributeKeys.WindingRule.NON_ZERO));
                }
            });
        }
        return actions;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        if (evt.getClickCount() == 2 && view.getHandleDetailLevel() % 2 == 0) {
            for (Figure child : this.getChildren()) {
                SVGBezierFigure bf = (SVGBezierFigure)child;
                int index = bf.findSegment(p, 5.0 / view.getScaleFactor());
                if (index == -1) continue;
                bf.handleMouseClick(p, evt, view);
                evt.consume();
                return true;
            }
        }
        return false;
    }

    @Override
    public void add(int index, Figure figure) {
        super.add(index, (SVGBezierFigure)figure);
    }

    @Override
    public SVGBezierFigure getChild(int index) {
        return (SVGBezierFigure)super.getChild(index);
    }

    @Override
    public SVGPathFigure clone() {
        SVGPathFigure that = (SVGPathFigure)super.clone();
        return that;
    }

    public void flattenTransform() {
        this.willChange();
        AffineTransform tx = (AffineTransform)this.get(SVGAttributeKeys.TRANSFORM);
        if (tx != null) {
            for (Figure child : this.getChildren()) {
                ((SVGBezierFigure)child).flattenTransform();
            }
        }
        if (this.get(SVGAttributeKeys.FILL_GRADIENT) != null) {
            this.get(SVGAttributeKeys.FILL_GRADIENT).transform(tx);
        }
        if (this.get(SVGAttributeKeys.STROKE_GRADIENT) != null) {
            this.get(SVGAttributeKeys.STROKE_GRADIENT).transform(tx);
        }
        this.set(SVGAttributeKeys.TRANSFORM, null);
        this.changed();
    }
}

