/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractAttributedDecoratedFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.handle.FontSizeHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.TextOverflowHandle;
import org.jhotdraw.draw.tool.TextAreaEditingTool;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class TextAreaFigure
extends AbstractAttributedDecoratedFigure
implements TextHolderFigure {
    protected Rectangle2D.Double bounds = new Rectangle2D.Double();
    protected boolean editable = true;
    private static final BasicStroke dashes = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 4.0f}, 0.0f);
    @Nullable
    private Boolean isTextOverflow;

    public TextAreaFigure() {
        this(ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getString("TextFigure.defaultText"));
    }

    public TextAreaFigure(String text) {
        this.setText(text);
    }

    @Override
    protected void drawText(Graphics2D g) {
        if (this.getText() != null || this.isEditable()) {
            Font font = this.getFont();
            boolean isUnderlined = this.get(AttributeKeys.FONT_UNDERLINE);
            Insets2D.Double insets = this.getInsets();
            Rectangle2D.Double textRect = new Rectangle2D.Double(this.bounds.x + insets.left, this.bounds.y + insets.top, this.bounds.width - insets.left - insets.right, this.bounds.height - insets.top - insets.bottom);
            float leftMargin = (float)textRect.x;
            float rightMargin = (float)Math.max((double)(leftMargin + 1.0f), textRect.x + textRect.width + 1.0);
            float verticalPos = (float)textRect.y;
            float maxVerticalPos = (float)(textRect.y + textRect.height);
            if (leftMargin < rightMargin) {
                float tabWidth = (float)((double)this.getTabSize() * font.getStringBounds("m", this.getFontRenderContext()).getWidth());
                float[] tabStops = new float[(int)(textRect.width / (double)tabWidth)];
                for (int i = 0; i < tabStops.length; ++i) {
                    tabStops[i] = (float)(textRect.x + (double)((int)(tabWidth * (float)(i + 1))));
                }
                if (this.getText() != null) {
                    Shape savedClipArea = g.getClip();
                    g.clip(textRect);
                    String[] paragraphs = this.getText().split("\n");
                    for (int i = 0; i < paragraphs.length; ++i) {
                        if (paragraphs[i].length() == 0) {
                            paragraphs[i] = " ";
                        }
                        AttributedString as = new AttributedString(paragraphs[i]);
                        as.addAttribute(TextAttribute.FONT, font);
                        if (isUnderlined) {
                            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
                        }
                        int tabCount = paragraphs[i].split("\t").length - 1;
                        Rectangle2D.Double paragraphBounds = this.drawParagraph(g, as.getIterator(), verticalPos, maxVerticalPos, leftMargin, rightMargin, tabStops, tabCount);
                        verticalPos = (float)(paragraphBounds.y + paragraphBounds.height);
                        if (verticalPos > maxVerticalPos) break;
                    }
                    g.setClip(savedClipArea);
                }
            }
        }
    }

    private Rectangle2D.Double drawParagraph(@Nullable Graphics2D g, AttributedCharacterIterator styledText, float verticalPos, float maxVerticalPos, float leftMargin, float rightMargin, float[] tabStops, int tabCount) {
        Rectangle2D.Double paragraphBounds = new Rectangle2D.Double(leftMargin, verticalPos, 0.0, 0.0);
        int[] tabLocations = new int[tabCount + 1];
        int i = 0;
        char c = styledText.first();
        while (true) {
            if (c == '\uffff') break;
            if (c == '\t') {
                tabLocations[i++] = styledText.getIndex();
            }
            c = styledText.next();
        }
        tabLocations[tabCount] = styledText.getEndIndex() - 1;
        LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, this.getFontRenderContext());
        int currentTab = 0;
        while (measurer.getPosition() < styledText.getEndIndex() && verticalPos <= maxVerticalPos) {
            boolean lineContainsText = false;
            boolean lineComplete = false;
            float maxAscent = 0.0f;
            float maxDescent = 0.0f;
            float horizontalPos = leftMargin;
            LinkedList<TextLayout> layouts = new LinkedList<TextLayout>();
            LinkedList<Float> penPositions = new LinkedList<Float>();
            int first = layouts.size();
            while (!lineComplete && verticalPos <= maxVerticalPos) {
                float wrappingWidth = rightMargin - horizontalPos;
                TextLayout layout = null;
                layout = measurer.nextLayout(wrappingWidth, tabLocations[currentTab] + 1, lineContainsText);
                if (layout != null) {
                    layouts.add(layout);
                    penPositions.add(Float.valueOf(horizontalPos));
                    horizontalPos += layout.getAdvance();
                    maxAscent = Math.max(maxAscent, layout.getAscent());
                    maxDescent = Math.max(maxDescent, layout.getDescent() + layout.getLeading());
                } else {
                    lineComplete = true;
                }
                lineContainsText = true;
                if (measurer.getPosition() == tabLocations[currentTab] + 1) {
                    ++currentTab;
                }
                if (measurer.getPosition() == styledText.getEndIndex()) {
                    lineComplete = true;
                } else if (tabStops.length == 0 || horizontalPos >= tabStops[tabStops.length - 1]) {
                    lineComplete = true;
                }
                if (lineComplete) continue;
                int j = 0;
                while (horizontalPos >= tabStops[j]) {
                    ++j;
                }
                horizontalPos = tabStops[j];
            }
            if (first == layouts.size() - 1 && g != null) {
                switch (this.get(AttributeKeys.TEXT_ALIGNMENT)) {
                    case TRAILING: {
                        penPositions.set(first, Float.valueOf(rightMargin - ((TextLayout)layouts.get(first)).getVisibleAdvance() - 1.0f));
                        break;
                    }
                    case CENTER: {
                        penPositions.set(first, Float.valueOf((rightMargin - 1.0f - leftMargin - ((TextLayout)layouts.get(first)).getVisibleAdvance()) / 2.0f + leftMargin));
                        break;
                    }
                    case BLOCK: {
                        break;
                    }
                }
            }
            verticalPos += maxAscent;
            Iterator layoutEnum = layouts.iterator();
            Iterator positionEnum = penPositions.iterator();
            while (layoutEnum.hasNext()) {
                TextLayout nextLayout = (TextLayout)layoutEnum.next();
                float nextPosition = ((Float)positionEnum.next()).floatValue();
                if (g != null) {
                    nextLayout.draw(g, nextPosition, verticalPos);
                }
                Rectangle2D layoutBounds = nextLayout.getBounds();
                paragraphBounds.add(new Rectangle2D.Double(layoutBounds.getX() + (double)nextPosition, layoutBounds.getY() + (double)verticalPos, layoutBounds.getWidth(), layoutBounds.getHeight()));
            }
            verticalPos += maxDescent;
        }
        return paragraphBounds;
    }

    @Override
    protected void drawFill(Graphics2D g) {
        g.fill(this.bounds);
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        g.draw(this.bounds);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.bounds.x = Math.min(anchor.x, lead.x);
        this.bounds.y = Math.min(anchor.y, lead.y);
        this.bounds.width = Math.max(1.0, Math.abs(lead.x - anchor.x));
        this.bounds.height = Math.max(1.0, Math.abs(lead.y - anchor.y));
    }

    @Override
    public void transform(AffineTransform tx) {
        Point2D.Double anchor = this.getStartPoint();
        Point2D.Double lead = this.getEndPoint();
        this.setBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
    }

    @Override
    public boolean figureContains(Point2D.Double p) {
        return this.bounds.contains(p);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.bounds.getBounds2D();
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        Rectangle2D.Double r = (Rectangle2D.Double)geometry;
        this.bounds.x = r.x;
        this.bounds.y = r.y;
        this.bounds.width = r.width;
        this.bounds.height = r.height;
    }

    @Override
    public Object getTransformRestoreData() {
        return this.bounds.clone();
    }

    @Override
    public String getText() {
        return this.get(AttributeKeys.TEXT);
    }

    @Override
    public Insets2D.Double getInsets() {
        double sw = Math.ceil(this.get(AttributeKeys.STROKE_WIDTH) / 2.0);
        Insets2D.Double insets = new Insets2D.Double(4.0, 4.0, 4.0, 4.0);
        return new Insets2D.Double(insets.top + sw, insets.left + sw, insets.bottom + sw, insets.right + sw);
    }

    @Override
    public double getBaseline() {
        return (double)this.getFont().getLineMetrics(this.getText(), this.getFontRenderContext()).getAscent() + this.getInsets().top;
    }

    @Override
    public int getTabSize() {
        return 8;
    }

    @Override
    public void setText(String newText) {
        this.set(AttributeKeys.TEXT, newText);
    }

    @Override
    public int getTextColumns() {
        return this.getText() == null ? 4 : Math.max(this.getText().length(), 4);
    }

    @Override
    public Font getFont() {
        return AttributeKeys.getFont(this);
    }

    @Override
    public Color getTextColor() {
        return this.get(AttributeKeys.TEXT_COLOR);
    }

    @Override
    public Color getFillColor() {
        return this.get(AttributeKeys.FILL_COLOR);
    }

    @Override
    public void setFontSize(float size) {
        this.set(AttributeKeys.FONT_SIZE, new Double(size));
    }

    @Override
    public float getFontSize() {
        return this.get(AttributeKeys.FONT_SIZE).floatValue();
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    @Override
    public Tool getTool(Point2D.Double p) {
        if (this.isEditable() && this.contains(p)) {
            TextAreaEditingTool tool = new TextAreaEditingTool(this);
            return tool;
        }
        return null;
    }

    @Override
    public TextHolderFigure getLabelFor() {
        return this;
    }

    @Override
    public TextAreaFigure clone() {
        TextAreaFigure that = (TextAreaFigure)super.clone();
        that.bounds = (Rectangle2D.Double)this.bounds.clone();
        return that;
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList handles = (LinkedList)super.createHandles(detailLevel);
        if (detailLevel == 0) {
            handles.add(new FontSizeHandle(this));
            handles.add(new TextOverflowHandle(this));
        }
        return handles;
    }

    protected void readBounds(DOMInput in) throws IOException {
        this.bounds.x = in.getAttribute("x", 0.0);
        this.bounds.y = in.getAttribute("y", 0.0);
        this.bounds.width = in.getAttribute("w", 0.0);
        this.bounds.height = in.getAttribute("h", 0.0);
    }

    protected void writeBounds(DOMOutput out) throws IOException {
        out.addAttribute("x", this.bounds.x);
        out.addAttribute("y", this.bounds.y);
        out.addAttribute("w", this.bounds.width);
        out.addAttribute("h", this.bounds.height);
    }

    @Override
    public void read(DOMInput in) throws IOException {
        this.readBounds(in);
        this.readAttributes(in);
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        this.writeBounds(out);
        this.writeAttributes(out);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.isTextOverflow = null;
    }

    @Override
    public boolean isTextOverflow() {
        if (this.isTextOverflow == null) {
            Insets2D.Double insets = this.getInsets();
            this.isTextOverflow = this.getPreferredTextSize((double)(this.getBounds().width - insets.left - insets.right)).height > this.getBounds().height - insets.top - insets.bottom;
        }
        return this.isTextOverflow;
    }

    public Dimension2DDouble getPreferredTextSize(double maxWidth) {
        Rectangle2D.Double textRect = new Rectangle2D.Double();
        if (this.getText() != null) {
            Font font = this.getFont();
            boolean isUnderlined = this.get(AttributeKeys.FONT_UNDERLINE);
            float leftMargin = 0.0f;
            float rightMargin = (float)maxWidth - 1.0f;
            float verticalPos = 0.0f;
            float maxVerticalPos = Float.MAX_VALUE;
            if (leftMargin < rightMargin) {
                float tabWidth = (float)((double)this.getTabSize() * font.getStringBounds("m", this.getFontRenderContext()).getWidth());
                float[] tabStops = new float[(int)(textRect.width / (double)tabWidth)];
                for (int i = 0; i < tabStops.length; ++i) {
                    tabStops[i] = (float)(textRect.x + (double)((int)(tabWidth * (float)(i + 1))));
                }
                String[] paragraphs = this.getText().split("\n");
                for (int i = 0; i < paragraphs.length; ++i) {
                    if (paragraphs[i].length() == 0) {
                        paragraphs[i] = " ";
                    }
                    AttributedString as = new AttributedString(paragraphs[i]);
                    as.addAttribute(TextAttribute.FONT, font);
                    if (isUnderlined) {
                        as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
                    }
                    int tabCount = paragraphs[i].split("\t").length - 1;
                    Rectangle2D.Double paragraphBounds = this.drawParagraph(null, as.getIterator(), verticalPos, maxVerticalPos, leftMargin, rightMargin, tabStops, tabCount);
                    verticalPos = (float)(paragraphBounds.y + paragraphBounds.height);
                    textRect.add(paragraphBounds);
                }
            }
        }
        return new Dimension2DDouble(-Math.min(textRect.x, 0.0) + textRect.width, -Math.min(textRect.y, 0.0) + textRect.height);
    }
}

