/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.util.UpdaterUtil;
import net.imagej.util.MediaWikiClient;
import org.scijava.log.LogService;

public final class AvailableSites {
    private static final String SITE_LIST_PAGE_TITLE = "List of update sites";

    private AvailableSites() {
    }

    public static Map<String, UpdateSite> getAvailableSites() throws IOException {
        int start;
        MediaWikiClient wiki = new MediaWikiClient();
        String text = wiki.getPageSource(SITE_LIST_PAGE_TITLE);
        int end = text.indexOf("\n|}\n", start = text.indexOf("\n{| class=\"wikitable\"\n"));
        if (end < 0) {
            end = text.length();
        }
        if (start < 0) {
            throw new IOException("Could not find table");
        }
        String[] table = text.substring(start + 1, end).split("\n\\|-");
        LinkedHashMap<String, UpdateSite> result = new LinkedHashMap<String, UpdateSite>();
        int nameColumn = -1;
        int urlColumn = -1;
        int descriptionColumn = -1;
        int maintainerColumn = -1;
        for (String row : table) {
            if (row.matches("(?s)(\\{\\||[\\|!](style=\"vertical-align|colspan=\"4\")).*")) continue;
            String[] columns = row.split("\n[\\|!]");
            if (columns.length > 1 && columns[1].endsWith("|'''Name'''")) {
                maintainerColumn = -1;
                descriptionColumn = -1;
                urlColumn = -1;
                nameColumn = -1;
                int i = 0;
                for (String column : columns) {
                    if (column.endsWith("|'''Name'''")) {
                        nameColumn = i;
                    } else if (column.endsWith("|'''Site'''")) {
                        urlColumn = i;
                    } else if (column.endsWith("|'''URL'''")) {
                        urlColumn = i;
                    } else if (column.endsWith("|'''Description'''")) {
                        descriptionColumn = i;
                    } else if (column.endsWith("|'''Maintainer'''")) {
                        maintainerColumn = i;
                    }
                    ++i;
                }
                continue;
            }
            if (nameColumn < 0 || urlColumn < 0 || columns.length <= nameColumn || columns.length <= urlColumn) continue;
            UpdateSite info = new UpdateSite(AvailableSites.stripWikiMarkup(columns, nameColumn), AvailableSites.stripWikiMarkup(columns, urlColumn), null, null, AvailableSites.stripWikiMarkup(columns, descriptionColumn), AvailableSites.stripWikiMarkup(columns, maintainerColumn), 0L);
            info.setOfficial(true);
            result.put(info.getURL(), info);
        }
        Iterator iter = result.values().iterator();
        if (!iter.hasNext()) {
            throw new IOException("Invalid page: List of update sites");
        }
        UpdateSite site = (UpdateSite)iter.next();
        if (!site.getName().equals("ImageJ") || !site.getURL().equals("http://update.imagej.net/")) {
            throw new IOException("Invalid page: List of update sites");
        }
        if (!iter.hasNext()) {
            throw new IOException("Invalid page: List of update sites");
        }
        site = (UpdateSite)iter.next();
        if (!site.getName().equals("Fiji") || !site.getURL().equals("http://update.fiji.sc/")) {
            throw new IOException("Invalid page: List of update sites");
        }
        return result;
    }

    public static List<UpdateSite> initializeSites(FilesCollection files) {
        return AvailableSites.initializeSites(files, null);
    }

    public static List<UpdateSite> initializeSites(FilesCollection files, LogService log) {
        ArrayList<UpdateSite> sites = new ArrayList<UpdateSite>();
        HashMap<String, Integer> url2index = new HashMap<String, Integer>();
        UpdateSite mainSite = new UpdateSite("ImageJ", UpdaterUtil.MAIN_URL, "", "", null, null, 0L);
        mainSite.setOfficial(true);
        sites.add(mainSite);
        url2index.put(mainSite.getURL(), 0);
        try {
            for (UpdateSite site : AvailableSites.getAvailableSites().values()) {
                Integer index = (Integer)url2index.get(site.getURL());
                if (index == null) {
                    url2index.put(site.getURL(), sites.size());
                    sites.add(site);
                    continue;
                }
                sites.set(index, site);
            }
        }
        catch (Exception e) {
            if (log != null) {
                log.error((Object)"Error processing available update sites from ImageJ wiki", (Throwable)e);
            }
            e.printStackTrace();
        }
        HashSet<String> names = new HashSet<String>();
        for (String name : files.getUpdateSiteNames(true)) {
            UpdateSite site = files.getUpdateSite(name, true);
            Integer index = (Integer)url2index.get(site.getURL());
            if (index == null) {
                url2index.put(site.getURL(), sites.size());
                sites.add(site);
                continue;
            }
            UpdateSite listed = (UpdateSite)sites.get(index);
            site.setDescription(listed.getDescription());
            site.setMaintainer(listed.getMaintainer());
            sites.set(index, site);
        }
        for (UpdateSite site : sites) {
            if (site.isActive()) continue;
            if (names.contains(site.getName())) {
                int i = 2;
                while (names.contains(site.getName() + "-" + i)) {
                    ++i;
                }
                site.setName(site.getName() + "-" + i);
            }
            names.add(site.getName());
        }
        return sites;
    }

    public static void initializeAndAddSites(FilesCollection files) {
        AvailableSites.initializeAndAddSites(files, null);
    }

    public static void initializeAndAddSites(FilesCollection files, LogService log) {
        for (UpdateSite site : AvailableSites.initializeSites(files, log)) {
            files.addUpdateSite(site);
        }
    }

    private static String stripWikiMarkup(String[] columns, int index) {
        if (index < 0 || index >= columns.length) {
            return null;
        }
        String string = columns[index];
        return string.replaceAll("'''", "").replaceAll("\\[\\[([^\\|\\]]*\\|)?([^\\]]*)\\]\\]", "$2").replaceAll("\\[[^\\[][^ ]*([^\\]]*)\\]", "$1");
    }
}

