/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.RealTransform;

public class ThinplateSplineTransform
implements RealTransform {
    protected final ThinPlateR2LogRSplineKernelTransform tps;
    protected final double[] a;
    protected final double[] b;

    private static final ThinPlateR2LogRSplineKernelTransform init(double[][] p, double[][] q) {
        assert (p.length == q.length);
        ThinPlateR2LogRSplineKernelTransform tps = new ThinPlateR2LogRSplineKernelTransform(p.length, p, q);
        return tps;
    }

    public ThinplateSplineTransform(ThinPlateR2LogRSplineKernelTransform tps) {
        this.tps = tps;
        this.a = new double[tps.getNumDims()];
        this.b = new double[this.a.length];
    }

    public ThinplateSplineTransform(double[][] p, double[][] q) {
        this(ThinplateSplineTransform.init(p, q));
    }

    @Override
    public void apply(double[] source, double[] target) {
        this.tps.apply(source, target);
    }

    @Override
    public void apply(float[] source, float[] target) {
        int d;
        for (d = 0; d < this.a.length; ++d) {
            this.a[d] = source[d];
        }
        this.tps.apply(this.a, this.b);
        for (d = 0; d < target.length; ++d) {
            target[d] = (float)this.b[d];
        }
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        source.localize(this.a);
        this.tps.apply(this.a, this.b);
        target.setPosition(this.b);
    }

    @Override
    public ThinplateSplineTransform copy() {
        return new ThinplateSplineTransform(this.tps);
    }

    @Override
    public int numSourceDimensions() {
        return this.tps.getNumDims();
    }

    @Override
    public int numTargetDimensions() {
        return this.tps.getNumDims();
    }
}

