/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary;

import java.util.Random;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.iterableinterval.unary.MakeHistogram;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

@Deprecated
public class EqualizeHistogram<T extends RealType<T>>
implements UnaryOperation<IterableInterval<T>, IterableInterval<T>> {
    private final int numBins;

    public EqualizeHistogram(int numBins) {
        this.numBins = numBins;
    }

    @Override
    public IterableInterval<T> compute(IterableInterval<T> in, IterableInterval<T> r) {
        assert (in.iterationOrder().equals(r.iterationOrder()));
        Histogram1d histo = new MakeHistogram<T>(this.numBins).compute((Iterable<T>)in);
        RealType val = (RealType)((RealType)r.firstElement()).createVariable();
        long min = (long)val.getMaxValue();
        if (9.223372036854776E18 < val.getMaxValue()) {
            min = Long.MAX_VALUE;
        }
        long[] histoArray = histo.toLongArray();
        int i = 1;
        while ((long)i < histo.getBinCount()) {
            histoArray[i] = histoArray[i] + histoArray[i - 1];
            if (histoArray[i] != 0L) {
                min = Math.min(min, histoArray[i]);
            }
            ++i;
        }
        double gmax = histo.getBinCount();
        Cursor cin = in.cursor();
        Cursor cout = r.cursor();
        long numPix = r.size();
        while (cin.hasNext()) {
            cin.fwd();
            cout.fwd();
            val = (RealType)cin.get();
            long p = histoArray[(int)histo.map((Object)val)];
            double t = p - min;
            t /= (double)(numPix - min);
            p = (int)Math.round(t *= gmax);
            if (p >= histo.getBinCount()) {
                p = histo.getBinCount() - 1L;
            }
            if (p < 0L) {
                p = 0L;
            }
            histo.getCenterValue(p, cout.get());
        }
        return r;
    }

    @Override
    public UnaryOperation<IterableInterval<T>, IterableInterval<T>> copy() {
        return new EqualizeHistogram<T>(this.numBins);
    }

    public static void main(String[] args) {
        Img test = new ArrayImgFactory().create(new int[]{10, 10}, (Object)new FloatType());
        Random rand = new Random();
        for (FloatType t : test) {
            t.setReal(rand.nextDouble() * 3.4028234663852886E38);
        }
        new EqualizeHistogram(256).compute((IterableInterval)test, (IterableInterval)test);
    }
}

