/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.img.unary;

import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.img.Img;
import net.imglib2.ops.operation.UnaryOutputOperation;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.type.Type;
import net.imglib2.view.Views;

@Deprecated
public class ImgRotate2D<T extends Type<T> & Comparable<T>>
implements UnaryOutputOperation<Img<T>, Img<T>> {
    private final double m_angle;
    private final int m_dimIdx1;
    private final int m_dimIdx2;
    private final boolean m_keepSize;
    private final T m_outOfBoundsType;
    private final long[] m_center;

    public ImgRotate2D(double angle, int dimIdx1, int dimIdx2, boolean keepSize, T outOfBoundsType, long[] center) {
        this.m_angle = angle;
        this.m_dimIdx1 = dimIdx1;
        this.m_dimIdx2 = dimIdx2;
        this.m_keepSize = keepSize;
        this.m_outOfBoundsType = outOfBoundsType;
        this.m_center = center;
    }

    @Override
    public Img<T> createEmptyOutput(Img<T> op) {
        if (this.m_keepSize) {
            return op.factory().create(op, (Object)((Type)op.randomAccess().get()).createVariable());
        }
        long[] min = new long[op.numDimensions()];
        long[] max = new long[op.numDimensions()];
        op.min(min);
        op.max(max);
        min[this.m_dimIdx2] = Long.MAX_VALUE;
        min[this.m_dimIdx1] = Long.MAX_VALUE;
        max[this.m_dimIdx2] = Long.MIN_VALUE;
        max[this.m_dimIdx1] = Long.MIN_VALUE;
        double[] center = this.calcCenter((Interval)op);
        long[] lArray = new long[]{0L, op.max(this.m_dimIdx1)};
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long orgX = lArray[i];
            long[] lArray2 = new long[]{0L, op.max(this.m_dimIdx2)};
            int n2 = lArray2.length;
            for (int j = 0; j < n2; ++j) {
                Long orgY = lArray2[j];
                double x = ((double)orgX.longValue() - center[this.m_dimIdx1]) * Math.cos(this.m_angle) - ((double)orgY.longValue() - center[this.m_dimIdx2]) * Math.sin(this.m_angle);
                double y = ((double)orgX.longValue() - center[this.m_dimIdx1]) * Math.sin(this.m_angle) + ((double)orgY.longValue() - center[this.m_dimIdx2]) * Math.cos(this.m_angle);
                min[this.m_dimIdx1] = (int)Math.round(Math.min(x, (double)min[this.m_dimIdx1]));
                min[this.m_dimIdx2] = (int)Math.round(Math.min(y, (double)min[this.m_dimIdx2]));
                max[this.m_dimIdx1] = (int)Math.round(Math.max(x, (double)max[this.m_dimIdx1]));
                max[this.m_dimIdx2] = (int)Math.round(Math.max(y, (double)max[this.m_dimIdx2]));
            }
        }
        long[] dims = new long[min.length];
        for (int i = 0; i < dims.length; ++i) {
            dims[i] = max[i] - min[i];
        }
        return op.factory().create((Dimensions)new FinalInterval(dims), (Object)((Type)op.randomAccess().get()).createVariable());
    }

    @Override
    public Img<T> compute(Img<T> op, Img<T> r) {
        OutOfBounds srcRA = Views.extendValue(op, this.m_outOfBoundsType).randomAccess();
        Cursor resCur = r.localizingCursor();
        double[] srcCenter = this.calcCenter((Interval)op);
        double[] resCenter = new double[op.numDimensions()];
        for (int i = 0; i < resCenter.length; ++i) {
            resCenter[i] = srcCenter[i] * ((double)r.dimension(i) / (double)op.dimension(i));
        }
        while (resCur.hasNext()) {
            resCur.fwd();
            double x = (resCur.getDoublePosition(this.m_dimIdx1) - resCenter[this.m_dimIdx1]) * Math.cos(this.m_angle) - (resCur.getDoublePosition(this.m_dimIdx2) - resCenter[this.m_dimIdx2]) * Math.sin(this.m_angle) + srcCenter[this.m_dimIdx1];
            double y = (resCur.getDoublePosition(this.m_dimIdx1) - resCenter[this.m_dimIdx1]) * Math.sin(this.m_angle) + (resCur.getDoublePosition(this.m_dimIdx2) - resCenter[this.m_dimIdx2]) * Math.cos(this.m_angle) + srcCenter[this.m_dimIdx2];
            srcRA.setPosition((int)Math.round(x), this.m_dimIdx1);
            srcRA.setPosition((int)Math.round(y), this.m_dimIdx2);
            for (int i = 0; i < op.numDimensions(); ++i) {
                if (i == this.m_dimIdx1 || i == this.m_dimIdx2) continue;
                srcRA.setPosition(resCur.getIntPosition(i), i);
            }
            ((Type)resCur.get()).set((Type)srcRA.get());
        }
        return r;
    }

    private double[] calcCenter(Interval interval) {
        double[] center = new double[interval.numDimensions()];
        if (this.m_center == null) {
            for (int i = 0; i < center.length; ++i) {
                center[i] = (double)interval.dimension(i) / 2.0;
            }
        } else {
            for (int i = 0; i < center.length; ++i) {
                center[i] = this.m_center[i];
            }
        }
        return center;
    }

    @Override
    public UnaryOutputOperation<Img<T>, Img<T>> copy() {
        return new ImgRotate2D<T>(this.m_angle, this.m_dimIdx1, this.m_dimIdx2, this.m_keepSize, this.m_outOfBoundsType, this.m_center);
    }

    @Override
    public Img<T> compute(Img<T> arg0) {
        return this.compute(arg0, this.createEmptyOutput(arg0));
    }
}

