/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.LocalShiftFinder;
import edu.mines.jtk.util.ArrayMath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LocalShiftFinderTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(LocalShiftFinderTest.class);
        TestRunner.run((Test)suite);
    }

    public void testCosine() {
        float w = 0.12566371f;
        int n1 = 1001;
        float shift = 10.0f;
        float sigma = 8.0f * shift;
        float[] f = ArrayMath.cos(ArrayMath.rampfloat(w * shift, w, n1));
        float[] g = ArrayMath.cos(ArrayMath.rampfloat(0.0f, w, n1));
        float[] u = new float[n1];
        float[] c = new float[n1];
        float[] d = new float[n1];
        int min1 = -2 * (int)shift;
        int max1 = 2 * (int)shift;
        LocalShiftFinder lsf = new LocalShiftFinder(shift);
        lsf.find1(min1, max1, f, g, u, c, d);
        for (int i1 = n1 / 4; i1 < 3 * n1 / 4; ++i1) {
            LocalShiftFinderTest.assertEquals((float)shift, (float)u[i1], (float)0.02f);
            LocalShiftFinderTest.assertEquals((float)1.0f, (float)c[i1], (float)0.02f);
            LocalShiftFinderTest.assertEquals((float)1.0f, (float)d[i1], (float)0.02f);
        }
    }
}

