/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Conv;
import edu.mines.jtk.util.ArrayMath;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ConvTest
extends TestCase {
    private Random _random = new Random();
    private static final float TOLERANCE = 1.1920929E-4f;

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(ConvTest.class);
        TestRunner.run((Test)suite);
    }

    public void test1Random() {
        int ntest = 1000;
        int kmin = -2;
        int kmax = 2;
        int lmin = 1;
        int lmax = 8;
        for (int itest = 0; itest < ntest; ++itest) {
            int lx = lmin + this._random.nextInt(1 + lmax - lmin);
            int ly = lmin + this._random.nextInt(1 + lmax - lmin);
            int lz = lmin + this._random.nextInt(1 + lmax - lmin);
            int kx = kmin + this._random.nextInt(1 + kmax - kmin);
            int ky = kmin + this._random.nextInt(1 + kmax - kmin);
            int kz = kmin + this._random.nextInt(1 + kmax - kmin);
            float[] x = ArrayMath.randfloat(lx);
            float[] y = ArrayMath.randfloat(ly);
            float[] zs = ArrayMath.zerofloat(lz);
            float[] zf = ArrayMath.zerofloat(lz);
            if (this._random.nextBoolean()) {
                y = x;
                ly = lx;
                ky = kx;
            }
            ConvTest.convSimple(lx, kx, x, ly, ky, y, lz, kz, zs);
            Conv.conv(lx, kx, x, ly, ky, y, lz, kz, zf);
            ConvTest.assertEquals(zs, zf);
            ConvTest.xcorSimple(lx, kx, x, ly, ky, y, lz, kz, zs);
            Conv.xcor(lx, kx, x, ly, ky, y, lz, kz, zf);
            ConvTest.assertEquals(zs, zf);
        }
    }

    public void test2Random() {
        int ntest = 1000;
        int kmin = -2;
        int kmax = 2;
        int lmin = 1;
        int lmax = 8;
        for (int itest = 0; itest < ntest; ++itest) {
            int lx1 = lmin + this._random.nextInt(1 + lmax - lmin);
            int lx2 = lmin + this._random.nextInt(1 + lmax - lmin);
            int ly1 = lmin + this._random.nextInt(1 + lmax - lmin);
            int ly2 = lmin + this._random.nextInt(1 + lmax - lmin);
            int lz1 = lmin + this._random.nextInt(1 + lmax - lmin);
            int lz2 = lmin + this._random.nextInt(1 + lmax - lmin);
            int kx1 = kmin + this._random.nextInt(1 + kmax - kmin);
            int kx2 = kmin + this._random.nextInt(1 + kmax - kmin);
            int ky1 = kmin + this._random.nextInt(1 + kmax - kmin);
            int ky2 = kmin + this._random.nextInt(1 + kmax - kmin);
            int kz1 = kmin + this._random.nextInt(1 + kmax - kmin);
            int kz2 = kmin + this._random.nextInt(1 + kmax - kmin);
            float[][] x = ArrayMath.randfloat(lx1, lx2);
            float[][] y = ArrayMath.randfloat(ly1, ly2);
            float[][] zs = ArrayMath.zerofloat(lz1, lz2);
            float[][] zf = ArrayMath.zerofloat(lz1, lz2);
            if (this._random.nextBoolean()) {
                y = x;
                ly1 = lx1;
                ky1 = kx1;
                ly2 = lx2;
                ky2 = kx2;
            }
            ConvTest.convSimple(lx1, lx2, kx1, kx2, x, ly1, ly2, ky1, ky2, y, lz1, lz2, kz1, kz2, zs);
            Conv.conv(lx1, lx2, kx1, kx2, x, ly1, ly2, ky1, ky2, y, lz1, lz2, kz1, kz2, zf);
            ConvTest.assertEquals(zs, zf);
            ConvTest.xcorSimple(lx1, lx2, kx1, kx2, x, ly1, ly2, ky1, ky2, y, lz1, lz2, kz1, kz2, zs);
            Conv.xcor(lx1, lx2, kx1, kx2, x, ly1, ly2, ky1, ky2, y, lz1, lz2, kz1, kz2, zf);
            ConvTest.assertEquals(zs, zf);
        }
    }

    public void test3Random() {
        int ntest = 100;
        int kmin = -2;
        int kmax = 2;
        int lmin = 1;
        int lmax = 8;
        for (int itest = 0; itest < ntest; ++itest) {
            int lx1 = lmin + this._random.nextInt(1 + lmax - lmin);
            int lx2 = lmin + this._random.nextInt(1 + lmax - lmin);
            int lx3 = lmin + this._random.nextInt(1 + lmax - lmin);
            int ly1 = lmin + this._random.nextInt(1 + lmax - lmin);
            int ly2 = lmin + this._random.nextInt(1 + lmax - lmin);
            int ly3 = lmin + this._random.nextInt(1 + lmax - lmin);
            int lz1 = lmin + this._random.nextInt(1 + lmax - lmin);
            int lz2 = lmin + this._random.nextInt(1 + lmax - lmin);
            int lz3 = lmin + this._random.nextInt(1 + lmax - lmin);
            int kx1 = kmin + this._random.nextInt(1 + kmax - kmin);
            int kx2 = kmin + this._random.nextInt(1 + kmax - kmin);
            int kx3 = kmin + this._random.nextInt(1 + kmax - kmin);
            int ky1 = kmin + this._random.nextInt(1 + kmax - kmin);
            int ky2 = kmin + this._random.nextInt(1 + kmax - kmin);
            int ky3 = kmin + this._random.nextInt(1 + kmax - kmin);
            int kz1 = kmin + this._random.nextInt(1 + kmax - kmin);
            int kz2 = kmin + this._random.nextInt(1 + kmax - kmin);
            int kz3 = kmin + this._random.nextInt(1 + kmax - kmin);
            float[][][] x = ArrayMath.randfloat(lx1, lx2, lx3);
            float[][][] y = ArrayMath.randfloat(ly1, ly2, ly3);
            float[][][] zs = ArrayMath.zerofloat(lz1, lz2, lz3);
            float[][][] zf = ArrayMath.zerofloat(lz1, lz2, lz3);
            if (this._random.nextBoolean()) {
                y = x;
                ly1 = lx1;
                ky1 = kx1;
                ly2 = lx2;
                ky2 = kx2;
                ly3 = lx3;
                ky3 = kx3;
            }
            ConvTest.convSimple(lx1, lx2, lx3, kx1, kx2, kx3, x, ly1, ly2, ly3, ky1, ky2, ky3, y, lz1, lz2, lz3, kz1, kz2, kz3, zs);
            Conv.conv(lx1, lx2, lx3, kx1, kx2, kx3, x, ly1, ly2, ly3, ky1, ky2, ky3, y, lz1, lz2, lz3, kz1, kz2, kz3, zf);
            ConvTest.assertEquals(zs, zf);
            ConvTest.xcorSimple(lx1, lx2, lx3, kx1, kx2, kx3, x, ly1, ly2, ly3, ky1, ky2, ky3, y, lz1, lz2, lz3, kz1, kz2, kz3, zs);
            Conv.xcor(lx1, lx2, lx3, kx1, kx2, kx3, x, ly1, ly2, ly3, ky1, ky2, ky3, y, lz1, lz2, lz3, kz1, kz2, kz3, zf);
            ConvTest.assertEquals(zs, zf);
        }
    }

    private static void convSimple(int lx, int kx, float[] x, int ly, int ky, float[] y, int lz, int kz, float[] z) {
        int ilo = kz - kx - ky;
        int ihi = ilo + lz - 1;
        for (int i = ilo; i <= ihi; ++i) {
            int jlo = ArrayMath.max(0, i - ly + 1);
            int jhi = ArrayMath.min(lx - 1, i);
            float sum = 0.0f;
            for (int j = jlo; j <= jhi; ++j) {
                sum += x[j] * y[i - j];
            }
            z[i - ilo] = sum;
        }
    }

    private static void xcorSimple(int lx, int kx, float[] x, int ly, int ky, float[] y, int lz, int kz, float[] z) {
        int ilo = kz + kx - ky;
        int ihi = ilo + lz - 1;
        for (int i = ilo; i <= ihi; ++i) {
            int jlo = ArrayMath.max(0, -i);
            int jhi = ArrayMath.min(lx - 1, ly - 1 - i);
            float sum = 0.0f;
            for (int j = jlo; j <= jhi; ++j) {
                sum += x[j] * y[i + j];
            }
            z[i - ilo] = sum;
        }
    }

    private static void convSimple(int lx1, int lx2, int kx1, int kx2, float[][] x, int ly1, int ly2, int ky1, int ky2, float[][] y, int lz1, int lz2, int kz1, int kz2, float[][] z) {
        int ilo1 = kz1 - kx1 - ky1;
        int ihi1 = ilo1 + lz1 - 1;
        int ilo2 = kz2 - kx2 - ky2;
        int ihi2 = ilo2 + lz2 - 1;
        for (int i2 = ilo2; i2 <= ihi2; ++i2) {
            for (int i1 = ilo1; i1 <= ihi1; ++i1) {
                int jlo1 = ArrayMath.max(0, i1 - ly1 + 1);
                int jhi1 = ArrayMath.min(lx1 - 1, i1);
                int jlo2 = ArrayMath.max(0, i2 - ly2 + 1);
                int jhi2 = ArrayMath.min(lx2 - 1, i2);
                float sum = 0.0f;
                for (int j2 = jlo2; j2 <= jhi2; ++j2) {
                    for (int j1 = jlo1; j1 <= jhi1; ++j1) {
                        sum += x[j2][j1] * y[i2 - j2][i1 - j1];
                    }
                }
                z[i2 - ilo2][i1 - ilo1] = sum;
            }
        }
    }

    private static void xcorSimple(int lx1, int lx2, int kx1, int kx2, float[][] x, int ly1, int ly2, int ky1, int ky2, float[][] y, int lz1, int lz2, int kz1, int kz2, float[][] z) {
        int ilo1 = kz1 + kx1 - ky1;
        int ihi1 = ilo1 + lz1 - 1;
        int ilo2 = kz2 + kx2 - ky2;
        int ihi2 = ilo2 + lz2 - 1;
        for (int i2 = ilo2; i2 <= ihi2; ++i2) {
            for (int i1 = ilo1; i1 <= ihi1; ++i1) {
                int jlo1 = ArrayMath.max(0, -i1);
                int jhi1 = ArrayMath.min(lx1 - 1, ly1 - 1 - i1);
                int jlo2 = ArrayMath.max(0, -i2);
                int jhi2 = ArrayMath.min(lx2 - 1, ly2 - 1 - i2);
                float sum = 0.0f;
                for (int j2 = jlo2; j2 <= jhi2; ++j2) {
                    for (int j1 = jlo1; j1 <= jhi1; ++j1) {
                        sum += x[j2][j1] * y[i2 + j2][i1 + j1];
                    }
                }
                z[i2 - ilo2][i1 - ilo1] = sum;
            }
        }
    }

    private static void convSimple(int lx1, int lx2, int lx3, int kx1, int kx2, int kx3, float[][][] x, int ly1, int ly2, int ly3, int ky1, int ky2, int ky3, float[][][] y, int lz1, int lz2, int lz3, int kz1, int kz2, int kz3, float[][][] z) {
        int ilo1 = kz1 - kx1 - ky1;
        int ilo2 = kz2 - kx2 - ky2;
        int ilo3 = kz3 - kx3 - ky3;
        int ihi1 = ilo1 + lz1 - 1;
        int ihi2 = ilo2 + lz2 - 1;
        int ihi3 = ilo3 + lz3 - 1;
        for (int i3 = ilo3; i3 <= ihi3; ++i3) {
            for (int i2 = ilo2; i2 <= ihi2; ++i2) {
                for (int i1 = ilo1; i1 <= ihi1; ++i1) {
                    int jlo1 = ArrayMath.max(0, i1 - ly1 + 1);
                    int jlo2 = ArrayMath.max(0, i2 - ly2 + 1);
                    int jlo3 = ArrayMath.max(0, i3 - ly3 + 1);
                    int jhi1 = ArrayMath.min(lx1 - 1, i1);
                    int jhi2 = ArrayMath.min(lx2 - 1, i2);
                    int jhi3 = ArrayMath.min(lx3 - 1, i3);
                    float sum = 0.0f;
                    for (int j3 = jlo3; j3 <= jhi3; ++j3) {
                        for (int j2 = jlo2; j2 <= jhi2; ++j2) {
                            for (int j1 = jlo1; j1 <= jhi1; ++j1) {
                                sum += x[j3][j2][j1] * y[i3 - j3][i2 - j2][i1 - j1];
                            }
                        }
                    }
                    z[i3 - ilo3][i2 - ilo2][i1 - ilo1] = sum;
                }
            }
        }
    }

    private static void xcorSimple(int lx1, int lx2, int lx3, int kx1, int kx2, int kx3, float[][][] x, int ly1, int ly2, int ly3, int ky1, int ky2, int ky3, float[][][] y, int lz1, int lz2, int lz3, int kz1, int kz2, int kz3, float[][][] z) {
        int ilo1 = kz1 + kx1 - ky1;
        int ilo2 = kz2 + kx2 - ky2;
        int ilo3 = kz3 + kx3 - ky3;
        int ihi1 = ilo1 + lz1 - 1;
        int ihi2 = ilo2 + lz2 - 1;
        int ihi3 = ilo3 + lz3 - 1;
        for (int i3 = ilo3; i3 <= ihi3; ++i3) {
            for (int i2 = ilo2; i2 <= ihi2; ++i2) {
                for (int i1 = ilo1; i1 <= ihi1; ++i1) {
                    int jlo1 = ArrayMath.max(0, -i1);
                    int jlo2 = ArrayMath.max(0, -i2);
                    int jlo3 = ArrayMath.max(0, -i3);
                    int jhi1 = ArrayMath.min(lx1 - 1, ly1 - 1 - i1);
                    int jhi2 = ArrayMath.min(lx2 - 1, ly2 - 1 - i2);
                    int jhi3 = ArrayMath.min(lx3 - 1, ly3 - 1 - i3);
                    float sum = 0.0f;
                    for (int j3 = jlo3; j3 <= jhi3; ++j3) {
                        for (int j2 = jlo2; j2 <= jhi2; ++j2) {
                            for (int j1 = jlo1; j1 <= jhi1; ++j1) {
                                sum += x[j3][j2][j1] * y[i3 + j3][i2 + j2][i1 + j1];
                            }
                        }
                    }
                    z[i3 - ilo3][i2 - ilo2][i1 - ilo1] = sum;
                }
            }
        }
    }

    private static void assertEquals(float[] a, float[] b) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            ConvTest.assertEquals((float)a[i], (float)b[i], (float)1.1920929E-4f);
        }
    }

    private static void assertEquals(float[][] a, float[][] b) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            ConvTest.assertEquals(a[i], b[i]);
        }
    }

    private static void assertEquals(float[][][] a, float[][][] b) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            ConvTest.assertEquals(a[i], b[i]);
        }
    }
}

