/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.notebook.converter;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.Converter;
import org.scijava.notebook.converter.HTMLNotebookOutputConverter;
import org.scijava.notebook.converter.HTMLTableBuilder;
import org.scijava.notebook.converter.output.HTMLTableNotebookOutput;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class)
public class ListToHTMLTableNotebookConverter
extends HTMLNotebookOutputConverter<List<?>, HTMLTableNotebookOutput> {
    @Override
    public Class<List<?>> getInputType() {
        return List.class;
    }

    @Override
    public Class<HTMLTableNotebookOutput> getOutputType() {
        return HTMLTableNotebookOutput.class;
    }

    @Override
    public boolean canConvert(ConversionRequest request) {
        Object src = request.sourceObject();
        if (src != null && src instanceof List && !(((List)src).get(0) instanceof Map)) {
            return super.canConvert(request);
        }
        return false;
    }

    @Override
    public boolean canConvert(Object src, Type dest) {
        if (src == null) {
            return false;
        }
        if (src instanceof List && !(((List)src).get(0) instanceof Map)) {
            Class<?> srcClass = src.getClass();
            return super.canConvert(srcClass, dest);
        }
        return false;
    }

    @Override
    public boolean canConvert(Object src, Class<?> dest) {
        if (src == null) {
            return false;
        }
        if (src instanceof List && !(((List)src).get(0) instanceof Map)) {
            Class<?> srcClass = src.getClass();
            return super.canConvert(srcClass, dest);
        }
        return false;
    }

    @Override
    public HTMLTableNotebookOutput convert(Object object) {
        List list = (List)object;
        String htmlTable = "<table class=\"converted\"><tbody>";
        for (int i = 0; i < list.size(); ++i) {
            String data = list.get(i) == null ? "&nbsp;" : this.asHTML(list.get(i));
            htmlTable = htmlTable + HTMLTableBuilder.appendData(data, true, true);
        }
        htmlTable = htmlTable + HTMLTableBuilder.endTable();
        return new HTMLTableNotebookOutput(HTMLTableBuilder.getTableStyle(false) + htmlTable);
    }
}

