/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.notebook.converter;

import java.io.IOException;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.internal.chartpart.Chart;
import org.scijava.convert.Converter;
import org.scijava.notebook.converter.NotebookOutputConverter;
import org.scijava.notebook.converter.output.PNGImageNotebookOutput;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class)
public class ChartToPNGNotebookConverter
extends NotebookOutputConverter<Chart, PNGImageNotebookOutput> {
    @Override
    public Class<Chart> getInputType() {
        return Chart.class;
    }

    @Override
    public Class<PNGImageNotebookOutput> getOutputType() {
        return PNGImageNotebookOutput.class;
    }

    @Override
    public PNGImageNotebookOutput convert(Object object) {
        Chart chart = (Chart)object;
        try {
            byte[] bt = BitmapEncoder.getBitmapBytes((Chart)chart, (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
            Base64.getEncoder().encodeToString(bt);
            return new PNGImageNotebookOutput(Base64.getEncoder().encodeToString(bt));
        }
        catch (IOException ex) {
            Logger.getLogger(ChartToPNGNotebookConverter.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

