/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.kernel.evaluator;

import com.twosigma.beaker.autocomplete.AutocompleteResult;
import com.twosigma.beaker.evaluator.Evaluator;
import com.twosigma.beaker.jvm.object.SimpleEvaluationObject;
import com.twosigma.jupyter.KernelParameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.scijava.Context;
import org.scijava.jupyter.kernel.evaluator.Worker;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.script.AutoCompleter;
import org.scijava.script.AutoCompletionResult;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.thread.ThreadService;

public class ScijavaEvaluator
implements Evaluator {
    public static final String DEFAULT_LANGUAGE = "groovy";
    @Parameter
    private LogService log;
    @Parameter
    private transient ScriptService scriptService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    Context context;
    private final Map<String, ScriptEngine> scriptEngines;
    private final Map<String, ScriptLanguage> scriptLanguages;
    private final Map<String, AutoCompleter> completers;
    private String languageName;
    protected String shellId;
    protected String sessionId;

    public ScijavaEvaluator(Context context, String shellId, String sessionId) {
        context.inject(this);
        this.shellId = shellId;
        this.sessionId = sessionId;
        this.scriptEngines = new HashMap<String, ScriptEngine>();
        this.scriptLanguages = new HashMap<String, ScriptLanguage>();
        this.completers = new HashMap<String, AutoCompleter>();
        this.languageName = DEFAULT_LANGUAGE;
    }

    public void setShellOptions(KernelParameters kp) throws IOException {
        this.log.debug("Set shell options : " + kp);
    }

    public AutocompleteResult autocomplete(String code, int index) {
        int startIndex;
        List<Object> matches;
        AutoCompleter completer = this.completers.get(this.languageName);
        ScriptEngine scriptEngine = this.scriptEngines.get(this.languageName);
        if (completer != null) {
            AutoCompletionResult result = completer.autocomplete(code, index, scriptEngine);
            matches = result.getMatches();
            startIndex = result.getStartIndex();
        } else {
            matches = new ArrayList();
            startIndex = 0;
        }
        return new AutocompleteResult(matches, startIndex);
    }

    public void killAllThreads() {
        this.log.debug("Kill All Threads");
        System.exit(0);
    }

    public void startWorker() {
    }

    public void evaluate(SimpleEvaluationObject seo, String code) {
        code = this.setLanguage(code);
        Worker worker = new Worker(this.context, this.scriptEngines, this.scriptLanguages);
        worker.setup(seo, code, this.languageName);
        this.threadService.queue(this.getClass().getName(), worker);
    }

    public void exit() {
        this.log.debug("Exiting DefaultEvaluator");
        System.exit(0);
    }

    private void addLanguage(String langName) {
        if (this.scriptService.getLanguageByName(langName) == null) {
            this.log.error("Script Language for '" + langName + "' not found.");
            System.exit(1);
        }
        if (!this.scriptLanguages.keySet().contains(langName)) {
            Bindings bindings = null;
            if (!this.scriptEngines.isEmpty()) {
                String firstLanguage = this.scriptEngines.keySet().iterator().next();
                bindings = this.scriptEngines.get(firstLanguage).getBindings(100);
            }
            this.log.info("Script Language for '" + langName + "' found.");
            ScriptLanguage scriptLanguage = this.scriptService.getLanguageByName(langName);
            this.scriptLanguages.put(langName, scriptLanguage);
            ScriptEngine engine = this.scriptLanguages.get(langName).getScriptEngine();
            this.scriptEngines.put(langName, engine);
            AutoCompleter completer = scriptLanguage.getAutoCompleter();
            this.completers.put(this.languageName, completer);
            if (bindings != null) {
                this.initBindings(bindings, engine, scriptLanguage);
            }
        }
        this.log.debug("Script Language found for '" + langName + "'");
    }

    private String setLanguage(String code) {
        if (code.startsWith("#!")) {
            if (code.split("\n").length > 1) {
                this.languageName = code.substring(2, code.indexOf("\n")).trim();
                code = code.substring(code.indexOf("\n") + 1);
            } else {
                this.languageName = code.substring(2).trim();
                code = "";
            }
        }
        this.addLanguage(this.languageName);
        return code;
    }

    private void initBindings(Bindings bindings, ScriptEngine scriptEngine, ScriptLanguage scriptLanguage) {
        Bindings currentBindings = scriptEngine.getBindings(100);
        bindings.keySet().forEach(key -> currentBindings.put((String)key, scriptLanguage.decode(bindings.get(key))));
    }
}

