/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationModel2D
extends AbstractAffineModel2D<TranslationModel2D> {
    private static final long serialVersionUID = -6412303652902075611L;
    protected static final int MIN_NUM_MATCHES = 1;
    protected double tx = 0.0;
    protected double ty = 0.0;

    @Override
    public final int getMinNumMatches() {
        return 1;
    }

    @Override
    public final AffineTransform createAffine() {
        return new AffineTransform(1.0, 0.0, 0.0, 1.0, this.tx, this.ty);
    }

    @Override
    public final AffineTransform createInverseAffine() {
        return new AffineTransform(1.0, 0.0, 0.0, 1.0, -this.tx, -this.ty);
    }

    @Override
    public final double[] apply(double[] l) {
        assert (l.length >= 2) : "2d translation transformations can be applied to 2d points only.";
        return new double[]{l[0] + this.tx, l[1] + this.ty};
    }

    @Override
    public final void applyInPlace(double[] l) {
        assert (l.length >= 2) : "2d translation transformations can be applied to 2d points only.";
        l[0] = l[0] + this.tx;
        l[1] = l[1] + this.ty;
    }

    @Override
    public final double[] applyInverse(double[] l) {
        assert (l.length >= 2) : "2d translation transformations can be applied to 2d points only.";
        return new double[]{l[0] - this.tx, l[1] - this.ty};
    }

    @Override
    public final void applyInverseInPlace(double[] l) {
        assert (l.length >= 2) : "2d translation transformations can be applied to 2d points only.";
        l[0] = l[0] - this.tx;
        l[1] = l[1] - this.ty;
    }

    @Override
    public final void fit(double[][] p, double[][] q, double[] w) throws NotEnoughDataPointsException {
        assert (p.length >= 2 && q.length >= 2) : "2d translations can be applied to 2d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 1) {
            throw new NotEnoughDataPointsException(l + " data points are not enough to estimate a 2d translation model, at least " + 1 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (int i = 0; i < l; ++i) {
            double[] pX = p[0];
            double[] pY = p[1];
            double[] qX = q[0];
            double[] qY = q[1];
            double ww = w[i];
            ws += ww;
            pcx += ww * pX[i];
            pcy += ww * pY[i];
            qcx += ww * qX[i];
            qcy += ww * qY[i];
        }
        this.tx = (qcx /= ws) - (pcx /= ws);
        this.ty = (qcy /= ws) - (pcy /= ws);
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException {
        assert (p.length >= 2 && q.length >= 2) : "2d translations can be applied to 2d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 1) {
            throw new NotEnoughDataPointsException(l + " data points are not enough to estimate a 2d translation model, at least " + 1 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (int i = 0; i < l; ++i) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i];
            ws += ww;
            pcx += ww * (double)pX[i];
            pcy += ww * (double)pY[i];
            qcx += ww * (double)qX[i];
            qcy += ww * (double)qY[i];
        }
        this.tx = (qcx /= ws) - (pcx /= ws);
        this.ty = (qcy /= ws) - (pcy /= ws);
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException {
        if (matches.size() < 1) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 2d translation model, at least " + 1 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * p[0];
            pcy += w * p[1];
            qcx += w * q[0];
            qcy += w * q[1];
        }
        this.tx = (qcx /= ws) - (pcx /= ws);
        this.ty = (qcy /= ws) - (pcy /= ws);
    }

    @Override
    public TranslationModel2D copy() {
        TranslationModel2D m = new TranslationModel2D();
        m.tx = this.tx;
        m.ty = this.ty;
        m.cost = this.cost;
        return m;
    }

    @Override
    public final void set(TranslationModel2D m) {
        this.tx = m.tx;
        this.ty = m.ty;
        this.cost = m.getCost();
    }

    @Override
    public final void preConcatenate(TranslationModel2D m) {
        this.tx += m.tx;
        this.ty += m.ty;
    }

    @Override
    public final void concatenate(TranslationModel2D m) {
        this.tx += m.tx;
        this.ty += m.ty;
    }

    public final void set(double tx, double ty) {
        this.tx = tx;
        this.ty = ty;
    }

    @Override
    public TranslationModel2D createInverse() {
        TranslationModel2D ict = new TranslationModel2D();
        ict.tx = -this.tx;
        ict.ty = -this.ty;
        ict.cost = this.cost;
        return ict;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = 1.0;
        data[1] = 0.0;
        data[2] = 0.0;
        data[3] = 1.0;
        data[4] = this.tx;
        data[5] = this.ty;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = 1.0;
        data[0][1] = 0.0;
        data[0][2] = this.tx;
        data[1][0] = 0.0;
        data[1][1] = 1.0;
        data[1][1] = this.ty;
    }
}

