/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tile<M extends Model<M>>
implements Serializable {
    private static final long serialVersionUID = 3715791741771321832L;
    protected final M model;
    protected final Set<PointMatch> matches = new HashSet<PointMatch>();
    protected final Set<Tile<?>> connectedTiles = new HashSet();
    protected double cost;
    private double distance;

    public final M getModel() {
        return this.model;
    }

    public final Set<PointMatch> getMatches() {
        return this.matches;
    }

    public final boolean addMatches(Collection<PointMatch> more) {
        return this.matches.addAll(more);
    }

    public final boolean addMatch(PointMatch match) {
        return this.matches.add(match);
    }

    public final boolean removeMatch(PointMatch match) {
        return this.matches.remove(match);
    }

    public final Set<Tile<?>> getConnectedTiles() {
        return this.connectedTiles;
    }

    public final boolean addConnectedTile(Tile<?> t) {
        return this.connectedTiles.add(t);
    }

    public final boolean removeConnectedTile(Tile<?> t) {
        if (this.connectedTiles.remove(t)) {
            ArrayList<PointMatch> toBeRemovedHere = new ArrayList<PointMatch>();
            ArrayList<PointMatch> toBeRemovedThere = new ArrayList<PointMatch>();
            block0: for (PointMatch p : this.matches) {
                for (PointMatch m : t.matches) {
                    if (p.getP2() != m.getP1()) continue;
                    toBeRemovedHere.add(p);
                    toBeRemovedThere.add(m);
                    continue block0;
                }
            }
            this.matches.removeAll(toBeRemovedHere);
            t.matches.removeAll(toBeRemovedThere);
            return true;
        }
        return false;
    }

    public Tile<?> findConnectedTile(PointMatch match) {
        Point p = match.getP2();
        for (Tile<?> t : this.connectedTiles) {
            for (PointMatch m : t.getMatches()) {
                if (p != m.getP1()) continue;
                return t;
            }
        }
        return null;
    }

    public final double getCost() {
        return this.cost;
    }

    public final double getDistance() {
        return this.distance;
    }

    public Tile(M model) {
        this.model = model;
    }

    public final void apply() {
        for (PointMatch match : this.matches) {
            match.apply((CoordinateTransform)this.model);
        }
    }

    public final void apply(double amount) {
        for (PointMatch match : this.matches) {
            match.apply((CoordinateTransform)this.model, amount);
        }
    }

    public final void updateCost() {
        double d = 0.0;
        double c = 0.0;
        int numMatches = this.matches.size();
        if (numMatches > 0) {
            double sumWeight = 0.0;
            for (PointMatch match : this.matches) {
                double dl = match.getDistance();
                d += dl;
                c += dl * dl * match.getWeight();
                sumWeight += match.getWeight();
            }
            d /= (double)numMatches;
            c /= sumWeight;
        }
        this.distance = d;
        this.cost = c;
        this.model.setCost(c);
    }

    public final void update() {
        double d = 0.0;
        double c = 0.0;
        int numMatches = this.matches.size();
        if (numMatches > 0) {
            double sumWeight = 0.0;
            for (PointMatch match : this.matches) {
                match.apply((CoordinateTransform)this.model);
                double dl = match.getDistance();
                d += dl;
                c += dl * dl * match.getWeight();
                sumWeight += match.getWeight();
            }
            d /= (double)numMatches;
            c /= sumWeight;
        }
        this.distance = d;
        this.cost = c;
        this.model.setCost(c);
    }

    public final void update(double amount) {
        double d = 0.0;
        double c = 0.0;
        int numMatches = this.matches.size();
        if (numMatches > 0) {
            double sumWeight = 0.0;
            for (PointMatch match : this.matches) {
                match.apply((CoordinateTransform)this.model, amount);
                double dl = match.getDistance();
                d += dl;
                c += dl * dl * match.getWeight();
                sumWeight += match.getWeight();
            }
            d /= (double)numMatches;
            c /= sumWeight;
        }
        this.distance = d;
        this.cost = c;
        this.model.setCost(c);
    }

    public final void fitModel() throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.model.fit(this.matches);
    }

    protected final void traceConnectedGraph(Set<Tile<?>> graph) {
        graph.add(this);
        for (Tile<?> t : this.connectedTiles) {
            if (graph.contains(t)) continue;
            t.traceConnectedGraph(graph);
        }
    }

    public final void connect(Tile<?> o, Collection<PointMatch> m) {
        this.addMatches(m);
        o.addMatches(PointMatch.flip(m));
        this.addConnectedTile(o);
        o.addConnectedTile(this);
    }

    public static final ArrayList<Set<Tile<?>>> identifyConnectedGraphs(Collection<? extends Tile<?>> tiles) {
        ArrayList graphs = new ArrayList();
        int numInspectedTiles = 0;
        block0: for (Tile<?> tile : tiles) {
            for (Set<Tile<?>> knownGraph : graphs) {
                if (!knownGraph.contains(tile)) continue;
                continue block0;
            }
            HashSet current_graph = new HashSet();
            tile.traceConnectedGraph(current_graph);
            graphs.add(current_graph);
            if ((numInspectedTiles += current_graph.size()) != tiles.size()) continue;
            break;
        }
        return graphs;
    }
}

