/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.Collection;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.util.Matrix3x3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarityModel3D
extends AbstractAffineModel3D<SimilarityModel3D>
implements InvertibleBoundable {
    private static final long serialVersionUID = 5509363764217496393L;
    protected static final int MIN_NUM_MATCHES = 3;
    protected double m00 = 1.0;
    protected double m01 = 0.0;
    protected double m02 = 0.0;
    protected double m03 = 0.0;
    protected double m10 = 0.0;
    protected double m11 = 1.0;
    protected double m12 = 0.0;
    protected double m13 = 0.0;
    protected double m20 = 0.0;
    protected double m21 = 0.0;
    protected double m22 = 1.0;
    protected double m23 = 0.0;
    protected double i00 = 1.0;
    protected double i01 = 0.0;
    protected double i02 = 0.0;
    protected double i03 = 0.0;
    protected double i10 = 0.0;
    protected double i11 = 1.0;
    protected double i12 = 0.0;
    protected double i13 = 0.0;
    protected double i20 = 0.0;
    protected double i21 = 0.0;
    protected double i22 = 1.0;
    protected double i23 = 0.0;
    protected final double[][] N = new double[4][4];
    protected boolean isInvertible;

    public boolean canDoNumDimension(int numDimensions) {
        return numDimensions == 3;
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        int numMatches = p[0].length;
        if (numMatches < 3) {
            throw new NotEnoughDataPointsException(p[0].length + " data points are not enough to estimate a 3d similarity model, at least " + 3 + " data points required.");
        }
        double qcz = 0.0;
        double qcy = 0.0;
        double qcx = 0.0;
        double pcz = 0.0;
        double pcy = 0.0;
        double pcx = 0.0;
        double ws = 0.0;
        for (int i = 0; i < numMatches; ++i) {
            double weight = w[i];
            ws += weight;
            pcx += weight * (double)p[0][i];
            pcy += weight * (double)p[1][i];
            pcz += weight * (double)p[2][i];
            qcx += weight * (double)q[0][i];
            qcy += weight * (double)q[1][i];
            qcz += weight * (double)q[2][i];
        }
        pcx /= ws;
        pcy /= ws;
        pcz /= ws;
        qcx /= ws;
        qcy /= ws;
        qcz /= ws;
        double r1 = 0.0;
        double r2 = 0.0;
        for (int i = 0; i < numMatches; ++i) {
            double x1 = (double)p[0][i] - pcx;
            double y1 = (double)p[1][i] - pcy;
            double z1 = (double)p[2][i] - pcz;
            double x2 = (double)q[0][i] - qcx;
            double y2 = (double)q[1][i] - qcy;
            double z2 = (double)q[2][i] - qcz;
            r1 += x1 * x1 + y1 * y1 + z1 * z1;
            r2 += x2 * x2 + y2 * y2 + z2 * z2;
        }
        double s = Math.sqrt(r2 / r1);
        double Szz = 0.0;
        double Szy = 0.0;
        double Szx = 0.0;
        double Syz = 0.0;
        double Syy = 0.0;
        double Syx = 0.0;
        double Sxz = 0.0;
        double Sxy = 0.0;
        double Sxx = 0.0;
        for (int i = 0; i < numMatches; ++i) {
            double x1 = ((double)p[0][i] - pcx) * s;
            double y1 = ((double)p[1][i] - pcy) * s;
            double z1 = ((double)p[2][i] - pcz) * s;
            double x2 = (double)q[0][i] - qcx;
            double y2 = (double)q[1][i] - qcy;
            double z2 = (double)q[2][i] - qcz;
            Sxx += x1 * x2;
            Sxy += x1 * y2;
            Sxz += x1 * z2;
            Syx += y1 * x2;
            Syy += y1 * y2;
            Syz += y1 * z2;
            Szx += z1 * x2;
            Szy += z1 * y2;
            Szz += z1 * z2;
        }
        SimilarityModel3D.computeN(this.N, Sxx, Sxz, Sxy, Syx, Syy, Syz, Szx, Szy, Szz);
        EigenvalueDecomposition evd = new EigenvalueDecomposition(new Matrix(this.N));
        double[] eigenvalues = evd.getRealEigenvalues();
        Matrix eigenVectors = evd.getV();
        int index = 0;
        for (int i = 1; i < 4; ++i) {
            if (!(eigenvalues[i] > eigenvalues[index])) continue;
            index = i;
        }
        double q0 = eigenVectors.get(0, index);
        double qx = eigenVectors.get(1, index);
        double qy = eigenVectors.get(2, index);
        double qz = eigenVectors.get(3, index);
        this.rotationTranslationPart(s, q0, qx, qy, qz, pcx, pcy, pcz, qcx, qcy, qcz);
        this.invert();
    }

    @Override
    public final void fit(double[][] p, double[][] q, double[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        int numMatches = p[0].length;
        if (numMatches < 3) {
            throw new NotEnoughDataPointsException(p[0].length + " data points are not enough to estimate a 3d similarity model, at least " + 3 + " data points required.");
        }
        double qcz = 0.0;
        double qcy = 0.0;
        double qcx = 0.0;
        double pcz = 0.0;
        double pcy = 0.0;
        double pcx = 0.0;
        double ws = 0.0;
        for (int i = 0; i < numMatches; ++i) {
            double weight = w[i];
            ws += weight;
            pcx += weight * p[0][i];
            pcy += weight * p[1][i];
            pcz += weight * p[2][i];
            qcx += weight * q[0][i];
            qcy += weight * q[1][i];
            qcz += weight * q[2][i];
        }
        pcx /= ws;
        pcy /= ws;
        pcz /= ws;
        qcx /= ws;
        qcy /= ws;
        qcz /= ws;
        double r1 = 0.0;
        double r2 = 0.0;
        for (int i = 0; i < numMatches; ++i) {
            double x1 = p[0][i] - pcx;
            double y1 = p[1][i] - pcy;
            double z1 = p[2][i] - pcz;
            double x2 = q[0][i] - qcx;
            double y2 = q[1][i] - qcy;
            double z2 = q[2][i] - qcz;
            r1 += x1 * x1 + y1 * y1 + z1 * z1;
            r2 += x2 * x2 + y2 * y2 + z2 * z2;
        }
        double s = Math.sqrt(r2 / r1);
        double Szz = 0.0;
        double Szy = 0.0;
        double Szx = 0.0;
        double Syz = 0.0;
        double Syy = 0.0;
        double Syx = 0.0;
        double Sxz = 0.0;
        double Sxy = 0.0;
        double Sxx = 0.0;
        for (int i = 0; i < numMatches; ++i) {
            double x1 = (p[0][i] - pcx) * s;
            double y1 = (p[1][i] - pcy) * s;
            double z1 = (p[2][i] - pcz) * s;
            double x2 = q[0][i] - qcx;
            double y2 = q[1][i] - qcy;
            double z2 = q[2][i] - qcz;
            Sxx += x1 * x2;
            Sxy += x1 * y2;
            Sxz += x1 * z2;
            Syx += y1 * x2;
            Syy += y1 * y2;
            Syz += y1 * z2;
            Szx += z1 * x2;
            Szy += z1 * y2;
            Szz += z1 * z2;
        }
        SimilarityModel3D.computeN(this.N, Sxx, Sxz, Sxy, Syx, Syy, Syz, Szx, Szy, Szz);
        EigenvalueDecomposition evd = new EigenvalueDecomposition(new Matrix(this.N));
        double[] eigenvalues = evd.getRealEigenvalues();
        Matrix eigenVectors = evd.getV();
        int index = 0;
        for (int i = 1; i < 4; ++i) {
            if (!(eigenvalues[i] > eigenvalues[index])) continue;
            index = i;
        }
        double q0 = eigenVectors.get(0, index);
        double qx = eigenVectors.get(1, index);
        double qy = eigenVectors.get(2, index);
        double qz = eigenVectors.get(3, index);
        this.rotationTranslationPart(s, q0, qx, qy, qz, pcx, pcy, pcz, qcx, qcy, qcz);
        this.invert();
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        int numMatches = matches.size();
        if (numMatches < 3) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 3d similarity model, at least " + 3 + " data points required.");
        }
        double qcz = 0.0;
        double qcy = 0.0;
        double qcx = 0.0;
        double pcz = 0.0;
        double pcy = 0.0;
        double pcx = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * p[0];
            pcy += w * p[1];
            pcz += w * p[2];
            qcx += w * q[0];
            qcy += w * q[1];
            qcz += w * q[2];
        }
        pcx /= ws;
        pcy /= ws;
        pcz /= ws;
        qcx /= ws;
        qcy /= ws;
        qcz /= ws;
        double r1 = 0.0;
        double r2 = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double x1 = p[0] - pcx;
            double y1 = p[1] - pcy;
            double z1 = p[2] - pcz;
            double x2 = q[0] - qcx;
            double y2 = q[1] - qcy;
            double z2 = q[2] - qcz;
            r1 += x1 * x1 + y1 * y1 + z1 * z1;
            r2 += x2 * x2 + y2 * y2 + z2 * z2;
        }
        double s = Math.sqrt(r2 / r1);
        double Szz = 0.0;
        double Szy = 0.0;
        double Szx = 0.0;
        double Syz = 0.0;
        double Syy = 0.0;
        double Syx = 0.0;
        double Sxz = 0.0;
        double Sxy = 0.0;
        double Sxx = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double x1 = (p[0] - pcx) * s;
            double y1 = (p[1] - pcy) * s;
            double z1 = (p[2] - pcz) * s;
            double x2 = q[0] - qcx;
            double y2 = q[1] - qcy;
            double z2 = q[2] - qcz;
            Sxx += x1 * x2;
            Sxy += x1 * y2;
            Sxz += x1 * z2;
            Syx += y1 * x2;
            Syy += y1 * y2;
            Syz += y1 * z2;
            Szx += z1 * x2;
            Szy += z1 * y2;
            Szz += z1 * z2;
        }
        SimilarityModel3D.computeN(this.N, Sxx, Sxz, Sxy, Syx, Syy, Syz, Szx, Szy, Szz);
        EigenvalueDecomposition evd = new EigenvalueDecomposition(new Matrix(this.N));
        double[] eigenvalues = evd.getRealEigenvalues();
        Matrix eigenVectors = evd.getV();
        int index = 0;
        for (int i = 1; i < 4; ++i) {
            if (!(eigenvalues[i] > eigenvalues[index])) continue;
            index = i;
        }
        double q0 = eigenVectors.get(0, index);
        double qx = eigenVectors.get(1, index);
        double qy = eigenVectors.get(2, index);
        double qz = eigenVectors.get(3, index);
        this.rotationTranslationPart(s, q0, qx, qy, qz, pcx, pcy, pcz, qcx, qcy, qcz);
        this.invert();
    }

    private void rotationTranslationPart(double s, double q0, double qx, double qy, double qz, double pcx, double pcy, double pcz, double qcx, double qcy, double qcz) {
        this.m00 = s * (q0 * q0 + qx * qx - qy * qy - qz * qz);
        this.m01 = s * 2.0 * (qx * qy - q0 * qz);
        this.m02 = s * 2.0 * (qx * qz + q0 * qy);
        this.m10 = s * 2.0 * (qy * qx + q0 * qz);
        this.m11 = s * (q0 * q0 - qx * qx + qy * qy - qz * qz);
        this.m12 = s * 2.0 * (qy * qz - q0 * qx);
        this.m20 = s * 2.0 * (qz * qx - q0 * qy);
        this.m21 = s * 2.0 * (qz * qy + q0 * qx);
        this.m22 = s * (q0 * q0 - qx * qx - qy * qy + qz * qz);
        double resx = 0.0;
        double resy = 0.0;
        double resz = 0.0;
        resx = pcx * this.m00 + pcy * this.m01 + pcz * this.m02;
        resy = pcx * this.m10 + pcy * this.m11 + pcz * this.m12;
        resz = pcx * this.m20 + pcy * this.m21 + pcz * this.m22;
        this.m03 = qcx - resx;
        this.m13 = qcy - resy;
        this.m23 = qcz - resz;
    }

    private static void computeN(double[][] N, double Sxx, double Sxz, double Sxy, double Syx, double Syy, double Syz, double Szx, double Szy, double Szz) {
        N[0][0] = Sxx + Syy + Szz;
        N[0][1] = Syz - Szy;
        N[0][2] = Szx - Sxz;
        N[0][3] = Sxy - Syx;
        N[1][0] = Syz - Szy;
        N[1][1] = Sxx - Syy - Szz;
        N[1][2] = Sxy + Syx;
        N[1][3] = Szx + Sxz;
        N[2][0] = Szx - Sxz;
        N[2][1] = Sxy + Syx;
        N[2][2] = -Sxx + Syy - Szz;
        N[2][3] = Syz + Szy;
        N[3][0] = Sxy - Syx;
        N[3][1] = Szx + Sxz;
        N[3][2] = Syz + Szy;
        N[3][3] = -Sxx - Syy + Szz;
    }

    @Override
    public final void set(SimilarityModel3D m) {
        this.m00 = m.m00;
        this.m10 = m.m10;
        this.m20 = m.m20;
        this.m01 = m.m01;
        this.m11 = m.m11;
        this.m21 = m.m21;
        this.m02 = m.m02;
        this.m12 = m.m12;
        this.m22 = m.m22;
        this.m03 = m.m03;
        this.m13 = m.m13;
        this.m23 = m.m23;
        this.cost = m.cost;
        this.invert();
    }

    @Override
    public SimilarityModel3D copy() {
        SimilarityModel3D m = new SimilarityModel3D();
        m.m00 = this.m00;
        m.m10 = this.m10;
        m.m20 = this.m20;
        m.m01 = this.m01;
        m.m11 = this.m11;
        m.m21 = this.m21;
        m.m02 = this.m02;
        m.m12 = this.m12;
        m.m22 = this.m22;
        this.m03 = m.m03;
        this.m13 = m.m13;
        this.m23 = m.m23;
        m.cost = this.cost;
        this.invert();
        return m;
    }

    @Override
    public final int getMinNumMatches() {
        return 3;
    }

    @Override
    public final double[] apply(double[] l) {
        double[] transformed = (double[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(double[] l) {
        assert (l.length == 3) : "3d affine transformations can be applied to 3d points only.";
        double l0 = l[0];
        double l1 = l[1];
        l[0] = l0 * this.m00 + l1 * this.m01 + l[2] * this.m02 + this.m03;
        l[1] = l0 * this.m10 + l1 * this.m11 + l[2] * this.m12 + this.m13;
        l[2] = l0 * this.m20 + l1 * this.m21 + l[2] * this.m22 + this.m23;
    }

    public final String toString() {
        return "3d-affine: (" + this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + ", " + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + ", " + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + ")";
    }

    protected void invert() {
        double det = Matrix3x3.det(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
        if (det == 0.0) {
            this.isInvertible = false;
            return;
        }
        this.isInvertible = true;
        double idet = 1.0 / det;
        this.i00 = (this.m11 * this.m22 - this.m12 * this.m21) * idet;
        this.i01 = (this.m02 * this.m21 - this.m01 * this.m22) * idet;
        this.i02 = (this.m01 * this.m12 - this.m02 * this.m11) * idet;
        this.i10 = (this.m12 * this.m20 - this.m10 * this.m22) * idet;
        this.i11 = (this.m00 * this.m22 - this.m02 * this.m20) * idet;
        this.i12 = (this.m02 * this.m10 - this.m00 * this.m12) * idet;
        this.i20 = (this.m10 * this.m21 - this.m11 * this.m20) * idet;
        this.i21 = (this.m01 * this.m20 - this.m00 * this.m21) * idet;
        this.i22 = (this.m00 * this.m11 - this.m01 * this.m10) * idet;
        this.i03 = -this.i00 * this.m03 - this.i01 * this.m13 - this.i02 * this.m23;
        this.i13 = -this.i10 * this.m03 - this.i11 * this.m13 - this.i12 * this.m23;
        this.i23 = -this.i20 * this.m03 - this.i21 * this.m13 - this.i22 * this.m23;
    }

    @Override
    public double[] applyInverse(double[] l) throws NoninvertibleModelException {
        double[] transformed = (double[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public void applyInverseInPlace(double[] l) throws NoninvertibleModelException {
        if (!this.isInvertible) {
            throw new NoninvertibleModelException("Model not invertible.");
        }
        double l0 = l[0];
        double l1 = l[1];
        l[0] = l0 * this.i00 + l1 * this.i01 + l[2] * this.i02 + this.i03;
        l[1] = l0 * this.i10 + l1 * this.i11 + l[2] * this.i12 + this.i13;
        l[2] = l0 * this.i20 + l1 * this.i21 + l[2] * this.i22 + this.i23;
    }

    @Override
    public void preConcatenate(SimilarityModel3D model) {
        double a00 = model.m00 * this.m00 + model.m01 * this.m10 + model.m02 * this.m20;
        double a01 = model.m00 * this.m01 + model.m01 * this.m11 + model.m02 * this.m21;
        double a02 = model.m00 * this.m02 + model.m01 * this.m12 + model.m02 * this.m22;
        double a03 = model.m00 * this.m03 + model.m01 * this.m13 + model.m02 * this.m23 + model.m03;
        double a10 = model.m10 * this.m00 + model.m11 * this.m10 + model.m12 * this.m20;
        double a11 = model.m10 * this.m01 + model.m11 * this.m11 + model.m12 * this.m21;
        double a12 = model.m10 * this.m02 + model.m11 * this.m12 + model.m12 * this.m22;
        double a13 = model.m10 * this.m03 + model.m11 * this.m13 + model.m12 * this.m23 + model.m13;
        double a20 = model.m20 * this.m00 + model.m21 * this.m10 + model.m22 * this.m20;
        double a21 = model.m20 * this.m01 + model.m21 * this.m11 + model.m22 * this.m21;
        double a22 = model.m20 * this.m02 + model.m21 * this.m12 + model.m22 * this.m22;
        double a23 = model.m20 * this.m03 + model.m21 * this.m13 + model.m22 * this.m23 + model.m23;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m03 = a03;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m13 = a13;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
        this.m23 = a23;
        this.invert();
    }

    @Override
    public void concatenate(SimilarityModel3D model) {
        double a00 = this.m00 * model.m00 + this.m01 * model.m10 + this.m02 * model.m20;
        double a01 = this.m00 * model.m01 + this.m01 * model.m11 + this.m02 * model.m21;
        double a02 = this.m00 * model.m02 + this.m01 * model.m12 + this.m02 * model.m22;
        double a03 = this.m00 * model.m03 + this.m01 * model.m13 + this.m02 * model.m23 + this.m03;
        double a10 = this.m10 * model.m00 + this.m11 * model.m10 + this.m12 * model.m20;
        double a11 = this.m10 * model.m01 + this.m11 * model.m11 + this.m12 * model.m21;
        double a12 = this.m10 * model.m02 + this.m11 * model.m12 + this.m12 * model.m22;
        double a13 = this.m10 * model.m03 + this.m11 * model.m13 + this.m12 * model.m23 + this.m13;
        double a20 = this.m20 * model.m00 + this.m21 * model.m10 + this.m22 * model.m20;
        double a21 = this.m20 * model.m01 + this.m21 * model.m11 + this.m22 * model.m21;
        double a22 = this.m20 * model.m02 + this.m21 * model.m12 + this.m22 * model.m22;
        double a23 = this.m20 * model.m03 + this.m21 * model.m13 + this.m22 * model.m23 + this.m23;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m03 = a03;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m13 = a13;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
        this.m23 = a23;
        this.invert();
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.m00;
        data[1] = this.m10;
        data[2] = this.m20;
        data[3] = this.m01;
        data[4] = this.m11;
        data[5] = this.m21;
        data[6] = this.m02;
        data[7] = this.m12;
        data[8] = this.m22;
        data[9] = this.m03;
        data[10] = this.m13;
        data[11] = this.m23;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
        data[0][2] = this.m02;
        data[0][3] = this.m03;
        data[1][0] = this.m10;
        data[1][1] = this.m11;
        data[1][2] = this.m12;
        data[1][3] = this.m13;
        data[2][0] = this.m20;
        data[2][1] = this.m21;
        data[2][2] = this.m22;
        data[2][3] = this.m23;
    }

    @Override
    public SimilarityModel3D createInverse() {
        SimilarityModel3D ict = new SimilarityModel3D();
        ict.m00 = this.i00;
        ict.m10 = this.i10;
        ict.m20 = this.i20;
        ict.m01 = this.i01;
        ict.m11 = this.i11;
        ict.m21 = this.i21;
        ict.m02 = this.i02;
        ict.m12 = this.i12;
        ict.m22 = this.i22;
        ict.m03 = this.i03;
        ict.m13 = this.i13;
        ict.m23 = this.i23;
        ict.i00 = this.m00;
        ict.i10 = this.m10;
        ict.i20 = this.m20;
        ict.i01 = this.m01;
        ict.i11 = this.m11;
        ict.i21 = this.m21;
        ict.i02 = this.m02;
        ict.i12 = this.m12;
        ict.i22 = this.m22;
        ict.i03 = this.m03;
        ict.i13 = this.m13;
        ict.i23 = this.m23;
        ict.cost = this.cost;
        ict.isInvertible = this.isInvertible;
        return ict;
    }

    @Override
    public double[] getMatrix(double[] m) {
        double[] a = m == null || m.length != 12 ? new double[12] : m;
        a[0] = this.m00;
        a[1] = this.m01;
        a[2] = this.m02;
        a[3] = this.m03;
        a[4] = this.m10;
        a[5] = this.m11;
        a[6] = this.m12;
        a[7] = this.m13;
        a[8] = this.m20;
        a[9] = this.m21;
        a[10] = this.m22;
        a[11] = this.m23;
        return a;
    }
}

