/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import mpicbg.models.InterpolatedModel;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.Model;
import mpicbg.models.NoninvertibleModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvertibleInterpolatedModel<A extends Model<A> & InvertibleCoordinateTransform, B extends Model<B> & InvertibleCoordinateTransform, M extends InvertibleInterpolatedModel<A, B, M>>
extends InterpolatedModel<A, B, M>
implements InvertibleCoordinateTransform {
    private static final long serialVersionUID = -1800786784345843623L;

    public InvertibleInterpolatedModel(A a, B b, double lambda) {
        super(a, b, lambda);
    }

    @Override
    public M copy() {
        InvertibleInterpolatedModel copy = new InvertibleInterpolatedModel(this.a.copy(), this.b.copy(), this.lambda);
        copy.cost = this.cost;
        return (M)copy;
    }

    @Override
    public double[] applyInverse(double[] point) throws NoninvertibleModelException {
        double[] copy = (double[])point.clone();
        this.applyInverseInPlace(copy);
        return copy;
    }

    @Override
    public void applyInverseInPlace(double[] point) throws NoninvertibleModelException {
        double[] copy = ((InverseCoordinateTransform)((Object)this.b)).applyInverse(point);
        ((InverseCoordinateTransform)((Object)this.a)).applyInverseInPlace(point);
        int d = 0;
        while (d < point.length) {
            double dd = copy[d] - point[d];
            int n = d++;
            point[n] = point[n] + this.lambda * dd;
        }
    }

    @Override
    public InvertibleCoordinateTransform createInverse() {
        InvertibleInterpolatedModel<Model, Model, M> inverse = new InvertibleInterpolatedModel<Model, Model, M>((Model)((Object)((InvertibleCoordinateTransform)((Object)this.a)).createInverse()), (Model)((Object)((InvertibleCoordinateTransform)((Object)this.b)).createInverse()), this.lambda);
        inverse.cost = this.cost;
        return inverse;
    }
}

