/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.clahe;

import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import mpicbg.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Apply<T extends ImageProcessor> {
    protected final T ip;
    protected final int width;
    protected final int height;
    protected final byte[] srcPixels;
    protected final byte[] dstPixels;
    protected final byte[] maskPixels;
    protected final int boxXMin;
    protected final int boxYMin;
    protected final int boxXMax;
    protected final int boxYMax;

    Apply(T ip, ByteProcessor src, ByteProcessor dst, ByteProcessor mask, int boxXMin, int boxYMin, int boxXMax, int boxYMax) throws Exception {
        this.ip = ip;
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.boxXMin = boxXMin;
        this.boxYMin = boxYMin;
        this.boxXMax = boxXMax;
        this.boxYMax = boxYMax;
        if (src.getWidth() != this.width || src.getHeight() != this.height || dst.getWidth() != this.width || dst.getHeight() != this.height) {
            throw new Exception("Image sizes do not match.");
        }
        this.srcPixels = (byte[])src.getPixels();
        this.dstPixels = (byte[])dst.getPixels();
        if (mask == null) {
            this.maskPixels = new byte[this.srcPixels.length];
            Util.memset(this.maskPixels, (byte)-1);
        } else if (boxXMin == 0 && boxYMin == 0 && boxXMax == mask.getWidth() && boxYMax == mask.getHeight()) {
            this.maskPixels = (byte[])mask.getPixels();
        } else {
            ByteProcessor extendedMask = new ByteProcessor(this.width, this.height);
            extendedMask.copyBits((ImageProcessor)mask, boxXMin, boxYMin, 0);
            this.maskPixels = (byte[])extendedMask.getPixels();
        }
    }

    public abstract void apply(int var1, int var2, int var3, int var4);
}

