/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.io.Serializable;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.matrix.PrimitiveMatrix;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.OptimisationUtils;

public abstract class BaseSolver
extends GenericSolver {
    private final AbstractBuilder<?, ?> myMatrices;

    private BaseSolver(Optimisation.Options solverOptions) {
        this(null, solverOptions);
    }

    protected BaseSolver(AbstractBuilder<?, ?> matrices, Optimisation.Options solverOptions) {
        super(solverOptions);
        this.myMatrices = matrices;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myMatrices.reset();
    }

    public String toString() {
        return this.myMatrices.toString();
    }

    protected int countEqualityConstraints() {
        return this.myMatrices.countEqualityConstraints();
    }

    protected int countInequalityConstraints() {
        return this.myMatrices.countInequalityConstraints();
    }

    protected int countVariables() {
        return this.myMatrices.countVariables();
    }

    protected void fillX(Access1D<?> solution) {
        int tmpLimit = this.countVariables();
        for (int i = 0; i < tmpLimit; ++i) {
            this.myMatrices.setX(i, solution.doubleValue(i));
        }
    }

    protected void fillX(double value) {
        int tmpLimit = this.countVariables();
        for (int i = 0; i < tmpLimit; ++i) {
            this.myMatrices.setX(i, value);
        }
    }

    protected MatrixStore<Double> getAE() {
        return this.myMatrices.getAE();
    }

    protected MatrixStore<Double> getAEX() {
        return this.myMatrices.getAEX();
    }

    protected MatrixStore<Double> getAI() {
        return this.myMatrices.getAI();
    }

    protected MatrixStore<Double> getAIX(int[] selector) {
        return this.myMatrices.getAIX(selector);
    }

    protected MatrixStore<Double> getBE() {
        return this.myMatrices.getBE();
    }

    protected MatrixStore<Double> getBI() {
        return this.myMatrices.getBI();
    }

    protected MatrixStore<Double> getBI(int[] selector) {
        return this.myMatrices.getBI(selector);
    }

    protected MatrixStore<Double> getC() {
        return this.myMatrices.getC();
    }

    protected MatrixStore<Double> getQ() {
        return this.myMatrices.getQ();
    }

    protected PhysicalStore<Double> getSE() {
        return this.myMatrices.getSE();
    }

    protected MatrixStore<Double> getSI(int ... rowSelector) {
        return this.myMatrices.getSI(rowSelector);
    }

    protected PhysicalStore<Double> getX() {
        return this.myMatrices.getX();
    }

    protected boolean hasEqualityConstraints() {
        return this.myMatrices.hasEqualityConstraints();
    }

    protected boolean hasInequalityConstraints() {
        return this.myMatrices.hasInequalityConstraints();
    }

    protected boolean hasObjective() {
        return this.myMatrices.hasObjective();
    }

    protected boolean isX() {
        return this.myMatrices.isX();
    }

    protected void resetX() {
        this.myMatrices.resetX();
    }

    protected void setX(int index, double value) {
        this.myMatrices.setX(index, value);
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<?, ?>, S extends BaseSolver>
    implements Cloneable {
        static final PhysicalStore.Factory<Double, PrimitiveDenseStore> FACTORY = PrimitiveDenseStore.FACTORY;
        private MatrixStore<Double> myAE = null;
        private MatrixStore.LogicalBuilder<Double> myAEbuilder = null;
        private MatrixStore<Double> myAI = null;
        private MatrixStore.LogicalBuilder<Double> myAIbuilder = null;
        private MatrixStore<Double> myBE = null;
        private MatrixStore.LogicalBuilder<Double> myBEbuilder = null;
        private MatrixStore<Double> myBI = null;
        private MatrixStore.LogicalBuilder<Double> myBIbuilder = null;
        private MatrixStore<Double> myC = null;
        private MatrixStore.LogicalBuilder<Double> myCbuilder = null;
        private MatrixStore<Double> myQ = null;
        private MatrixStore.LogicalBuilder<Double> myQbuilder = null;
        private PrimitiveDenseStore myX = null;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(AbstractBuilder<?, ?> matrices) {
            if (matrices.hasEqualityConstraints()) {
                this.equalities(matrices.getAE(), matrices.getBE());
            }
            if (matrices.hasObjective()) {
                if (matrices.getQ() != null) {
                    this.objective(matrices.getQ(), matrices.getC());
                } else {
                    this.objective(matrices.getC());
                }
            }
            if (matrices.hasInequalityConstraints()) {
                this.inequalities(matrices.getAI(), matrices.getBI());
            }
        }

        protected AbstractBuilder(MatrixStore<Double> C) {
            this.objective(C);
        }

        protected AbstractBuilder(MatrixStore<Double> Q, MatrixStore<Double> C) {
            this.objective(Q, C);
        }

        protected AbstractBuilder(MatrixStore<Double>[] matrices) {
            if (matrices.length >= 2 && matrices[0] != null && matrices[1] != null) {
                this.equalities(matrices[0], matrices[1]);
            }
            if (matrices.length >= 4) {
                if (matrices[2] != null) {
                    this.objective(matrices[2], matrices[3]);
                } else if (matrices[3] != null) {
                    this.objective(matrices[3]);
                }
            }
            if (matrices.length >= 6 && matrices[4] != null && matrices[5] != null) {
                this.inequalities(matrices[4], matrices[5]);
            }
        }

        public B balance() {
            if (this.hasEqualityConstraints()) {
                this.balanceEqualityConstraints();
            }
            if (this.hasInequalityConstraints()) {
                this.balanceInequalityConstraints();
            }
            if (this.hasObjective()) {
                this.balanceObjective();
            }
            return (B)this;
        }

        public final S build() {
            return this.build(null);
        }

        public abstract S build(Optimisation.Options var1);

        public AbstractBuilder<B, S> copy() {
            try {
                return (AbstractBuilder)this.clone();
            }
            catch (CloneNotSupportedException anException) {
                return null;
            }
        }

        public int countEqualityConstraints() {
            return (int)(this.getAE() != null ? this.getAE().countRows() : 0L);
        }

        public int countInequalityConstraints() {
            return (int)(this.getAI() != null ? this.getAI().countRows() : 0L);
        }

        public int countVariables() {
            int retVal = -1;
            if (this.getAE() != null) {
                retVal = (int)this.getAE().countColumns();
            } else if (this.getAI() != null) {
                retVal = (int)this.getAI().countColumns();
            } else if (this.getQ() != null) {
                retVal = (int)this.getQ().countRows();
            } else if (this.getC() != null) {
                retVal = (int)this.getC().countRows();
            } else {
                throw new ProgrammingError("Cannot deduce the number of variables!");
            }
            return retVal;
        }

        public MatrixStore<Double> getAE() {
            if (this.myAEbuilder != null) {
                if (this.myAE == null) {
                    this.myAE = this.myAEbuilder.get().copy();
                }
                return this.myAE;
            }
            return null;
        }

        public MatrixStore<Double> getAEX() {
            MatrixStore<Double> tmpAE = this.getAE();
            PhysicalStore<Double> tmpX = this.getX();
            if (tmpAE != null && tmpX != null) {
                return tmpAE.multiply((Double)((Object)tmpX));
            }
            return null;
        }

        public MatrixStore<Double> getAI() {
            if (this.myAIbuilder != null) {
                if (this.myAI == null) {
                    this.myAI = this.myAIbuilder.get().copy();
                }
                return this.myAI;
            }
            return null;
        }

        public MatrixStore<Double> getAIX() {
            MatrixStore<Double> tmpAI = this.getAI();
            PhysicalStore<Double> tmpX = this.getX();
            if (tmpAI != null && tmpX != null) {
                return tmpAI.multiply((Double)((Object)tmpX));
            }
            return null;
        }

        public MatrixStore<Double> getAIX(int[] selector) {
            MatrixStore<Double> tmpAI = this.getAI();
            PhysicalStore<Double> tmpX = this.getX();
            if (tmpAI != null && tmpX != null) {
                return tmpAI.logical().row(selector).get().multiply(tmpX);
            }
            return null;
        }

        public MatrixStore<Double> getBE() {
            if (this.myBEbuilder != null) {
                if (this.myBE == null) {
                    this.myBE = this.myBEbuilder.get().copy();
                }
                return this.myBE;
            }
            return null;
        }

        public MatrixStore<Double> getBI() {
            if (this.myBIbuilder != null) {
                if (this.myBI == null) {
                    this.myBI = this.myBIbuilder.get().copy();
                }
                return this.myBI;
            }
            return null;
        }

        public MatrixStore<Double> getBI(int[] selector) {
            return this.getBI().logical().row(selector).get();
        }

        public MatrixStore<Double> getC() {
            if (this.myCbuilder != null) {
                if (this.myC == null) {
                    this.myC = this.myCbuilder.get().copy();
                }
                return this.myC;
            }
            return null;
        }

        public MatrixStore<Double> getQ() {
            if (this.myQbuilder != null) {
                if (this.myQ == null) {
                    this.myQ = this.myQbuilder.get().copy();
                }
                return this.myQ;
            }
            return null;
        }

        public PhysicalStore<Double> getSE() {
            PhysicalStore<Double> retVal = null;
            if (this.getAE() != null && this.getBE() != null && this.getX() != null) {
                retVal = this.getBE().copy();
                retVal.modifyMatching(PrimitiveFunction.SUBTRACT, this.getAEX());
            }
            return retVal;
        }

        public PhysicalStore<Double> getSI() {
            PhysicalStore<Double> retVal = null;
            if (this.getAI() != null && this.getBI() != null && this.getX() != null) {
                retVal = this.getBI().copy();
                retVal.modifyMatching(PrimitiveFunction.SUBTRACT, this.getAIX());
            }
            return retVal;
        }

        public MatrixStore<Double> getSI(int ... selector) {
            PhysicalStore<Double> tmpSI = this.getSI();
            if (tmpSI != null) {
                return tmpSI.logical().row(selector).get();
            }
            return null;
        }

        public PhysicalStore<Double> getX() {
            if (this.myX == null) {
                this.myX = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(this.countVariables(), 1L);
            }
            return this.myX;
        }

        public boolean hasEqualityConstraints() {
            return this.getAE() != null && this.getAE().countRows() > 0L;
        }

        public boolean hasInequalityConstraints() {
            return this.getAI() != null && this.getAI().countRows() > 0L;
        }

        public boolean hasObjective() {
            return this.getQ() != null || this.getC() != null;
        }

        public boolean isX() {
            return this.myX != null;
        }

        public void resetX() {
            if (this.myX != null) {
                this.myX.fillAll(PrimitiveMath.ZERO);
            }
        }

        public void setX(int index, double value) {
            this.getX().set((long)index, 0L, value);
        }

        public String toString() {
            StringBuilder retVal = new StringBuilder("<" + this.getClass().getSimpleName() + ">");
            retVal.append("\n[AE] = " + (this.getAE() != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getAE()) : "?"));
            retVal.append("\n[BE] = " + (this.getBE() != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getBE()) : "?"));
            retVal.append("\n[Q] = " + (this.getQ() != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getQ()) : "?"));
            retVal.append("\n[C] = " + (this.getC() != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getC()) : "?"));
            retVal.append("\n[AI] = " + (this.getAI() != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getAI()) : "?"));
            retVal.append("\n[BI] = " + (this.getBI() != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getBI()) : "?"));
            retVal.append("\n[X] = " + (this.getX() != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getX()) : "?"));
            retVal.append("\n[SE] = " + (this.getSE() != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getSE()) : "?"));
            retVal.append("\n[SI] = " + (this.getSI() != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getSI()) : "?"));
            retVal.append("\n</" + this.getClass().getSimpleName() + ">");
            return retVal.toString();
        }

        private void balanceEqualityConstraints() {
            PhysicalStore<Double> tmpBody = this.cast(this.getAE());
            PhysicalStore<Double> tmpRHS = this.cast(this.getBE());
            this.balanceRows(tmpBody, tmpRHS, true);
            this.myAE = tmpBody;
            this.myBE = tmpRHS;
            this.validate();
        }

        private void balanceInequalityConstraints() {
            PhysicalStore<Double> tmpBody = this.cast(this.getAI());
            PhysicalStore<Double> tmpRHS = this.cast(this.getBI());
            this.balanceRows(tmpBody, tmpRHS, false);
            this.myAI = tmpBody;
            this.myBI = tmpRHS;
            this.validate();
        }

        private double balanceMatrices(PhysicalStore<Double>[] someMatrices) {
            AggregatorFunction<Double> tmpLargestAggr = PrimitiveAggregator.getSet().largest();
            AggregatorFunction<Double> tmpSmallestAggr = PrimitiveAggregator.getSet().smallest();
            tmpLargestAggr.invoke(PrimitiveMath.ONE);
            tmpSmallestAggr.invoke(PrimitiveMath.ONE);
            for (PhysicalStore<Double> tmpMatrix : someMatrices) {
                if (tmpMatrix == null) continue;
                tmpMatrix.visitAll(tmpLargestAggr);
                tmpMatrix.visitAll(tmpSmallestAggr);
            }
            double tmpExponent = OptimisationUtils.getAdjustmentExponent(tmpLargestAggr.doubleValue(), tmpSmallestAggr.doubleValue());
            double tmpFactor = PrimitiveFunction.POW.invoke(PrimitiveMath.TEN, tmpExponent);
            UnaryFunction<double> tmpModifier = PrimitiveFunction.MULTIPLY.second(tmpFactor);
            for (PhysicalStore<Double> tmpMatrix : someMatrices) {
                if (tmpMatrix == null) continue;
                tmpMatrix.modifyAll(tmpModifier);
            }
            return tmpFactor;
        }

        private void balanceObjective() {
            PhysicalStore[] tmpMatrices = new PhysicalStore[2];
            if (this.getQ() != null) {
                tmpMatrices[0] = this.cast(this.getQ());
            }
            if (this.getC() != null) {
                tmpMatrices[1] = this.cast(this.getC());
            }
            this.balanceMatrices(tmpMatrices);
            this.myQ = tmpMatrices[0];
            this.myC = tmpMatrices[1];
            this.validate();
        }

        private void balanceRows(PhysicalStore<Double> tmpBody, PhysicalStore<Double> tmpRHS, boolean assertPositiveRHS) {
            AggregatorFunction<Double> tmpLargestAggr = PrimitiveAggregator.getSet().largest();
            AggregatorFunction<Double> tmpSmallestAggr = PrimitiveAggregator.getSet().smallest();
            int i = 0;
            while ((long)i < tmpBody.countRows()) {
                tmpLargestAggr.reset();
                tmpSmallestAggr.reset();
                tmpLargestAggr.invoke(PrimitiveMath.ONE);
                tmpSmallestAggr.invoke(PrimitiveMath.ONE);
                tmpBody.visitRow(i, 0L, tmpLargestAggr);
                tmpBody.visitRow(i, 0L, tmpSmallestAggr);
                tmpRHS.visitRow(i, 0L, tmpLargestAggr);
                tmpRHS.visitRow(i, 0L, tmpSmallestAggr);
                double tmpExponent = OptimisationUtils.getAdjustmentExponent(tmpLargestAggr.doubleValue(), tmpSmallestAggr.doubleValue());
                double tmpFactor = PrimitiveFunction.POW.invoke(PrimitiveMath.TEN, tmpExponent);
                if (assertPositiveRHS && PrimitiveFunction.SIGNUM.invoke(tmpRHS.doubleValue(i, 0L)) < PrimitiveMath.ZERO) {
                    tmpFactor = -tmpFactor;
                }
                UnaryFunction<double> tmpModifier = PrimitiveFunction.MULTIPLY.second(tmpFactor);
                tmpBody.modifyRow(i, 0L, tmpModifier);
                tmpRHS.modifyRow(i, 0L, tmpModifier);
                ++i;
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            AbstractBuilder retVal = (AbstractBuilder)super.clone();
            if (this.myX != null) {
                retVal.getX().fillMatching(this.myX);
            }
            return retVal;
        }

        protected B equalities(MatrixStore<Double> AE, MatrixStore<Double> BE) {
            if (AE == null || BE == null || AE.countRows() != BE.countRows()) {
                throw new IllegalArgumentException();
            }
            if (this.myAEbuilder != null) {
                this.myAEbuilder.below(AE);
                this.reset();
            } else {
                this.myAE = AE;
                this.myAEbuilder = this.myAE.logical();
            }
            if (this.myBEbuilder != null) {
                this.myBEbuilder.below(BE);
                this.reset();
            } else {
                this.myBE = BE;
                this.myBEbuilder = BE.logical();
            }
            return (B)this;
        }

        protected B inequalities(MatrixStore<Double> AI, MatrixStore<Double> BI) {
            if (AI == null || BI == null || AI.countRows() != BI.countRows()) {
                throw new IllegalArgumentException();
            }
            if (this.myAIbuilder != null) {
                this.myAIbuilder.below(AI);
                this.reset();
            } else {
                this.myAI = AI;
                this.myAIbuilder = this.myAI.logical();
            }
            if (this.myBIbuilder != null) {
                this.myBIbuilder.below(BI);
                this.reset();
            } else {
                this.myBI = BI;
                this.myBIbuilder = BI.logical();
            }
            return (B)this;
        }

        protected B objective(MatrixStore<Double> C) {
            if (C == null) {
                throw new IllegalArgumentException();
            }
            if (this.myCbuilder != null) {
                this.myCbuilder.below(C);
                this.reset();
            } else {
                this.myC = C;
                this.myCbuilder = this.myC.logical();
            }
            return (B)this;
        }

        protected B objective(MatrixStore<Double> Q, MatrixStore<Double> C) {
            MatrixStore<Double> tmpC;
            if (Q == null) {
                throw new IllegalArgumentException();
            }
            if (this.myQbuilder != null) {
                this.myQbuilder.below(Q);
                this.reset();
            } else {
                this.myQ = Q;
                this.myQbuilder = this.myQ.logical();
            }
            MatrixStore<Double> matrixStore = tmpC = C != null ? C : MatrixStore.PRIMITIVE.makeZero((int)Q.countRows(), 1).get();
            if (this.myCbuilder != null) {
                this.myCbuilder.below(tmpC);
                this.reset();
            } else {
                this.myC = tmpC;
                this.myCbuilder = this.myC.logical();
            }
            return (B)this;
        }

        protected void validate() {
            if (this.hasEqualityConstraints()) {
                if (this.getAE() == null) {
                    throw new ProgrammingError("AE cannot be null!");
                }
                if (this.getAE().countColumns() != (long)this.countVariables()) {
                    throw new ProgrammingError("AE has the wrong number of columns!");
                }
                if (this.getAE().countRows() != this.getBE().countRows()) {
                    throw new ProgrammingError("AE and BE do not have the same number of rows!");
                }
                if (this.getBE().countColumns() != 1L) {
                    throw new ProgrammingError("BE must have precisely one column!");
                }
            } else {
                this.myAE = null;
                this.myBE = null;
            }
            if (this.hasObjective()) {
                if (this.getQ() != null && (this.getQ().countRows() != (long)this.countVariables() || this.getQ().countColumns() != (long)this.countVariables())) {
                    throw new ProgrammingError("Q has the wrong number of rows and/or columns!");
                }
                if (this.getC() != null && this.getC().countRows() != (long)this.countVariables() || this.getC().countColumns() != 1L) {
                    throw new ProgrammingError("C has the wrong number of rows and/or columns!");
                }
            } else {
                this.myQ = null;
                this.myC = null;
            }
            if (this.hasInequalityConstraints()) {
                if (this.getAI() == null) {
                    throw new ProgrammingError("AI cannot be null!");
                }
                if (this.getAI().countColumns() != (long)this.countVariables()) {
                    throw new ProgrammingError("AI has the wrong number of columns!");
                }
                if (this.getAI().countRows() != this.getBI().countRows()) {
                    throw new ProgrammingError("AI and BI do not have the same number of rows!");
                }
                if (this.getBI().countColumns() != 1L) {
                    throw new ProgrammingError("BI must have precisely one column!");
                }
            } else {
                this.myAI = null;
                this.myBI = null;
            }
        }

        PhysicalStore<Double> cast(Access2D<Double> matrix) {
            if (matrix instanceof PhysicalStore) {
                return (PhysicalStore)matrix;
            }
            return (PhysicalStore)FACTORY.copy(matrix);
        }

        void reset() {
            this.myAE = null;
            this.myAI = null;
            this.myBE = null;
            this.myBI = null;
            this.myC = null;
            this.myQ = null;
            this.myX = null;
        }
    }
}

