/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.tools;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.renjin.eval.Context;
import org.renjin.invoke.annotations.Current;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.util.NamesBuilder;

public class Tools {
    public static StringVector Rmd5(@Current Context context, StringVector paths) throws IOException, NoSuchAlgorithmException {
        StringVector.Builder result = new StringVector.Builder();
        NamesBuilder names2 = NamesBuilder.withInitialCapacity(paths.length());
        for (String path2 : paths) {
            result.add(Tools.hashFile(context, path2));
        }
        result.setAttribute(Symbols.NAMES, (SEXP)names2.build());
        return result.build();
    }

    protected static String hashFile(Context context, String path2) throws FileSystemException, NoSuchAlgorithmException, IOException {
        try {
            int numRead;
            FileObject file2 = context.resolveFile(path2);
            InputStream in = file2.getContent().getInputStream();
            byte[] buffer = new byte[1024];
            MessageDigest complete2 = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = in.read(buffer)) <= 0) continue;
                complete2.update(buffer, 0, numRead);
            } while (numRead != -1);
            in.close();
            StringBuilder string = new StringBuilder();
            byte[] b = complete2.digest();
            for (int i = 0; i < b.length; ++i) {
                string.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
            }
            return string.toString();
        }
        catch (FileSystemException e) {
            return StringVector.NA;
        }
    }
}

