/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import java.util.Date;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.eval.Session;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;
import org.renjin.stats.internals.distributions.Beta;
import org.renjin.stats.internals.distributions.Binom;
import org.renjin.stats.internals.distributions.Cauchy;
import org.renjin.stats.internals.distributions.ChiSquare;
import org.renjin.stats.internals.distributions.Exponantial;
import org.renjin.stats.internals.distributions.F;
import org.renjin.stats.internals.distributions.Gamma;
import org.renjin.stats.internals.distributions.Geometric;
import org.renjin.stats.internals.distributions.HyperGeometric;
import org.renjin.stats.internals.distributions.LNorm;
import org.renjin.stats.internals.distributions.MersenneTwister;
import org.renjin.stats.internals.distributions.Multinomial;
import org.renjin.stats.internals.distributions.N01type;
import org.renjin.stats.internals.distributions.NegativeBinom;
import org.renjin.stats.internals.distributions.Normal;
import org.renjin.stats.internals.distributions.Poisson;
import org.renjin.stats.internals.distributions.RLogis;
import org.renjin.stats.internals.distributions.RNGtype;
import org.renjin.stats.internals.distributions.SignRank;
import org.renjin.stats.internals.distributions.StudentsT;
import org.renjin.stats.internals.distributions.Weibull;
import org.renjin.stats.internals.distributions.Wilcox;

public class RNG {
    public MersenneTwister mersenneTwisterAlg = null;
    public RNGtype RNG_kind = RNGtype.MERSENNE_TWISTER;
    public N01type N01_kind = N01type.INVERSION;
    int randomseed = 0;
    public Session context;

    public RNG(Session globals) {
        this.context = globals;
    }

    @Internal
    public static IntVector RNGkind(@Current Context context, SEXP kindExp, SEXP normalkindExp) {
        RNG rng = context.getSession().rng;
        if (kindExp != Null.INSTANCE) {
            int kind = ((AtomicVector)kindExp).getElementAsInt(0);
            try {
                rng.RNG_kind = RNGtype.values()[kind];
            }
            catch (Exception e) {
                throw new EvalException("RNGkind: unimplemented RNG kind " + kind, new Object[0]);
            }
        }
        if (normalkindExp != Null.INSTANCE) {
            int normalkind = ((AtomicVector)normalkindExp).getElementAsInt(0);
            try {
                rng.N01_kind = N01type.values()[normalkind];
            }
            catch (Exception e) {
                throw new EvalException("invalid Normal type in RNGkind", new Object[0]);
            }
        }
        return new IntArrayVector(rng.RNG_kind.ordinal(), rng.N01_kind.ordinal());
    }

    @Internal(value="set.seed")
    public static void set_seed(@Current Context context, int seed2, SEXP kind, SEXP normalkind) {
        RNG rng = context.getSession().rng;
        rng.randomseed = seed2;
        RNG.RNGkind(context, kind, normalkind);
        switch (rng.RNG_kind) {
            case WICHMANN_HILL: {
                throw new EvalException((Object)((Object)rng.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case MARSAGLIA_MULTICARRY: {
                throw new EvalException((Object)((Object)rng.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case SUPER_DUPER: {
                throw new EvalException((Object)((Object)rng.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case MERSENNE_TWISTER: {
                if (rng.mersenneTwisterAlg == null) {
                    rng.mersenneTwisterAlg = new MersenneTwister(seed2);
                } else {
                    rng.mersenneTwisterAlg.setSeed(seed2);
                }
                return;
            }
            case KNUTH_TAOCP: 
            case KNUTH_TAOCP2: {
                throw new EvalException((Object)((Object)rng.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case USER_UNIF: {
                throw new EvalException((Object)((Object)rng.RNG_kind) + " not implemented yet", new Object[0]);
            }
        }
        throw new EvalException((Object)((Object)rng.RNG_kind) + " not implemented yet", new Object[0]);
    }

    @Internal
    public static DoubleVector runif(@Current Context context, int n, double a, double b) {
        RNG rng = context.getSession().rng;
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        for (int i = 0; i < n; ++i) {
            vb.add(a + rng.unif_rand() * (b - a));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rnorm(@Current Context context, int n, double mean2, double sd) {
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        for (int i = 0; i < n; ++i) {
            vb.add(Normal.rnorm(context.getSession(), mean2, sd));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rgamma(@Current Context context, int n, double shape, double scale) {
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        for (int i = 0; i < n; ++i) {
            vb.add(Gamma.rgamma(context.getSession(), shape, scale));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rchisq(@Current Context context, int n, double df2) {
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        for (int i = 0; i < n; ++i) {
            vb.add(ChiSquare.rchisq(context.getSession(), df2));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rnchisq(@Current Context context, int n, double df2, double ncp) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(ChiSquare.rnchisq(context.getSession(), df2, ncp));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rexp(@Current Context context, int n, double invrate) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(Exponantial.rexp(context.getSession(), invrate));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rpois(@Current Context context, int n, double mu) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(Poisson.rpois(context.getSession(), mu));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rsignrank(@Current Context context, int nn, double n) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < nn; ++i) {
            vb.add(SignRank.rsignrank(context.getSession(), n));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rwilcox(@Current Context context, int nn, double m, double n) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < nn; ++i) {
            vb.add(Wilcox.rwilcox(context.getSession(), m, n));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rgeom(@Current Context context, int n, double p) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(Geometric.rgeom(context.getSession(), p));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rt(@Current Context context, int n, double df2) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(StudentsT.rt(context.getSession(), df2));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rcauchy(@Current Context context, int n, double location, double scale) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(Cauchy.rcauchy(context.getSession(), location, scale));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rlnorm(@Current Context context, int n, double meanlog, double sdlog) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(LNorm.rlnorm(context.getSession(), meanlog, sdlog));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rlogis(@Current Context context, int n, double location, double scale) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(RLogis.rlogis(context.getSession(), location, scale));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rweibull(@Current Context context, int n, double shape, double scale) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(Weibull.rweibull(context.getSession(), shape, scale));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rnbinom(@Current Context context, int n, double size, double prob) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(NegativeBinom.rnbinom(context.getSession(), size, prob));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rnbinom_mu(@Current Context context, int n, double size, double mu) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(NegativeBinom.rnbinom_mu(context.getSession(), size, mu));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rbinom(@Current Context context, int n, double size, double prob) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(Binom.rbinom(context.getSession(), size, prob));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rf(@Current Context context, int n, double df1, double df2) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(F.rf(context.getSession(), df1, df2));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rbeta(@Current Context context, int n, double shape1, double shape2) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < n; ++i) {
            vb.add(Beta.rbeta(context.getSession(), shape1, shape2));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rhyper(@Current Context context, int nn, double m, double n, double k) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        for (int i = 0; i < nn; ++i) {
            vb.add(HyperGeometric.Random_hyper_geometric.rhyper(context.getSession(), m, n, k));
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rmultinom(@Current Context context, int n, int size, DoubleVector prob) {
        DoubleArrayVector.Builder vb = new DoubleArrayVector.Builder();
        int[] RN = new int[prob.length()];
        for (int i = 0; i < n; ++i) {
            Multinomial.rmultinom(context.getSession(), size, prob.toDoubleArray(), prob.length(), RN);
            for (int j = 0; j < prob.length(); ++j) {
                vb.add(RN[j]);
            }
        }
        vb.setAttribute(Symbols.DIM, (SEXP)new IntArrayVector(prob.length(), n));
        return vb.build();
    }

    public double unif_rand() {
        switch (this.RNG_kind) {
            case WICHMANN_HILL: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case MARSAGLIA_MULTICARRY: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case SUPER_DUPER: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case MERSENNE_TWISTER: {
                if (this.mersenneTwisterAlg == null) {
                    if (this.randomseed == 0) {
                        this.Randomize(this.RNG_kind);
                    }
                    this.mersenneTwisterAlg = new MersenneTwister(this.randomseed);
                }
                return this.mersenneTwisterAlg.nextDouble();
            }
            case KNUTH_TAOCP: 
            case KNUTH_TAOCP2: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case USER_UNIF: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
        }
        throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
    }

    public void Randomize(RNGtype kind) {
        int sseed;
        this.randomseed = sseed = (int)new Date().getTime();
        switch (this.RNG_kind) {
            case WICHMANN_HILL: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case MARSAGLIA_MULTICARRY: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case SUPER_DUPER: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case MERSENNE_TWISTER: {
                if (this.mersenneTwisterAlg == null) {
                    this.mersenneTwisterAlg = new MersenneTwister(sseed);
                } else {
                    this.mersenneTwisterAlg.setSeed(sseed);
                }
                return;
            }
            case KNUTH_TAOCP: 
            case KNUTH_TAOCP2: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case USER_UNIF: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
        }
        throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
    }
}

