/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.renjin.eval.EvalException;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListBuilder;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class AttributeMap {
    private StringVector classes = null;
    private StringVector names = null;
    private IntVector dim = null;
    private Map<Symbol, SEXP> map;
    public static boolean CATCH_DEFINED = false;
    public static final AttributeMap EMPTY = new AttributeMap();

    public static void catchDefined() {
        CATCH_DEFINED = true;
    }

    private AttributeMap() {
    }

    public Vector getDim() {
        return (Vector)((Object)(this.dim == null ? Null.INSTANCE : this.dim));
    }

    public Iterable<Symbol> names() {
        ArrayList list2 = Lists.newArrayList();
        if (this.classes != null) {
            list2.add(Symbols.CLASS);
        }
        if (this.names != null) {
            list2.add(Symbols.NAMES);
        }
        if (this.dim != null) {
            list2.add(Symbols.DIM);
        }
        if (this.map != null) {
            list2.addAll(this.map.keySet());
        }
        return list2;
    }

    public PairList asPairList() {
        PairList.Builder list2 = new PairList.Builder();
        this.addTo(list2);
        return list2.build();
    }

    public ListVector toVector() {
        ListVector.NamedBuilder list2 = new ListVector.NamedBuilder();
        this.addTo(list2);
        return list2.build();
    }

    private void addTo(ListBuilder list2) {
        if (this.classes != null) {
            list2.add(Symbols.CLASS, (SEXP)this.classes);
        }
        if (this.names != null) {
            list2.add(Symbols.NAMES, (SEXP)this.names);
        }
        if (this.dim != null) {
            list2.add(Symbols.DIM, (SEXP)this.dim);
        }
        if (this.map != null) {
            for (Map.Entry<Symbol, SEXP> entry : this.map.entrySet()) {
                list2.add(entry.getKey(), entry.getValue());
            }
        }
    }

    public SEXP get(String what) {
        return this.get(Symbol.get(what));
    }

    public boolean has(Symbol name) {
        return this.get(name) != Null.INSTANCE;
    }

    public SEXP get(Symbol name) {
        SEXP value;
        if (name == Symbols.CLASS && this.classes != null) {
            return this.classes;
        }
        if (name == Symbols.DIM && this.dim != null) {
            return this.dim;
        }
        if (name == Symbols.NAMES && this.names != null) {
            return this.names;
        }
        if (this.map != null && (value = this.map.get(name)) != null) {
            return value;
        }
        return Null.INSTANCE;
    }

    public Builder copy() {
        return new Builder(this);
    }

    public boolean hasAnyBesidesName() {
        return this.map != null || this.classes != null || this.dim != null;
    }

    public Iterable<PairList.Node> nodes() {
        return this.asPairList().nodes();
    }

    public int[] getDimArray() {
        return this.dim.toIntArray();
    }

    public Vector getDimNames() {
        if (this.map == null) {
            return Null.INSTANCE;
        }
        return (Vector)this.map.get(Symbols.DIMNAMES);
    }

    public Vector getDimNames(int i) {
        if (this.map == null) {
            return Null.INSTANCE;
        }
        Vector vector2 = (Vector)this.map.get(Symbols.DIMNAMES);
        if (vector2 instanceof ListVector) {
            return (Vector)((ListVector)vector2).getElementAsSEXP(0);
        }
        return Null.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasNames() {
        return this.names != null;
    }

    public StringVector getNames() {
        return this.names;
    }

    public boolean empty() {
        return this == EMPTY;
    }

    public boolean hasClass() {
        return this.classes != null;
    }

    public SEXP getClassVector() {
        return this.classes == null ? Null.INSTANCE : this.classes;
    }

    public AtomicVector getNamesOrNull() {
        return (AtomicVector)((Object)(this.names == null ? Null.INSTANCE : this.names));
    }

    public AttributeMap copyNames() {
        if (this.names == null) {
            return EMPTY;
        }
        AttributeMap attributes2 = new AttributeMap();
        attributes2.names = this.names;
        return attributes2;
    }

    public AttributeMap copyStructural() {
        if (this.classes == null && this.map == null) {
            return this;
        }
        if (this.dim != null || this.names != null || this.map != null && this.map.containsKey(Symbols.DIMNAMES)) {
            SEXP dimnames2;
            AttributeMap copy2 = new AttributeMap();
            copy2.dim = this.dim;
            copy2.names = this.names;
            if (this.map != null && (dimnames2 = this.map.get(Symbols.DIMNAMES)) != null) {
                copy2.map = Maps.newIdentityHashMap();
                copy2.map.put(Symbols.DIMNAMES, dimnames2);
            }
            return copy2;
        }
        return EMPTY;
    }

    public static AttributeMap combineStructural(AttributeMap a, AttributeMap b) {
        Builder builder = new Builder();
        builder.addIfNotNull(b, Symbols.DIM);
        builder.addIfNotNull(b, Symbols.NAME);
        builder.addIfNotNull(b, Symbols.DIMNAMES);
        builder.addIfNotNull(a, Symbols.DIM);
        builder.addIfNotNull(a, Symbols.NAME);
        builder.addIfNotNull(a, Symbols.DIMNAMES);
        return builder.build();
    }

    public static AttributeMap combineAttributes(Vector x, Vector y) {
        if (x.length() > y.length()) {
            return x.getAttributes();
        }
        if (y.length() > x.length()) {
            return y.getAttributes();
        }
        Builder builder = new Builder(y.getAttributes());
        builder.addAllFrom(x.getAttributes());
        return builder.build();
    }

    public static AttributeMap combineStructuralAttributes(Vector x, Vector y) {
        if (x.length() > y.length()) {
            return x.getAttributes().copyStructural();
        }
        if (y.length() > x.length()) {
            return y.getAttributes().copyStructural();
        }
        return AttributeMap.combineStructural(x.getAttributes(), y.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classes == null ? 0 : this.classes.hashCode());
        result = 31 * result + (this.dim == null ? 0 : this.dim.hashCode());
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        result = 31 * result + (this.names == null ? 0 : this.names.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeMap other = (AttributeMap)obj;
        if (this.classes == null ? other.classes != null : !this.classes.equals(other.classes)) {
            return false;
        }
        if (this.dim == null ? other.dim != null : !this.dim.equals(other.dim)) {
            return false;
        }
        if (this.map == null ? other.map != null : !this.map.equals(other.map)) {
            return false;
        }
        return !(this.names == null ? other.names != null : !this.names.equals(other.names));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static AttributeMap fromListVector(ListVector attributes2) {
        Builder builder = new Builder();
        for (int i = 0; i != attributes2.length(); ++i) {
            String attributeName = attributes2.getName(i);
            if (Strings.isNullOrEmpty((String)attributeName)) {
                throw new EvalException("Attributes must be named", new Object[0]);
            }
            SEXP attributeValue = attributes2.getElementAsSEXP(i);
            if (attributeValue == Null.INSTANCE) continue;
            builder.set(Symbol.get(attributeName), attributeValue);
        }
        return builder.build();
    }

    public static AttributeMap fromPairList(PairList list2) {
        if (list2 == Null.INSTANCE) {
            return EMPTY;
        }
        Builder attributes2 = new Builder();
        for (PairList.Node node : list2.nodes()) {
            attributes2.set(node.getTag(), node.getValue());
        }
        return attributes2.build();
    }

    public static AttributeMap dim(int row2, int col2) {
        AttributeMap map = new AttributeMap();
        map.dim = new IntArrayVector(row2, col2);
        return map;
    }

    public String getString(Symbol name) {
        SEXP value = this.get(name);
        if (value == Null.INSTANCE) {
            return null;
        }
        if (value instanceof StringVector) {
            if (value.length() == 1) {
                return ((StringVector)value).getElementAsString(0);
            }
            if (value.length() == 0) {
                return null;
            }
        }
        throw new EvalException("Expected character(1) value for attribute %s", name.getPrintName());
    }

    public String getPackage() {
        return this.getString(Symbols.PACKAGE);
    }

    public static class Builder {
        private StringVector classes = null;
        private StringVector names = null;
        private IntVector dim = null;
        private Map<Symbol, SEXP> map;
        private boolean empty = true;

        public Builder() {
        }

        private Builder(AttributeMap attributes2) {
            this.classes = attributes2.classes;
            this.names = attributes2.names;
            this.dim = attributes2.dim;
            if (attributes2.map != null) {
                this.map = new IdentityHashMap<Symbol, SEXP>(attributes2.map);
            }
            this.updateEmptyFlag();
        }

        public Builder set(String name, SEXP value) {
            return this.set(Symbol.get(name), value);
        }

        public Builder set(Symbol name, SEXP value) {
            if (CATCH_DEFINED && name.getPrintName().equals("defined")) {
                throw new EvalException(value.toString(), new Object[0]);
            }
            if (value == Null.INSTANCE) {
                return this.remove(name);
            }
            this.empty = false;
            if (name == Symbols.CLASS) {
                this.classes = (StringVector)value;
            } else if (name == Symbols.NAMES) {
                this.names = (StringVector)value;
            } else if (name == Symbols.DIM) {
                this.dim = (IntVector)value;
            } else {
                if (this.map == null) {
                    this.map = Maps.newIdentityHashMap();
                }
                this.map.put(name, value);
            }
            return this;
        }

        public Builder remove(Symbol name) {
            if (name == Symbols.CLASS) {
                this.classes = null;
            } else if (name == Symbols.NAMES) {
                this.names = null;
            } else if (name == Symbols.DIM) {
                this.dim = null;
            } else if (this.map != null) {
                this.map.remove(name);
            }
            this.updateEmptyFlag();
            return this;
        }

        private void updateEmptyFlag() {
            this.empty = this.classes == null && this.dim == null && this.names == null && (this.map == null || this.map.isEmpty());
        }

        public Builder removeDim() {
            return this.remove(Symbols.DIM);
        }

        public SEXP get(String what) {
            return this.get(Symbol.get(what));
        }

        public SEXP get(Symbol name) {
            if (name == Symbols.CLASS) {
                return this.classes;
            }
            if (name == Symbols.NAMES) {
                return this.names;
            }
            if (name == Symbols.DIM) {
                return this.dim;
            }
            if (this.map != null && this.map.containsKey(name)) {
                return this.map.get(name);
            }
            return Null.INSTANCE;
        }

        public Builder setDim(IntVector dim2) {
            this.dim = dim2;
            this.empty = false;
            return this;
        }

        public Builder setDim(int rows, int cols) {
            this.dim = new IntArrayVector(rows, cols);
            this.empty = false;
            return this;
        }

        public Builder setNames(StringVector names2) {
            this.names = names2;
            this.empty = false;
            return this;
        }

        public Builder setArrayNames(Vector names2) {
            if (names2 == Null.INSTANCE) {
                this.remove(Symbols.DIMNAMES);
            } else if (names2 instanceof StringVector) {
                this.set(Symbols.DIMNAMES, (SEXP)new ListVector(names2));
            } else {
                throw new IllegalArgumentException("" + names2);
            }
            return this;
        }

        public Builder setClass(String ... classNames) {
            this.classes = new StringArrayVector(classNames);
            this.empty = false;
            return this;
        }

        public Builder addAllFrom(AttributeMap attributes2) {
            if (attributes2.classes != null) {
                this.classes = attributes2.classes;
                this.empty = false;
            }
            if (attributes2.names != null) {
                this.names = attributes2.names;
                this.empty = false;
            }
            if (attributes2.dim != null) {
                this.dim = attributes2.dim;
                this.empty = false;
            }
            if (attributes2.map != null) {
                for (Map.Entry entry : attributes2.map.entrySet()) {
                    if (this.map == null) {
                        this.map = Maps.newIdentityHashMap();
                    }
                    this.map.put((Symbol)entry.getKey(), (SEXP)entry.getValue());
                    this.empty = false;
                }
            }
            return this;
        }

        public Builder addIfNotNull(AttributeMap source, Symbol symbol2) {
            SEXP value = source.get(symbol2);
            if (value != Null.INSTANCE) {
                this.set(symbol2, value);
            }
            return this;
        }

        public AttributeMap build() {
            if (this.empty) {
                return EMPTY;
            }
            AttributeMap attributes2 = new AttributeMap();
            attributes2.classes = this.classes;
            attributes2.names = this.names;
            attributes2.dim = this.dim;
            if (this.map != null && !this.map.isEmpty()) {
                attributes2.map = this.map;
            }
            return attributes2;
        }
    }
}

