/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler;

import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.renjin.compiler.CompiledNames;
import org.renjin.compiler.ConstantGeneratingVisitor;
import org.renjin.invoke.codegen.WrapperGenerator2;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class PackageLoaderCompiler
implements Opcodes {
    private static final int THIS = 0;
    private static final int CONTEXT = 1;
    private static final int ENVIRONMENT = 2;

    public static byte[] compile(String packageName, Environment packageEnvironment) {
        ClassWriter cw = new ClassWriter(2);
        cw.visit(50, 33, CompiledNames.loaderClassName(packageName), null, "java/lang/Object", new String[]{"org/renjin/compiler/runtime/PackageLoader"});
        PackageLoaderCompiler.writeInit(cw);
        PackageLoaderCompiler.writeLoadMethod(cw, packageName, packageEnvironment);
        return cw.toByteArray();
    }

    private static void writeInit(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void writeLoadMethod(ClassWriter cw, String packageName, Environment rho) {
        MethodVisitor mv = cw.visitMethod(1, "load", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Environment;)V", null, null);
        mv.visitCode();
        for (Symbol symbol2 : rho.getSymbolNames()) {
            SEXP value = rho.getVariable(symbol2);
            try {
                if (value instanceof Closure) {
                    PackageLoaderCompiler.storeClosure(mv, packageName, symbol2);
                    continue;
                }
                PackageLoaderCompiler.storeConstant(mv, symbol2, rho.getVariable(symbol2));
            }
            catch (Exception e) {
                throw new RuntimeException("Error generating code for '" + symbol2 + "'", e);
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void storeClosure(MethodVisitor mv, String packageName, Symbol symbol2) {
        mv.visitVarInsn(25, 2);
        mv.visitLdcInsn((Object)symbol2.getPrintName());
        mv.visitTypeInsn(187, "org/renjin/compiler/runtime/PromisedFunction");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitLdcInsn((Object)PackageLoaderCompiler.functionClassName(packageName, symbol2));
        mv.visitMethodInsn(183, "org/renjin/compiler/runtime/PromisedFunction", "<init>", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Environment;Ljava/lang/String;)V");
        mv.visitMethodInsn(182, "org/renjin/sexp/Environment", "setVariable", "(Ljava/lang/String;Lorg/renjin/sexp/SEXP;)V");
    }

    private static void storeConstant(MethodVisitor mv, Symbol symbol2, SEXP value) {
        mv.visitVarInsn(25, 2);
        mv.visitLdcInsn((Object)symbol2.getPrintName());
        ConstantGeneratingVisitor cgv = new ConstantGeneratingVisitor(mv);
        value.accept(cgv);
    }

    private static String functionClassName(String packageName, Symbol symbol2) {
        return packageName.replace('/', '.') + "." + WrapperGenerator2.toJavaName("", symbol2.getPrintName());
    }
}

